/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.AVComponentDescriptor;
import com.twilight.h264.decoder.AVPixFmtDescriptor;
import com.twilight.h264.decoder.PixFmtYUV420P;
import com.twilight.h264.util.Arrays;

public class ImageUtils {
    public static final int PIX_FMT_BE = 1;
    public static final int PIX_FMT_PAL = 2;
    public static final int PIX_FMT_BITSTREAM = 4;
    public static final int PIX_FMT_HWACCEL = 8;
    public static AVPixFmtDescriptor[] av_pix_fmt_descriptors;

    static {
        AVPixFmtDescriptor[] aVPixFmtDescriptorArray = new AVPixFmtDescriptor[2];
        aVPixFmtDescriptorArray[1] = new PixFmtYUV420P();
        av_pix_fmt_descriptors = aVPixFmtDescriptorArray;
    }

    public static void av_image_copy(int[][] dst_base, int[] dst_offset, int[] dst_linesizes, int[][] src_base, int[] src_offset, int[] src_linesizes, int pix_fmt, int width, int height) {
        AVPixFmtDescriptor desc = av_pix_fmt_descriptors[pix_fmt];
        if ((desc.flags & 2) != 0) {
            ImageUtils.av_image_copy_plane(dst_base[0], dst_offset[0], dst_linesizes[0], src_base[0], src_offset[0], src_linesizes[0], width, height);
            System.arraycopy(src_base[1], src_offset[1], dst_base[1], dst_offset[1], 1024);
        } else {
            int planes_nb = 0;
            int i = 0;
            while (i < desc.nb_components) {
                planes_nb = Math.max(planes_nb, desc.comp[i].plane + 1);
                ++i;
            }
            i = 0;
            while (i < planes_nb) {
                int h = height;
                int bwidth = ImageUtils.av_image_get_linesize(pix_fmt, width, i);
                if (i == 1 || i == 2) {
                    h = -(-height >> desc.log2_chroma_h);
                }
                ImageUtils.av_image_copy_plane(dst_base[i], dst_offset[i], dst_linesizes[i], src_base[i], src_offset[i], src_linesizes[i], bwidth, h);
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void av_image_copy_plane(int[] dst, int _dst_offset, int dst_linesize, int[] src, int _src_offset, int src_linesize, int bytewidth, int height) {
        dst_offset = _dst_offset;
        src_offset = _src_offset;
        if (dst != null && src != null) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            System.arraycopy(src, src_offset, dst, dst_offset, bytewidth);
            dst_offset += dst_linesize;
            src_offset += src_linesize;
            --height;
lbl9:
            // 2 sources

            ** while (height > 0)
        }
lbl10:
        // 1 sources

    }

    public static int av_image_get_linesize(int pix_fmt, int width, int plane) {
        AVPixFmtDescriptor desc = av_pix_fmt_descriptors[pix_fmt];
        int[] max_step = new int[4];
        int[] max_step_comp = new int[4];
        if ((desc.flags & 4) != 0) {
            return width * (desc.comp[0].step_minus1 + 1) + 7 >> 3;
        }
        ImageUtils.av_image_fill_max_pixsteps(max_step, max_step_comp, desc);
        int s = max_step_comp[plane] == 1 || max_step_comp[plane] == 2 ? desc.log2_chroma_w : 0;
        return max_step[plane] * (width + (1 << s) - 1 >> s);
    }

    public static void av_image_fill_max_pixsteps(int[] max_pixsteps, int[] max_pixstep_comps, AVPixFmtDescriptor pixdesc) {
        Arrays.fill(max_pixsteps, 0, 4, 0);
        if (max_pixstep_comps != null) {
            Arrays.fill(max_pixstep_comps, 0, 4, 0);
        }
        int i = 0;
        while (i < 4) {
            AVComponentDescriptor comp = pixdesc.comp[i];
            if (comp.step_minus1 + 1 > max_pixsteps[comp.plane]) {
                max_pixsteps[comp.plane] = comp.step_minus1 + 1;
                if (max_pixstep_comps != null) {
                    max_pixstep_comps[comp.plane] = i;
                }
            }
            ++i;
        }
    }
}

