/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.CAVLCContext;
import com.twilight.h264.decoder.VLC;
import com.twilight.h264.decoder.VLCcode;

public class GetBitContext {
    public static final int MIN_CACHE_BITS = 25;
    public static final int INIT_VLC_LE = 2;
    public static final int INIT_VLC_USE_NEW_STATIC = 4;
    public static final int[] av_reverse;
    public static final int[] ff_golomb_vlc_len;
    public static final int[] ff_ue_golomb_vlc_code;
    public static final int[] ff_se_golomb_vlc_code;
    public static final int[] ff_ue_golomb_len;
    public int[] buffer;
    public int buffer_offset;
    public int buffer_end;
    public int index;
    public long cache;
    public long cache0;
    public long cache1;
    public int size_in_bits;

    static {
        int[] nArray = new int[256];
        nArray[1] = 128;
        nArray[2] = 64;
        nArray[3] = 192;
        nArray[4] = 32;
        nArray[5] = 160;
        nArray[6] = 96;
        nArray[7] = 224;
        nArray[8] = 16;
        nArray[9] = 144;
        nArray[10] = 80;
        nArray[11] = 208;
        nArray[12] = 48;
        nArray[13] = 176;
        nArray[14] = 112;
        nArray[15] = 240;
        nArray[16] = 8;
        nArray[17] = 136;
        nArray[18] = 72;
        nArray[19] = 200;
        nArray[20] = 40;
        nArray[21] = 168;
        nArray[22] = 104;
        nArray[23] = 232;
        nArray[24] = 24;
        nArray[25] = 152;
        nArray[26] = 88;
        nArray[27] = 216;
        nArray[28] = 56;
        nArray[29] = 184;
        nArray[30] = 120;
        nArray[31] = 248;
        nArray[32] = 4;
        nArray[33] = 132;
        nArray[34] = 68;
        nArray[35] = 196;
        nArray[36] = 36;
        nArray[37] = 164;
        nArray[38] = 100;
        nArray[39] = 228;
        nArray[40] = 20;
        nArray[41] = 148;
        nArray[42] = 84;
        nArray[43] = 212;
        nArray[44] = 52;
        nArray[45] = 180;
        nArray[46] = 116;
        nArray[47] = 244;
        nArray[48] = 12;
        nArray[49] = 140;
        nArray[50] = 76;
        nArray[51] = 204;
        nArray[52] = 44;
        nArray[53] = 172;
        nArray[54] = 108;
        nArray[55] = 236;
        nArray[56] = 28;
        nArray[57] = 156;
        nArray[58] = 92;
        nArray[59] = 220;
        nArray[60] = 60;
        nArray[61] = 188;
        nArray[62] = 124;
        nArray[63] = 252;
        nArray[64] = 2;
        nArray[65] = 130;
        nArray[66] = 66;
        nArray[67] = 194;
        nArray[68] = 34;
        nArray[69] = 162;
        nArray[70] = 98;
        nArray[71] = 226;
        nArray[72] = 18;
        nArray[73] = 146;
        nArray[74] = 82;
        nArray[75] = 210;
        nArray[76] = 50;
        nArray[77] = 178;
        nArray[78] = 114;
        nArray[79] = 242;
        nArray[80] = 10;
        nArray[81] = 138;
        nArray[82] = 74;
        nArray[83] = 202;
        nArray[84] = 42;
        nArray[85] = 170;
        nArray[86] = 106;
        nArray[87] = 234;
        nArray[88] = 26;
        nArray[89] = 154;
        nArray[90] = 90;
        nArray[91] = 218;
        nArray[92] = 58;
        nArray[93] = 186;
        nArray[94] = 122;
        nArray[95] = 250;
        nArray[96] = 6;
        nArray[97] = 134;
        nArray[98] = 70;
        nArray[99] = 198;
        nArray[100] = 38;
        nArray[101] = 166;
        nArray[102] = 102;
        nArray[103] = 230;
        nArray[104] = 22;
        nArray[105] = 150;
        nArray[106] = 86;
        nArray[107] = 214;
        nArray[108] = 54;
        nArray[109] = 182;
        nArray[110] = 118;
        nArray[111] = 246;
        nArray[112] = 14;
        nArray[113] = 142;
        nArray[114] = 78;
        nArray[115] = 206;
        nArray[116] = 46;
        nArray[117] = 174;
        nArray[118] = 110;
        nArray[119] = 238;
        nArray[120] = 30;
        nArray[121] = 158;
        nArray[122] = 94;
        nArray[123] = 222;
        nArray[124] = 62;
        nArray[125] = 190;
        nArray[126] = 126;
        nArray[127] = 254;
        nArray[128] = 1;
        nArray[129] = 129;
        nArray[130] = 65;
        nArray[131] = 193;
        nArray[132] = 33;
        nArray[133] = 161;
        nArray[134] = 97;
        nArray[135] = 225;
        nArray[136] = 17;
        nArray[137] = 145;
        nArray[138] = 81;
        nArray[139] = 209;
        nArray[140] = 49;
        nArray[141] = 177;
        nArray[142] = 113;
        nArray[143] = 241;
        nArray[144] = 9;
        nArray[145] = 137;
        nArray[146] = 73;
        nArray[147] = 201;
        nArray[148] = 41;
        nArray[149] = 169;
        nArray[150] = 105;
        nArray[151] = 233;
        nArray[152] = 25;
        nArray[153] = 153;
        nArray[154] = 89;
        nArray[155] = 217;
        nArray[156] = 57;
        nArray[157] = 185;
        nArray[158] = 121;
        nArray[159] = 249;
        nArray[160] = 5;
        nArray[161] = 133;
        nArray[162] = 69;
        nArray[163] = 197;
        nArray[164] = 37;
        nArray[165] = 165;
        nArray[166] = 101;
        nArray[167] = 229;
        nArray[168] = 21;
        nArray[169] = 149;
        nArray[170] = 85;
        nArray[171] = 213;
        nArray[172] = 53;
        nArray[173] = 181;
        nArray[174] = 117;
        nArray[175] = 245;
        nArray[176] = 13;
        nArray[177] = 141;
        nArray[178] = 77;
        nArray[179] = 205;
        nArray[180] = 45;
        nArray[181] = 173;
        nArray[182] = 109;
        nArray[183] = 237;
        nArray[184] = 29;
        nArray[185] = 157;
        nArray[186] = 93;
        nArray[187] = 221;
        nArray[188] = 61;
        nArray[189] = 189;
        nArray[190] = 125;
        nArray[191] = 253;
        nArray[192] = 3;
        nArray[193] = 131;
        nArray[194] = 67;
        nArray[195] = 195;
        nArray[196] = 35;
        nArray[197] = 163;
        nArray[198] = 99;
        nArray[199] = 227;
        nArray[200] = 19;
        nArray[201] = 147;
        nArray[202] = 83;
        nArray[203] = 211;
        nArray[204] = 51;
        nArray[205] = 179;
        nArray[206] = 115;
        nArray[207] = 243;
        nArray[208] = 11;
        nArray[209] = 139;
        nArray[210] = 75;
        nArray[211] = 203;
        nArray[212] = 43;
        nArray[213] = 171;
        nArray[214] = 107;
        nArray[215] = 235;
        nArray[216] = 27;
        nArray[217] = 155;
        nArray[218] = 91;
        nArray[219] = 219;
        nArray[220] = 59;
        nArray[221] = 187;
        nArray[222] = 123;
        nArray[223] = 251;
        nArray[224] = 7;
        nArray[225] = 135;
        nArray[226] = 71;
        nArray[227] = 199;
        nArray[228] = 39;
        nArray[229] = 167;
        nArray[230] = 103;
        nArray[231] = 231;
        nArray[232] = 23;
        nArray[233] = 151;
        nArray[234] = 87;
        nArray[235] = 215;
        nArray[236] = 55;
        nArray[237] = 183;
        nArray[238] = 119;
        nArray[239] = 247;
        nArray[240] = 15;
        nArray[241] = 143;
        nArray[242] = 79;
        nArray[243] = 207;
        nArray[244] = 47;
        nArray[245] = 175;
        nArray[246] = 111;
        nArray[247] = 239;
        nArray[248] = 31;
        nArray[249] = 159;
        nArray[250] = 95;
        nArray[251] = 223;
        nArray[252] = 63;
        nArray[253] = 191;
        nArray[254] = 127;
        nArray[255] = 255;
        av_reverse = nArray;
        ff_golomb_vlc_len = new int[]{19, 17, 15, 15, 13, 13, 13, 13, 11, 11, 11, 11, 11, 11, 11, 11, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray2 = new int[512];
        nArray2[0] = 32;
        nArray2[1] = 32;
        nArray2[2] = 32;
        nArray2[3] = 32;
        nArray2[4] = 32;
        nArray2[5] = 32;
        nArray2[6] = 32;
        nArray2[7] = 32;
        nArray2[8] = 31;
        nArray2[9] = 32;
        nArray2[10] = 32;
        nArray2[11] = 32;
        nArray2[12] = 32;
        nArray2[13] = 32;
        nArray2[14] = 32;
        nArray2[15] = 32;
        nArray2[16] = 15;
        nArray2[17] = 16;
        nArray2[18] = 17;
        nArray2[19] = 18;
        nArray2[20] = 19;
        nArray2[21] = 20;
        nArray2[22] = 21;
        nArray2[23] = 22;
        nArray2[24] = 23;
        nArray2[25] = 24;
        nArray2[26] = 25;
        nArray2[27] = 26;
        nArray2[28] = 27;
        nArray2[29] = 28;
        nArray2[30] = 29;
        nArray2[31] = 30;
        nArray2[32] = 7;
        nArray2[33] = 7;
        nArray2[34] = 7;
        nArray2[35] = 7;
        nArray2[36] = 8;
        nArray2[37] = 8;
        nArray2[38] = 8;
        nArray2[39] = 8;
        nArray2[40] = 9;
        nArray2[41] = 9;
        nArray2[42] = 9;
        nArray2[43] = 9;
        nArray2[44] = 10;
        nArray2[45] = 10;
        nArray2[46] = 10;
        nArray2[47] = 10;
        nArray2[48] = 11;
        nArray2[49] = 11;
        nArray2[50] = 11;
        nArray2[51] = 11;
        nArray2[52] = 12;
        nArray2[53] = 12;
        nArray2[54] = 12;
        nArray2[55] = 12;
        nArray2[56] = 13;
        nArray2[57] = 13;
        nArray2[58] = 13;
        nArray2[59] = 13;
        nArray2[60] = 14;
        nArray2[61] = 14;
        nArray2[62] = 14;
        nArray2[63] = 14;
        nArray2[64] = 3;
        nArray2[65] = 3;
        nArray2[66] = 3;
        nArray2[67] = 3;
        nArray2[68] = 3;
        nArray2[69] = 3;
        nArray2[70] = 3;
        nArray2[71] = 3;
        nArray2[72] = 3;
        nArray2[73] = 3;
        nArray2[74] = 3;
        nArray2[75] = 3;
        nArray2[76] = 3;
        nArray2[77] = 3;
        nArray2[78] = 3;
        nArray2[79] = 3;
        nArray2[80] = 4;
        nArray2[81] = 4;
        nArray2[82] = 4;
        nArray2[83] = 4;
        nArray2[84] = 4;
        nArray2[85] = 4;
        nArray2[86] = 4;
        nArray2[87] = 4;
        nArray2[88] = 4;
        nArray2[89] = 4;
        nArray2[90] = 4;
        nArray2[91] = 4;
        nArray2[92] = 4;
        nArray2[93] = 4;
        nArray2[94] = 4;
        nArray2[95] = 4;
        nArray2[96] = 5;
        nArray2[97] = 5;
        nArray2[98] = 5;
        nArray2[99] = 5;
        nArray2[100] = 5;
        nArray2[101] = 5;
        nArray2[102] = 5;
        nArray2[103] = 5;
        nArray2[104] = 5;
        nArray2[105] = 5;
        nArray2[106] = 5;
        nArray2[107] = 5;
        nArray2[108] = 5;
        nArray2[109] = 5;
        nArray2[110] = 5;
        nArray2[111] = 5;
        nArray2[112] = 6;
        nArray2[113] = 6;
        nArray2[114] = 6;
        nArray2[115] = 6;
        nArray2[116] = 6;
        nArray2[117] = 6;
        nArray2[118] = 6;
        nArray2[119] = 6;
        nArray2[120] = 6;
        nArray2[121] = 6;
        nArray2[122] = 6;
        nArray2[123] = 6;
        nArray2[124] = 6;
        nArray2[125] = 6;
        nArray2[126] = 6;
        nArray2[127] = 6;
        nArray2[128] = 1;
        nArray2[129] = 1;
        nArray2[130] = 1;
        nArray2[131] = 1;
        nArray2[132] = 1;
        nArray2[133] = 1;
        nArray2[134] = 1;
        nArray2[135] = 1;
        nArray2[136] = 1;
        nArray2[137] = 1;
        nArray2[138] = 1;
        nArray2[139] = 1;
        nArray2[140] = 1;
        nArray2[141] = 1;
        nArray2[142] = 1;
        nArray2[143] = 1;
        nArray2[144] = 1;
        nArray2[145] = 1;
        nArray2[146] = 1;
        nArray2[147] = 1;
        nArray2[148] = 1;
        nArray2[149] = 1;
        nArray2[150] = 1;
        nArray2[151] = 1;
        nArray2[152] = 1;
        nArray2[153] = 1;
        nArray2[154] = 1;
        nArray2[155] = 1;
        nArray2[156] = 1;
        nArray2[157] = 1;
        nArray2[158] = 1;
        nArray2[159] = 1;
        nArray2[160] = 1;
        nArray2[161] = 1;
        nArray2[162] = 1;
        nArray2[163] = 1;
        nArray2[164] = 1;
        nArray2[165] = 1;
        nArray2[166] = 1;
        nArray2[167] = 1;
        nArray2[168] = 1;
        nArray2[169] = 1;
        nArray2[170] = 1;
        nArray2[171] = 1;
        nArray2[172] = 1;
        nArray2[173] = 1;
        nArray2[174] = 1;
        nArray2[175] = 1;
        nArray2[176] = 1;
        nArray2[177] = 1;
        nArray2[178] = 1;
        nArray2[179] = 1;
        nArray2[180] = 1;
        nArray2[181] = 1;
        nArray2[182] = 1;
        nArray2[183] = 1;
        nArray2[184] = 1;
        nArray2[185] = 1;
        nArray2[186] = 1;
        nArray2[187] = 1;
        nArray2[188] = 1;
        nArray2[189] = 1;
        nArray2[190] = 1;
        nArray2[191] = 1;
        nArray2[192] = 2;
        nArray2[193] = 2;
        nArray2[194] = 2;
        nArray2[195] = 2;
        nArray2[196] = 2;
        nArray2[197] = 2;
        nArray2[198] = 2;
        nArray2[199] = 2;
        nArray2[200] = 2;
        nArray2[201] = 2;
        nArray2[202] = 2;
        nArray2[203] = 2;
        nArray2[204] = 2;
        nArray2[205] = 2;
        nArray2[206] = 2;
        nArray2[207] = 2;
        nArray2[208] = 2;
        nArray2[209] = 2;
        nArray2[210] = 2;
        nArray2[211] = 2;
        nArray2[212] = 2;
        nArray2[213] = 2;
        nArray2[214] = 2;
        nArray2[215] = 2;
        nArray2[216] = 2;
        nArray2[217] = 2;
        nArray2[218] = 2;
        nArray2[219] = 2;
        nArray2[220] = 2;
        nArray2[221] = 2;
        nArray2[222] = 2;
        nArray2[223] = 2;
        nArray2[224] = 2;
        nArray2[225] = 2;
        nArray2[226] = 2;
        nArray2[227] = 2;
        nArray2[228] = 2;
        nArray2[229] = 2;
        nArray2[230] = 2;
        nArray2[231] = 2;
        nArray2[232] = 2;
        nArray2[233] = 2;
        nArray2[234] = 2;
        nArray2[235] = 2;
        nArray2[236] = 2;
        nArray2[237] = 2;
        nArray2[238] = 2;
        nArray2[239] = 2;
        nArray2[240] = 2;
        nArray2[241] = 2;
        nArray2[242] = 2;
        nArray2[243] = 2;
        nArray2[244] = 2;
        nArray2[245] = 2;
        nArray2[246] = 2;
        nArray2[247] = 2;
        nArray2[248] = 2;
        nArray2[249] = 2;
        nArray2[250] = 2;
        nArray2[251] = 2;
        nArray2[252] = 2;
        nArray2[253] = 2;
        nArray2[254] = 2;
        nArray2[255] = 2;
        ff_ue_golomb_vlc_code = nArray2;
        int[] nArray3 = new int[512];
        nArray3[0] = 17;
        nArray3[1] = 17;
        nArray3[2] = 17;
        nArray3[3] = 17;
        nArray3[4] = 17;
        nArray3[5] = 17;
        nArray3[6] = 17;
        nArray3[7] = 17;
        nArray3[8] = 16;
        nArray3[9] = 17;
        nArray3[10] = 17;
        nArray3[11] = 17;
        nArray3[12] = 17;
        nArray3[13] = 17;
        nArray3[14] = 17;
        nArray3[15] = 17;
        nArray3[16] = 8;
        nArray3[17] = -8;
        nArray3[18] = 9;
        nArray3[19] = -9;
        nArray3[20] = 10;
        nArray3[21] = -10;
        nArray3[22] = 11;
        nArray3[23] = -11;
        nArray3[24] = 12;
        nArray3[25] = -12;
        nArray3[26] = 13;
        nArray3[27] = -13;
        nArray3[28] = 14;
        nArray3[29] = -14;
        nArray3[30] = 15;
        nArray3[31] = -15;
        nArray3[32] = 4;
        nArray3[33] = 4;
        nArray3[34] = 4;
        nArray3[35] = 4;
        nArray3[36] = -4;
        nArray3[37] = -4;
        nArray3[38] = -4;
        nArray3[39] = -4;
        nArray3[40] = 5;
        nArray3[41] = 5;
        nArray3[42] = 5;
        nArray3[43] = 5;
        nArray3[44] = -5;
        nArray3[45] = -5;
        nArray3[46] = -5;
        nArray3[47] = -5;
        nArray3[48] = 6;
        nArray3[49] = 6;
        nArray3[50] = 6;
        nArray3[51] = 6;
        nArray3[52] = -6;
        nArray3[53] = -6;
        nArray3[54] = -6;
        nArray3[55] = -6;
        nArray3[56] = 7;
        nArray3[57] = 7;
        nArray3[58] = 7;
        nArray3[59] = 7;
        nArray3[60] = -7;
        nArray3[61] = -7;
        nArray3[62] = -7;
        nArray3[63] = -7;
        nArray3[64] = 2;
        nArray3[65] = 2;
        nArray3[66] = 2;
        nArray3[67] = 2;
        nArray3[68] = 2;
        nArray3[69] = 2;
        nArray3[70] = 2;
        nArray3[71] = 2;
        nArray3[72] = 2;
        nArray3[73] = 2;
        nArray3[74] = 2;
        nArray3[75] = 2;
        nArray3[76] = 2;
        nArray3[77] = 2;
        nArray3[78] = 2;
        nArray3[79] = 2;
        nArray3[80] = -2;
        nArray3[81] = -2;
        nArray3[82] = -2;
        nArray3[83] = -2;
        nArray3[84] = -2;
        nArray3[85] = -2;
        nArray3[86] = -2;
        nArray3[87] = -2;
        nArray3[88] = -2;
        nArray3[89] = -2;
        nArray3[90] = -2;
        nArray3[91] = -2;
        nArray3[92] = -2;
        nArray3[93] = -2;
        nArray3[94] = -2;
        nArray3[95] = -2;
        nArray3[96] = 3;
        nArray3[97] = 3;
        nArray3[98] = 3;
        nArray3[99] = 3;
        nArray3[100] = 3;
        nArray3[101] = 3;
        nArray3[102] = 3;
        nArray3[103] = 3;
        nArray3[104] = 3;
        nArray3[105] = 3;
        nArray3[106] = 3;
        nArray3[107] = 3;
        nArray3[108] = 3;
        nArray3[109] = 3;
        nArray3[110] = 3;
        nArray3[111] = 3;
        nArray3[112] = -3;
        nArray3[113] = -3;
        nArray3[114] = -3;
        nArray3[115] = -3;
        nArray3[116] = -3;
        nArray3[117] = -3;
        nArray3[118] = -3;
        nArray3[119] = -3;
        nArray3[120] = -3;
        nArray3[121] = -3;
        nArray3[122] = -3;
        nArray3[123] = -3;
        nArray3[124] = -3;
        nArray3[125] = -3;
        nArray3[126] = -3;
        nArray3[127] = -3;
        nArray3[128] = 1;
        nArray3[129] = 1;
        nArray3[130] = 1;
        nArray3[131] = 1;
        nArray3[132] = 1;
        nArray3[133] = 1;
        nArray3[134] = 1;
        nArray3[135] = 1;
        nArray3[136] = 1;
        nArray3[137] = 1;
        nArray3[138] = 1;
        nArray3[139] = 1;
        nArray3[140] = 1;
        nArray3[141] = 1;
        nArray3[142] = 1;
        nArray3[143] = 1;
        nArray3[144] = 1;
        nArray3[145] = 1;
        nArray3[146] = 1;
        nArray3[147] = 1;
        nArray3[148] = 1;
        nArray3[149] = 1;
        nArray3[150] = 1;
        nArray3[151] = 1;
        nArray3[152] = 1;
        nArray3[153] = 1;
        nArray3[154] = 1;
        nArray3[155] = 1;
        nArray3[156] = 1;
        nArray3[157] = 1;
        nArray3[158] = 1;
        nArray3[159] = 1;
        nArray3[160] = 1;
        nArray3[161] = 1;
        nArray3[162] = 1;
        nArray3[163] = 1;
        nArray3[164] = 1;
        nArray3[165] = 1;
        nArray3[166] = 1;
        nArray3[167] = 1;
        nArray3[168] = 1;
        nArray3[169] = 1;
        nArray3[170] = 1;
        nArray3[171] = 1;
        nArray3[172] = 1;
        nArray3[173] = 1;
        nArray3[174] = 1;
        nArray3[175] = 1;
        nArray3[176] = 1;
        nArray3[177] = 1;
        nArray3[178] = 1;
        nArray3[179] = 1;
        nArray3[180] = 1;
        nArray3[181] = 1;
        nArray3[182] = 1;
        nArray3[183] = 1;
        nArray3[184] = 1;
        nArray3[185] = 1;
        nArray3[186] = 1;
        nArray3[187] = 1;
        nArray3[188] = 1;
        nArray3[189] = 1;
        nArray3[190] = 1;
        nArray3[191] = 1;
        nArray3[192] = -1;
        nArray3[193] = -1;
        nArray3[194] = -1;
        nArray3[195] = -1;
        nArray3[196] = -1;
        nArray3[197] = -1;
        nArray3[198] = -1;
        nArray3[199] = -1;
        nArray3[200] = -1;
        nArray3[201] = -1;
        nArray3[202] = -1;
        nArray3[203] = -1;
        nArray3[204] = -1;
        nArray3[205] = -1;
        nArray3[206] = -1;
        nArray3[207] = -1;
        nArray3[208] = -1;
        nArray3[209] = -1;
        nArray3[210] = -1;
        nArray3[211] = -1;
        nArray3[212] = -1;
        nArray3[213] = -1;
        nArray3[214] = -1;
        nArray3[215] = -1;
        nArray3[216] = -1;
        nArray3[217] = -1;
        nArray3[218] = -1;
        nArray3[219] = -1;
        nArray3[220] = -1;
        nArray3[221] = -1;
        nArray3[222] = -1;
        nArray3[223] = -1;
        nArray3[224] = -1;
        nArray3[225] = -1;
        nArray3[226] = -1;
        nArray3[227] = -1;
        nArray3[228] = -1;
        nArray3[229] = -1;
        nArray3[230] = -1;
        nArray3[231] = -1;
        nArray3[232] = -1;
        nArray3[233] = -1;
        nArray3[234] = -1;
        nArray3[235] = -1;
        nArray3[236] = -1;
        nArray3[237] = -1;
        nArray3[238] = -1;
        nArray3[239] = -1;
        nArray3[240] = -1;
        nArray3[241] = -1;
        nArray3[242] = -1;
        nArray3[243] = -1;
        nArray3[244] = -1;
        nArray3[245] = -1;
        nArray3[246] = -1;
        nArray3[247] = -1;
        nArray3[248] = -1;
        nArray3[249] = -1;
        nArray3[250] = -1;
        nArray3[251] = -1;
        nArray3[252] = -1;
        nArray3[253] = -1;
        nArray3[254] = -1;
        nArray3[255] = -1;
        ff_se_golomb_vlc_code = nArray3;
        ff_ue_golomb_len = new int[]{1, 3, 3, 5, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 17};
    }

    public static final long bitswap_32(long x) {
        return av_reverse[(int)(x & 0xFFL)] << 24 | av_reverse[(int)(x >>> 8 & 0xFFL)] << 16 | av_reverse[(int)(x >>> 16 & 0xFFL)] << 8 | av_reverse[(int)(x >>> 24)];
    }

    public GetBitContext makeCopy() {
        GetBitContext ret = new GetBitContext();
        ret.buffer = this.buffer;
        ret.buffer_offset = this.buffer_offset;
        ret.buffer_end = this.buffer_end;
        ret.index = this.index;
        ret.cache = this.cache;
        ret.cache0 = this.cache0;
        ret.cache1 = this.cache1;
        ret.size_in_bits = this.size_in_bits;
        return ret;
    }

    public int get_bits_count() {
        return this.index;
    }

    public void skip_bits_long(int n) {
        this.index += n;
    }

    public int get_xbits(int n) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long cache = re_cache &= 0xFFFFFFFFL;
        int sign = (int)((cache ^ 0xFFFFFFFFFFFFFFFFL) >> 63);
        this.index = re_index += n;
        return ((int)((long)sign ^ cache) >> 32 - n ^ sign) - sign;
    }

    public int get_sbits(int n) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        int tmp = (int)(re_cache &= 0xFFFFFFFFL) >> 32 - n;
        this.index = re_index += n;
        return tmp;
    }

    public long get_bits(int n, String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long tmp = (re_cache &= 0xFFFFFFFFL) >> 32 - n;
        this.index = re_index += n;
        return tmp;
    }

    public long show_bits(int n) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long tmp = (re_cache &= 0xFFFFFFFFL) >> 32 - n;
        return tmp;
    }

    public void skip_bits(int n) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        re_cache &= 0xFFFFFFFFL;
        this.index = re_index += n;
    }

    public long get_bits1(String message) {
        int index = this.index;
        int result = this.buffer[this.buffer_offset + (index >> 3)];
        result <<= (index & 7) + 24;
        this.index = ++index;
        return (result >>= 31) != 0 ? 1 : 0;
    }

    public long show_bits1() {
        return this.show_bits(1);
    }

    public void skip_bits1() {
        this.skip_bits(1);
    }

    public long get_bits_long(int n, String message) {
        if (n <= 25) {
            return this.get_bits(n, message);
        }
        long ret = this.get_bits(16, message) << n - 16;
        long ret2 = this.get_bits(n - 16, message);
        return ret | ret2;
    }

    public int get_sbits_long(int n, String message) {
        return (int)this.get_bits_long(n, message) << 32 - n >> 32 - n;
    }

    public long show_bits_long(int n) {
        if (n <= 25) {
            return this.show_bits(n);
        }
        GetBitContext gb = this.makeCopy();
        return gb.get_bits_long(n, "");
    }

    public long check_marker(String msg) {
        long bit = this.get_bits1(msg);
        if (bit == 0L) {
            System.err.println("Marker bit missing: " + msg);
        }
        return bit;
    }

    public void init_get_bits(int[] buffer, int buffer_offset, int bit_size) {
        int buffer_size = bit_size + 7 >> 3;
        if (buffer_size < 0 || bit_size < 0) {
            bit_size = 0;
            buffer_size = 0;
            buffer = null;
        }
        this.buffer = buffer;
        this.buffer_offset = buffer_offset;
        this.size_in_bits = bit_size;
        this.buffer_end = buffer_offset + buffer_size;
        this.index = 0;
    }

    public void align_get_bits() {
        int n = -this.get_bits_count() & 7;
        if (n != 0) {
            this.skip_bits(n);
        }
    }

    public long decode012() {
        long n = this.get_bits1("");
        if (n == 0L) {
            return 0L;
        }
        return this.get_bits1("") + 1L;
    }

    public long decode210() {
        if (this.get_bits1("") != 0L) {
            return 0L;
        }
        return 2L - this.get_bits1("");
    }

    public int get_bits_left() {
        return this.size_in_bits - this.get_bits_count();
    }

    public static int alloc_table(VLC vlc, int size, int use_static) {
        int index = vlc.table_size;
        vlc.table_size += size;
        if (vlc.table_size > vlc.table_allocated) {
            if (use_static != 0) {
                return 0;
            }
            vlc.table_allocated += 1 << vlc.bits;
            short[][] newTab = new short[2 * vlc.table_allocated][2];
            int i = 0;
            while (i < vlc.table_base.length) {
                newTab[i][0] = vlc.table_base[i][0];
                newTab[i][1] = vlc.table_base[i][1];
                ++i;
            }
            vlc.table_base = newTab;
            if (vlc.table_base == null) {
                return -1;
            }
        }
        return index;
    }

    public static int build_table(VLC vlc, int table_nb_bits, int nb_codes, VLCcode[] codes_base, int codes_offset, int flags) {
        int table_size = 1 << table_nb_bits;
        int table_index = GetBitContext.alloc_table(vlc, table_size, flags & 4);
        if (table_index < 0) {
            return -1;
        }
        short[][] table_base = vlc.table_base;
        int table_offset = vlc.table_offset + table_index;
        int i = 0;
        while (i < table_size) {
            table_base[table_offset + i][1] = 0;
            table_base[table_offset + i][0] = -1;
            ++i;
        }
        i = 0;
        while (i < nb_codes) {
            int k;
            long j;
            long tmp;
            int n = codes_base[codes_offset + i].bits;
            long code = codes_base[codes_offset + i].code;
            int symbol = codes_base[codes_offset + i].symbol;
            if (n <= table_nb_bits) {
                tmp = code & 0xFFFFFFFFL;
                j = (int)(tmp >> 32 - table_nb_bits);
                int nb = 1 << table_nb_bits - n;
                int inc = 1;
                if ((flags & 2) != 0) {
                    j = GetBitContext.bitswap_32(code);
                    inc = 1 << n;
                }
                k = 0;
                while (k < nb) {
                    if (table_base[(int)((long)table_offset + j)][1] != 0) {
                        return -1;
                    }
                    table_base[(int)((long)table_offset + j)][1] = (short)n;
                    table_base[(int)((long)table_offset + j)][0] = (short)symbol;
                    j += (long)inc;
                    ++k;
                }
            } else {
                tmp = code & 0xFFFFFFFFL;
                int code_prefix = (int)(tmp >> 32 - table_nb_bits);
                int subtable_bits = n -= table_nb_bits;
                codes_base[codes_offset + i].bits = n;
                codes_base[codes_offset + i].code = code << table_nb_bits;
                k = i + 1;
                while (k < nb_codes) {
                    n = codes_base[codes_offset + k].bits - table_nb_bits;
                    if (n <= 0 || (code = codes_base[codes_offset + k].code) >> 32 - table_nb_bits != (long)code_prefix) break;
                    codes_base[codes_offset + k].bits = n;
                    codes_base[codes_offset + k].code = code << table_nb_bits;
                    subtable_bits = Math.max(subtable_bits, n);
                    ++k;
                }
                subtable_bits = Math.min(subtable_bits, table_nb_bits);
                j = (flags & 2) != 0 ? GetBitContext.bitswap_32(code_prefix) >> 32 - table_nb_bits : (long)code_prefix;
                table_base[(int)((long)table_offset + j)][1] = (short)(-subtable_bits);
                int index = GetBitContext.build_table(vlc, subtable_bits, k - i, codes_base, codes_offset + i, flags);
                if (index < 0) {
                    return -1;
                }
                table_base = vlc.table_base;
                table_offset = vlc.table_offset + table_index;
                table_base[(int)((long)table_offset + j)][0] = (short)index;
                i = k - 1;
            }
            ++i;
        }
        return table_index;
    }

    public int get_vlc2(short[][] table_base, int table_offset, int bits, int max_depth, String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        int index = (int)((re_cache &= 0xFFFFFFFFL) >> 32 - bits);
        short code = table_base[table_offset + index][0];
        short n = table_base[table_offset + index][1];
        if (max_depth > 1 && n < 0) {
            pos = this.buffer_offset + ((re_index += bits) >> 3);
            re_cache = this.buffer[pos + 0];
            re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
            re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
            re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
            re_cache <<= re_index & 7;
            short nb_bits = -n;
            index = (int)((re_cache &= 0xFFFFFFFFL) >> 32 - nb_bits) + code;
            code = table_base[table_offset + index][0];
            n = table_base[table_offset + index][1];
            if (max_depth > 2 && n < 0) {
                pos = this.buffer_offset + ((re_index += nb_bits) >> 3);
                re_cache = this.buffer[pos + 0];
                re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
                re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
                re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
                re_cache <<= re_index & 7;
                nb_bits = -n;
                index = (int)((re_cache &= 0xFFFFFFFFL) >> 32 - nb_bits) + code;
                code = table_base[table_offset + index][0];
                n = table_base[table_offset + index][1];
            }
        }
        re_cache >>= n;
        this.index = re_index += n;
        return code;
    }

    public int get_ue_golomb(String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long buf = re_cache &= 0xFFFFFFFFL;
        if (buf >= 0x8000000L) {
            this.index = re_index += ff_golomb_vlc_len[(int)(buf >>= 23)];
            return ff_ue_golomb_vlc_code[(int)buf];
        }
        int log = 2 * CAVLCContext.av_log2(buf) - 31;
        buf >>= log;
        this.index = re_index += 32 - log;
        return (int)(--buf);
    }

    public int get_ue_golomb_31(String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long buf = (re_cache &= 0xFFFFFFFFL) >> 23;
        this.index = re_index += ff_golomb_vlc_len[(int)buf];
        return ff_ue_golomb_vlc_code[(int)buf];
    }

    public int get_se_golomb(String message) {
        int re_index = this.index;
        long re_cache = 0L;
        int pos = this.buffer_offset + (re_index >> 3);
        re_cache = this.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)this.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long buf = re_cache &= 0xFFFFFFFFL;
        if (buf >= 0x8000000L) {
            this.index = re_index += ff_golomb_vlc_len[(int)(buf >>= 23)];
            return ff_se_golomb_vlc_code[(int)buf];
        }
        int log = 2 * CAVLCContext.av_log2(buf) - 31;
        this.index = re_index += 32 - log;
        buf = ((buf >>= log) & 1L) != 0L ? -(buf >> 1) : (buf >>= 1);
        return (int)buf;
    }
}

