/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.AVFrame;
import com.twilight.h264.decoder.H264Context;
import com.twilight.h264.decoder.H264DSPContext;
import com.twilight.h264.decoder.MpegEncContext;
import com.twilight.h264.decoder.Rectangle;
import com.twilight.h264.util.Arrays;

public class ErrorResilience {
    public static final int MV_FROZEN = 3;
    public static final int MV_CHANGED = 2;
    public static final int MV_UNCHANGED = 1;
    public static final int MV_TYPE_16X16 = 0;
    public static final int MV_TYPE_8X8 = 1;
    public static final int MV_TYPE_16X8 = 2;
    public static final int MV_TYPE_FIELD = 3;
    public static final int MV_TYPE_DMV = 4;
    public static final int FF_EC_GUESS_MVS = 1;
    public static final int FF_EC_DEBLOCK = 2;
    public static int error_concealment = 3;
    public static int[] dc_val_base;
    public static int[] dc_val;
    public static int[][][] mv;
    public static int skip_top;
    public static int skip_bottom;

    static {
        dc_val = new int[3];
        mv = new int[2][4][2];
    }

    public static void decode_mb(MpegEncContext s, int ref) {
        if (s.codec_id == 28) {
            H264Context h = s.priv_data;
            h.mb_xy = s.mb_x + s.mb_y * s.mb_stride;
            Arrays.fill(h.non_zero_count_cache, 0);
            if ((long)ref >= h.ref_count[0]) {
                ref = 0;
            }
            Rectangle.fill_rectangle_sign(s.current_picture.ref_index[0], 4 * h.mb_xy, 2, 2, 2, ref, 1);
            Rectangle.fill_rectangle_sign(h.ref_cache[0], H264Context.scan8[0], 4, 4, 8, ref, 1);
            Rectangle.fill_rectangle_mv_cache(h.mv_cache[0], H264Context.scan8[0], 4, 4, 8, H264Context.pack16to32(mv[0][0][0], mv[0][0][1]), 4);
            h.ff_h264_hl_decode_mb();
        }
    }

    public static void set_mv_strides(MpegEncContext s, int[] inout) {
        if (s.codec_id == 28) {
            H264Context h = s.priv_data;
            inout[0] = 4;
            inout[1] = h.b_stride;
        } else {
            inout[0] = 2;
            inout[1] = s.b8_stride;
        }
    }

    public static void put_dc(MpegEncContext s, int[] dest_y_base, int dest_y_offset, int[] dest_cb_base, int dest_cb_offset, int[] dest_cr_base, int dest_cr_offset, int mb_x, int mb_y) {
        int x;
        int y;
        int i = 0;
        while (i < 4) {
            int dc = dc_val_base[dc_val[0] + mb_x * 2 + (i & 1) + (mb_y * 2 + (i >> 1)) * s.b8_stride];
            if (dc < 0) {
                dc = 0;
            } else if (dc > 2040) {
                dc = 2040;
            }
            y = 0;
            while (y < 8) {
                x = 0;
                while (x < 8) {
                    dest_y_base[dest_y_offset + x + (i & 1) * 8 + (y + (i >> 1) * 8) * s.linesize] = dc / 8;
                    ++x;
                }
                ++y;
            }
            ++i;
        }
        int dcu = dc_val_base[dc_val[1] + mb_x + mb_y * s.mb_stride];
        int dcv = dc_val_base[dc_val[2] + mb_x + mb_y * s.mb_stride];
        if (dcu < 0) {
            dcu = 0;
        } else if (dcu > 2040) {
            dcu = 2040;
        }
        if (dcv < 0) {
            dcv = 0;
        } else if (dcv > 2040) {
            dcv = 2040;
        }
        y = 0;
        while (y < 8) {
            x = 0;
            while (x < 8) {
                dest_cb_base[dest_cb_offset + x + y * s.uvlinesize] = dcu / 8;
                dest_cr_base[dest_cr_offset + x + y * s.uvlinesize] = dcv / 8;
                ++x;
            }
            ++y;
        }
    }

    public static void filter181(int[] data_base, int data_offset, int width, int height, int stride) {
        int dc;
        int x;
        int prev_dc;
        int y = 1;
        while (y < height - 1) {
            prev_dc = data_base[data_offset + 0 + y * stride];
            x = 1;
            while (x < width - 1) {
                dc = -prev_dc + data_base[data_offset + x + y * stride] * 8 - data_base[data_offset + x + 1 + y * stride];
                dc = dc * 10923 + 32768 >> 16;
                prev_dc = data_base[data_offset + x + y * stride];
                data_base[data_offset + x + y * stride] = dc;
                ++x;
            }
            ++y;
        }
        x = 1;
        while (x < width - 1) {
            prev_dc = data_base[data_offset + x];
            y = 1;
            while (y < height - 1) {
                dc = -prev_dc + data_base[data_offset + x + y * stride] * 8 - data_base[data_offset + x + (y + 1) * stride];
                dc = dc * 10923 + 32768 >> 16;
                prev_dc = data_base[data_offset + x + y * stride];
                data_base[data_offset + x + y * stride] = dc;
                ++y;
            }
            ++x;
        }
    }

    public static void guess_dc(MpegEncContext s, int[] dc_base, int dc_offset, int w, int h, int stride, int is_luma) {
        int b_y = 0;
        while (b_y < h) {
            int b_x = 0;
            while (b_x < w) {
                int[] color = new int[]{1024, 1024, 1024, 1024};
                int[] distance = new int[]{9999, 9999, 9999, 9999};
                int mb_index = (b_x >> is_luma) + (b_y >> is_luma) * s.mb_stride;
                int error = s.error_status_table[mb_index];
                if ((s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_index] & 0x78L) == 0L && (error & 4) != 0) {
                    int intra_j;
                    int error_j;
                    int mb_index_j;
                    int j = b_x + 1;
                    while (j < w) {
                        mb_index_j = (j >> is_luma) + (b_y >> is_luma) * s.mb_stride;
                        error_j = s.error_status_table[mb_index_j];
                        intra_j = 7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_index_j];
                        if (intra_j == 0 || (error_j & 4) == 0) {
                            color[0] = dc_base[dc_offset + j + b_y * stride];
                            distance[0] = j - b_x;
                            break;
                        }
                        ++j;
                    }
                    j = b_x - 1;
                    while (j >= 0) {
                        mb_index_j = (j >> is_luma) + (b_y >> is_luma) * s.mb_stride;
                        error_j = s.error_status_table[mb_index_j];
                        intra_j = 7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_index_j];
                        if (intra_j == 0 || (error_j & 4) == 0) {
                            color[1] = dc_base[dc_offset + j + b_y * stride];
                            distance[1] = b_x - j;
                            break;
                        }
                        --j;
                    }
                    j = b_y + 1;
                    while (j < h) {
                        mb_index_j = (b_x >> is_luma) + (j >> is_luma) * s.mb_stride;
                        error_j = s.error_status_table[mb_index_j];
                        intra_j = 7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_index_j];
                        if (intra_j == 0 || (error_j & 4) == 0) {
                            color[2] = dc_base[dc_offset + b_x + j * stride];
                            distance[2] = j - b_y;
                            break;
                        }
                        ++j;
                    }
                    j = b_y - 1;
                    while (j >= 0) {
                        mb_index_j = (b_x >> is_luma) + (j >> is_luma) * s.mb_stride;
                        error_j = s.error_status_table[mb_index_j];
                        intra_j = 7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_index_j];
                        if (intra_j == 0 || (error_j & 4) == 0) {
                            color[3] = dc_base[dc_offset + b_x + j * stride];
                            distance[3] = b_y - j;
                            break;
                        }
                        --j;
                    }
                    long weight_sum = 0L;
                    long guess = 0L;
                    j = 0;
                    while (j < 4) {
                        long weight = 0x10000000 / distance[j];
                        guess += weight * (long)color[j];
                        weight_sum += weight;
                        ++j;
                    }
                    guess = (guess + weight_sum / 2L) / weight_sum;
                    dc_base[dc_offset + b_x + b_y * stride] = (int)guess;
                }
                ++b_x;
            }
            ++b_y;
        }
    }

    public static void h_block_filter(MpegEncContext s, int[] dst_base, int dst_offset, int w, int h, int stride, int is_luma) {
        int[] cm_base = H264DSPContext.ff_cropTbl;
        int cm_offset = 1024;
        int[] param = new int[2];
        ErrorResilience.set_mv_strides(s, param);
        int mvx_stride = param[0];
        int mvy_stride = param[1];
        mvy_stride *= (mvx_stride >>= is_luma);
        int b_y = 0;
        while (b_y < h) {
            int b_x = 0;
            while (b_x < w - 1) {
                int left_status = s.error_status_table[(b_x >> is_luma) + (b_y >> is_luma) * s.mb_stride];
                int right_status = s.error_status_table[(b_x + 1 >> is_luma) + (b_y >> is_luma) * s.mb_stride];
                int left_intra = 7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + (b_x >> is_luma) + (b_y >> is_luma) * s.mb_stride];
                int right_intra = 7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + (b_x + 1 >> is_luma) + (b_y >> is_luma) * s.mb_stride];
                int left_damage = left_status & 0xE;
                int right_damage = right_status & 0xE;
                int offset = b_x * 8 + b_y * stride * 8;
                int[] left_mv = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mvy_stride * b_y + mvx_stride * b_x];
                int[] right_mv = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mvy_stride * b_y + mvx_stride * (b_x + 1)];
                if (!(left_damage == 0 && right_damage == 0 || left_intra == 0 && right_intra == 0 && Math.abs(left_mv[0] - right_mv[0]) + Math.abs(left_mv[1] + right_mv[1]) < 2)) {
                    int y = 0;
                    while (y < 8) {
                        int a = dst_base[dst_offset + offset + 7 + y * stride] - dst_base[dst_offset + offset + 6 + y * stride];
                        int b = dst_base[dst_offset + offset + 8 + y * stride] - dst_base[dst_offset + offset + 7 + y * stride];
                        int c = dst_base[dst_offset + offset + 9 + y * stride] - dst_base[dst_offset + offset + 8 + y * stride];
                        int d = Math.abs(b) - (Math.abs(a) + Math.abs(c) + 1 >> 1);
                        d = Math.max(d, 0);
                        if (b < 0) {
                            d = -d;
                        }
                        if (d != 0) {
                            if (left_damage == 0 || right_damage == 0) {
                                d = d * 16 / 9;
                            }
                            if (left_damage != 0) {
                                dst_base[dst_offset + offset + 7 + y * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + 7 + y * stride] + (d * 7 >> 4)];
                                dst_base[dst_offset + offset + 6 + y * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + 6 + y * stride] + (d * 5 >> 4)];
                                dst_base[dst_offset + offset + 5 + y * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + 5 + y * stride] + (d * 3 >> 4)];
                                dst_base[dst_offset + offset + 4 + y * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + 4 + y * stride] + (d * 1 >> 4)];
                            }
                            if (right_damage != 0) {
                                dst_base[dst_offset + offset + 8 + y * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + 8 + y * stride] - (d * 7 >> 4)];
                                dst_base[dst_offset + offset + 9 + y * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + 9 + y * stride] - (d * 5 >> 4)];
                                dst_base[dst_offset + offset + 10 + y * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + 10 + y * stride] - (d * 3 >> 4)];
                                dst_base[dst_offset + offset + 11 + y * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + 11 + y * stride] - (d * 1 >> 4)];
                            }
                        }
                        ++y;
                    }
                }
                ++b_x;
            }
            ++b_y;
        }
    }

    public static void v_block_filter(MpegEncContext s, int[] dst_base, int dst_offset, int w, int h, int stride, int is_luma) {
        int[] cm_base = H264DSPContext.ff_cropTbl;
        int cm_offset = 1024;
        int[] param = new int[2];
        ErrorResilience.set_mv_strides(s, param);
        int mvx_stride = param[0];
        int mvy_stride = param[1];
        mvy_stride *= (mvx_stride >>= is_luma);
        int b_y = 0;
        while (b_y < h - 1) {
            int b_x = 0;
            while (b_x < w) {
                int top_status = s.error_status_table[(b_x >> is_luma) + (b_y >> is_luma) * s.mb_stride];
                int bottom_status = s.error_status_table[(b_x >> is_luma) + (b_y + 1 >> is_luma) * s.mb_stride];
                int top_intra = 7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + (b_x >> is_luma) + (b_y >> is_luma) * s.mb_stride];
                int bottom_intra = 7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + (b_x >> is_luma) + (b_y + 1 >> is_luma) * s.mb_stride];
                int top_damage = top_status & 0xE;
                int bottom_damage = bottom_status & 0xE;
                int offset = b_x * 8 + b_y * stride * 8;
                int[] top_mv = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mvy_stride * b_y + mvx_stride * b_x];
                int[] bottom_mv = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mvy_stride * (b_y + 1) + mvx_stride * b_x];
                if (!(top_damage == 0 && bottom_damage == 0 || top_intra == 0 && bottom_intra == 0 && Math.abs(top_mv[0] - bottom_mv[0]) + Math.abs(top_mv[1] + bottom_mv[1]) < 2)) {
                    int x = 0;
                    while (x < 8) {
                        int a = dst_base[dst_offset + offset + x + 7 * stride] - dst_base[dst_offset + offset + x + 6 * stride];
                        int b = dst_base[dst_offset + offset + x + 8 * stride] - dst_base[dst_offset + offset + x + 7 * stride];
                        int c = dst_base[dst_offset + offset + x + 9 * stride] - dst_base[dst_offset + offset + x + 8 * stride];
                        int d = Math.abs(b) - (Math.abs(a) + Math.abs(c) + 1 >> 1);
                        d = Math.max(d, 0);
                        if (b < 0) {
                            d = -d;
                        }
                        if (d != 0) {
                            if (top_damage == 0 || bottom_damage == 0) {
                                d = d * 16 / 9;
                            }
                            if (top_damage != 0) {
                                dst_base[dst_offset + offset + x + 7 * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + x + 7 * stride] + (d * 7 >> 4)];
                                dst_base[dst_offset + offset + x + 6 * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + x + 6 * stride] + (d * 5 >> 4)];
                                dst_base[dst_offset + offset + x + 5 * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + x + 5 * stride] + (d * 3 >> 4)];
                                dst_base[dst_offset + offset + x + 4 * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + x + 4 * stride] + (d * 1 >> 4)];
                            }
                            if (bottom_damage != 0) {
                                dst_base[dst_offset + offset + x + 8 * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + x + 8 * stride] - (d * 7 >> 4)];
                                dst_base[dst_offset + offset + x + 9 * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + x + 9 * stride] - (d * 5 >> 4)];
                                dst_base[dst_offset + offset + x + 10 * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + x + 10 * stride] - (d * 3 >> 4)];
                                dst_base[dst_offset + offset + x + 11 * stride] = cm_base[cm_offset + dst_base[dst_offset + offset + x + 11 * stride] - (d * 1 >> 4)];
                            }
                        }
                        ++x;
                    }
                }
                ++b_x;
            }
            ++b_y;
        }
    }

    public static void guess_mv(MpegEncContext s) {
        int mb_xy;
        int[] fixed = new int[s.mb_stride * s.mb_height];
        int mb_stride = s.mb_stride;
        int mb_width = s.mb_width;
        int mb_height = s.mb_height;
        int[] param = new int[2];
        ErrorResilience.set_mv_strides(s, param);
        int mot_step = param[0];
        int mot_stride = param[1];
        int num_avail = 0;
        int i = 0;
        while (i < s.mb_num) {
            mb_xy = s.mb_index2xy[i];
            int f = 0;
            int error = s.error_status_table[mb_xy];
            if (0L != (7L & s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy])) {
                f = 3;
            }
            if ((error & 8) == 0) {
                f = 3;
            }
            fixed[mb_xy] = f;
            if (f == 3) {
                ++num_avail;
            }
            ++i;
        }
        if ((error_concealment & 1) == 0 || num_avail <= mb_width / 2) {
            int mb_y = 0;
            while (mb_y < s.mb_height) {
                int mb_x = 0;
                while (mb_x < s.mb_width) {
                    mb_xy = mb_x + mb_y * s.mb_stride;
                    if ((7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy]) == 0 && (s.error_status_table[mb_xy] & 8) != 0) {
                        s.mv_dir = s.last_picture.data_base[0] != null ? MpegEncContext.MV_DIR_FORWARD : MpegEncContext.MV_DIR_BACKWARD;
                        s.mb_intra = 0;
                        s.mv_type = 0;
                        s.mb_skipped = 0;
                        s.dsp.clear_blocks(s.block, 0);
                        s.mb_x = mb_x;
                        s.mb_y = mb_y;
                        ErrorResilience.mv[0][0][0] = 0;
                        ErrorResilience.mv[0][0][1] = 0;
                        ErrorResilience.decode_mb(s, 0);
                    }
                    ++mb_x;
                }
                ++mb_y;
            }
            return;
        }
        int depth = 0;
        while (true) {
            boolean none_left = true;
            int changed = 1;
            int pass = 0;
            while ((changed != 0 || pass < 2) && pass < 10) {
                int score_sum = 0;
                changed = 0;
                int mb_y = 0;
                while (mb_y < s.mb_height) {
                    int mb_x = 0;
                    while (mb_x < s.mb_width) {
                        int mb_xy2 = mb_x + mb_y * s.mb_stride;
                        int[][] mv_predictor = new int[8][2];
                        int[] ref = new int[8];
                        int pred_count = 0;
                        int best_score = 0x40000000;
                        int best_pred = 0;
                        int mot_index = (mb_x + mb_y * mot_stride) * mot_step;
                        int prev_x = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index][0];
                        int prev_y = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index][1];
                        if (((mb_x ^ mb_y ^ pass) & 1) == 0 && fixed[mb_xy2] != 3) {
                            int j = 0;
                            if (mb_x > 0 && fixed[mb_xy2 - 1] == 3) {
                                j = 1;
                            }
                            if (mb_x + 1 < mb_width && fixed[mb_xy2 + 1] == 3) {
                                j = 1;
                            }
                            if (mb_y > 0 && fixed[mb_xy2 - mb_stride] == 3) {
                                j = 1;
                            }
                            if (mb_y + 1 < mb_height && fixed[mb_xy2 + mb_stride] == 3) {
                                j = 1;
                            }
                            if (j != 0) {
                                j = 0;
                                if (mb_x > 0 && fixed[mb_xy2 - 1] == 2) {
                                    j = 1;
                                }
                                if (mb_x + 1 < mb_width && fixed[mb_xy2 + 1] == 2) {
                                    j = 1;
                                }
                                if (mb_y > 0 && fixed[mb_xy2 - mb_stride] == 2) {
                                    j = 1;
                                }
                                if (mb_y + 1 < mb_height && fixed[mb_xy2 + mb_stride] == 2) {
                                    j = 1;
                                }
                                if (j != 0 || pass <= 1) {
                                    none_left = false;
                                    if (mb_x > 0 && fixed[mb_xy2 - 1] != 0) {
                                        mv_predictor[pred_count][0] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index - mot_step][0];
                                        mv_predictor[pred_count][1] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index - mot_step][1];
                                        ref[pred_count] = s.current_picture.ref_index[0][4 * (mb_xy2 - 1)];
                                        ++pred_count;
                                    }
                                    if (mb_x + 1 < mb_width && fixed[mb_xy2 + 1] != 0) {
                                        mv_predictor[pred_count][0] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index + mot_step][0];
                                        mv_predictor[pred_count][1] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index + mot_step][1];
                                        ref[pred_count] = s.current_picture.ref_index[0][4 * (mb_xy2 + 1)];
                                        ++pred_count;
                                    }
                                    if (mb_y > 0 && fixed[mb_xy2 - mb_stride] != 0) {
                                        mv_predictor[pred_count][0] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index - mot_stride * mot_step][0];
                                        mv_predictor[pred_count][1] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index - mot_stride * mot_step][1];
                                        ref[pred_count] = s.current_picture.ref_index[0][4 * (mb_xy2 - s.mb_stride)];
                                        ++pred_count;
                                    }
                                    if (mb_y + 1 < mb_height && fixed[mb_xy2 + mb_stride] != 0) {
                                        mv_predictor[pred_count][0] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index + mot_stride * mot_step][0];
                                        mv_predictor[pred_count][1] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index + mot_stride * mot_step][1];
                                        ref[pred_count] = s.current_picture.ref_index[0][4 * (mb_xy2 + s.mb_stride)];
                                        ++pred_count;
                                    }
                                    if (pred_count != 0) {
                                        boolean skip_mean_and_median = false;
                                        if (pred_count > 1) {
                                            int sum_x = 0;
                                            int sum_y = 0;
                                            int sum_r = 0;
                                            j = 0;
                                            while (j < pred_count) {
                                                sum_x += mv_predictor[j][0];
                                                sum_y += mv_predictor[j][1];
                                                sum_r += ref[j];
                                                if (j != 0 && ref[j] != ref[j - 1]) {
                                                    skip_mean_and_median = true;
                                                    break;
                                                }
                                                ++j;
                                            }
                                            if (!skip_mean_and_median) {
                                                int max_y;
                                                int max_x;
                                                int max_r;
                                                int min_y;
                                                int min_x;
                                                int min_r;
                                                mv_predictor[pred_count][0] = sum_x / j;
                                                mv_predictor[pred_count][1] = sum_y / j;
                                                ref[pred_count] = sum_r / j;
                                                if (pred_count >= 3) {
                                                    min_r = 99999;
                                                    min_x = 99999;
                                                    min_y = 99999;
                                                    max_r = -99999;
                                                    max_x = -99999;
                                                    max_y = -99999;
                                                } else {
                                                    max_r = 0;
                                                    min_r = 0;
                                                    max_y = 0;
                                                    max_x = 0;
                                                    min_y = 0;
                                                    min_x = 0;
                                                }
                                                j = 0;
                                                while (j < pred_count) {
                                                    max_x = Math.max(max_x, mv_predictor[j][0]);
                                                    max_y = Math.max(max_y, mv_predictor[j][1]);
                                                    max_r = Math.max(max_r, ref[j]);
                                                    min_x = Math.min(min_x, mv_predictor[j][0]);
                                                    min_y = Math.min(min_y, mv_predictor[j][1]);
                                                    min_r = Math.min(min_r, ref[j]);
                                                    ++j;
                                                }
                                                mv_predictor[pred_count + 1][0] = sum_x - max_x - min_x;
                                                mv_predictor[pred_count + 1][1] = sum_y - max_y - min_y;
                                                ref[pred_count + 1] = sum_r - max_r - min_r;
                                                if (pred_count == 4) {
                                                    int[] nArray = mv_predictor[pred_count + 1];
                                                    nArray[0] = nArray[0] / 2;
                                                    int[] nArray2 = mv_predictor[pred_count + 1];
                                                    nArray2[1] = nArray2[1] / 2;
                                                    int n = pred_count + 1;
                                                    ref[n] = ref[n] / 2;
                                                }
                                                pred_count += 2;
                                            }
                                        }
                                        mv_predictor[++pred_count][0] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index][0];
                                        mv_predictor[pred_count][1] = s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index][1];
                                        ref[pred_count] = s.current_picture.ref_index[0][4 * mb_xy2];
                                        ++pred_count;
                                        s.mv_dir = MpegEncContext.MV_DIR_FORWARD;
                                        s.mb_intra = 0;
                                        s.mv_type = 0;
                                        s.mb_skipped = 0;
                                        s.dsp.clear_blocks(s.block, 0);
                                        s.mb_x = mb_x;
                                        s.mb_y = mb_y;
                                        j = 0;
                                        while (j < pred_count) {
                                            int score = 0;
                                            int[] src_base = s.current_picture.data_base[0];
                                            int src_offset = s.current_picture.data_offset[0] + mb_x * 16 + mb_y * 16 * s.linesize;
                                            int n = mv_predictor[j][0];
                                            ErrorResilience.mv[0][0][0] = n;
                                            s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index][0] = n;
                                            int n2 = mv_predictor[j][1];
                                            ErrorResilience.mv[0][0][1] = n2;
                                            s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index][1] = n2;
                                            if (ref[j] >= 0) {
                                                int k;
                                                ErrorResilience.decode_mb(s, ref[j]);
                                                if (mb_x > 0 && fixed[mb_xy2 - 1] != 0) {
                                                    k = 0;
                                                    while (k < 16) {
                                                        score += Math.abs(src_base[src_offset + k * s.linesize - 1] - src_base[src_offset + k * s.linesize]);
                                                        ++k;
                                                    }
                                                }
                                                if (mb_x + 1 < mb_width && fixed[mb_xy2 + 1] != 0) {
                                                    k = 0;
                                                    while (k < 16) {
                                                        score += Math.abs(src_base[src_offset + k * s.linesize + 15] - src_base[src_offset + k * s.linesize + 16]);
                                                        ++k;
                                                    }
                                                }
                                                if (mb_y > 0 && fixed[mb_xy2 - mb_stride] != 0) {
                                                    k = 0;
                                                    while (k < 16) {
                                                        score += Math.abs(src_base[src_offset + k - s.linesize] - src_base[src_offset + k]);
                                                        ++k;
                                                    }
                                                }
                                                if (mb_y + 1 < mb_height && fixed[mb_xy2 + mb_stride] != 0) {
                                                    k = 0;
                                                    while (k < 16) {
                                                        score += Math.abs(src_base[src_offset + k + s.linesize * 15] - src_base[src_offset + k + s.linesize * 16]);
                                                        ++k;
                                                    }
                                                }
                                                if (score <= best_score) {
                                                    best_score = score;
                                                    best_pred = j;
                                                }
                                            }
                                            ++j;
                                        }
                                        score_sum += best_score;
                                        ErrorResilience.mv[0][0][0] = mv_predictor[best_pred][0];
                                        ErrorResilience.mv[0][0][1] = mv_predictor[best_pred][1];
                                        i = 0;
                                        while (i < mot_step) {
                                            j = 0;
                                            while (j < mot_step) {
                                                s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index + i + j * mot_stride][0] = mv[0][0][0];
                                                s.current_picture.motion_val_base[0][s.current_picture.motion_val_offset[0] + mot_index + i + j * mot_stride][1] = mv[0][0][1];
                                                ++j;
                                            }
                                            ++i;
                                        }
                                        ErrorResilience.decode_mb(s, ref[best_pred]);
                                        if (mv[0][0][0] != prev_x || mv[0][0][1] != prev_y) {
                                            fixed[mb_xy2] = 2;
                                            ++changed;
                                        } else {
                                            fixed[mb_xy2] = 1;
                                        }
                                    }
                                }
                            }
                        }
                        ++mb_x;
                    }
                    ++mb_y;
                }
                ++pass;
            }
            if (none_left) {
                return;
            }
            i = 0;
            while (i < s.mb_num) {
                int mb_xy3 = s.mb_index2xy[i];
                if (fixed[mb_xy3] != 0) {
                    fixed[mb_xy3] = 3;
                }
                ++i;
            }
            ++depth;
        }
    }

    public static int pix_abs16_c(Object v, int[] pix1_base, int pix1_offset, int[] pix2_base, int pix2_offset, int line_size, int h) {
        int s = 0;
        int i = 0;
        while (i < h) {
            s += Math.abs(pix1_base[pix1_offset + 0] - pix2_base[pix2_offset + 0]);
            s += Math.abs(pix1_base[pix1_offset + 1] - pix2_base[pix2_offset + 1]);
            s += Math.abs(pix1_base[pix1_offset + 2] - pix2_base[pix2_offset + 2]);
            s += Math.abs(pix1_base[pix1_offset + 3] - pix2_base[pix2_offset + 3]);
            s += Math.abs(pix1_base[pix1_offset + 4] - pix2_base[pix2_offset + 4]);
            s += Math.abs(pix1_base[pix1_offset + 5] - pix2_base[pix2_offset + 5]);
            s += Math.abs(pix1_base[pix1_offset + 6] - pix2_base[pix2_offset + 6]);
            s += Math.abs(pix1_base[pix1_offset + 7] - pix2_base[pix2_offset + 7]);
            s += Math.abs(pix1_base[pix1_offset + 8] - pix2_base[pix2_offset + 8]);
            s += Math.abs(pix1_base[pix1_offset + 9] - pix2_base[pix2_offset + 9]);
            s += Math.abs(pix1_base[pix1_offset + 10] - pix2_base[pix2_offset + 10]);
            s += Math.abs(pix1_base[pix1_offset + 11] - pix2_base[pix2_offset + 11]);
            s += Math.abs(pix1_base[pix1_offset + 12] - pix2_base[pix2_offset + 12]);
            s += Math.abs(pix1_base[pix1_offset + 13] - pix2_base[pix2_offset + 13]);
            s += Math.abs(pix1_base[pix1_offset + 14] - pix2_base[pix2_offset + 14]);
            s += Math.abs(pix1_base[pix1_offset + 15] - pix2_base[pix2_offset + 15]);
            pix1_offset += line_size;
            pix2_offset += line_size;
            ++i;
        }
        return s;
    }

    public static int is_intra_more_likely(MpegEncContext s) {
        if (s.last_picture_ptr == null || s.last_picture_ptr.data_base[0] == null) {
            return 1;
        }
        int undamaged_count = 0;
        int i = 0;
        while (i < s.mb_num) {
            int mb_xy = s.mb_index2xy[i];
            int error = s.error_status_table[mb_xy];
            if ((error & 4) == 0 || (error & 8) == 0) {
                ++undamaged_count;
            }
            ++i;
        }
        if (s.codec_id == 28) {
            H264Context h = s.priv_data;
            if (h.ref_count[0] <= 0L || h.ref_list[0][0].data_base[0] == null) {
                return 1;
            }
        }
        if (undamaged_count < 5) {
            return 0;
        }
        int skip_amount = Math.max(undamaged_count / 50, 1);
        int is_intra_likely = 0;
        int j = 0;
        int mb_y = 0;
        while (mb_y < s.mb_height - 1) {
            int mb_x = 0;
            while (mb_x < s.mb_width) {
                int mb_xy = mb_x + mb_y * s.mb_stride;
                int error = s.error_status_table[mb_xy];
                if (((error & 4) == 0 || (error & 8) == 0) && ++j % skip_amount == 0) {
                    if (s.pict_type == 1) {
                        int[] mb_ptr_base = s.current_picture.data_base[0];
                        int[] last_mb_ptr_base = s.last_picture.data_base[0];
                        int mb_ptr_offset = s.current_picture.data_offset[0] + mb_x * 16 + mb_y * 16 * s.linesize;
                        int last_mb_ptr_offset = s.last_picture.data_offset[0] + mb_x * 16 + mb_y * 16 * s.linesize;
                        is_intra_likely += ErrorResilience.pix_abs16_c(null, last_mb_ptr_base, last_mb_ptr_offset, mb_ptr_base, mb_ptr_offset, s.linesize, 16);
                        is_intra_likely -= ErrorResilience.pix_abs16_c(null, last_mb_ptr_base, last_mb_ptr_offset, last_mb_ptr_base, last_mb_ptr_offset + s.linesize * 16, s.linesize, 16);
                    } else {
                        is_intra_likely = (7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy]) != 0 ? ++is_intra_likely : --is_intra_likely;
                    }
                }
                ++mb_x;
            }
            ++mb_y;
        }
        return is_intra_likely > 0 ? 1 : 0;
    }

    public static void ff_er_frame_start(MpegEncContext s) {
        if (s.error_recognition == 0) {
            return;
        }
        Arrays.fill(s.error_status_table, 0, s.mb_stride * s.mb_height, 127);
        s.error_count = 3 * s.mb_num;
    }

    public static void ff_er_add_slice(MpegEncContext s, int startx, int starty, int endx, int endy, int status) {
        int start_i = H264DSPContext.av_clip(startx + starty * s.mb_width, 0, s.mb_num - 1);
        int end_i = H264DSPContext.av_clip(endx + endy * s.mb_width, 0, s.mb_num);
        int start_xy = s.mb_index2xy[start_i];
        int end_xy = s.mb_index2xy[end_i];
        int mask = -1;
        if (start_i > end_i || start_xy > end_xy) {
            return;
        }
        if (s.error_recognition == 0) {
            return;
        }
        mask &= 0xFFFFFFFE;
        if ((status & 0x12) != 0) {
            mask &= 0xFFFFFFED;
            s.error_count -= end_i - start_i + 1;
        }
        if ((status & 0x24) != 0) {
            mask &= 0xFFFFFFDB;
            s.error_count -= end_i - start_i + 1;
        }
        if ((status & 0x48) != 0) {
            mask &= 0xFFFFFFB7;
            s.error_count -= end_i - start_i + 1;
        }
        if ((status & 0xE) != 0) {
            s.error_count = Integer.MAX_VALUE;
        }
        if (mask == -128) {
            Arrays.fill(s.error_status_table, start_xy, end_xy, 0);
        } else {
            int i = start_xy;
            while (i < end_xy) {
                int n = i++;
                s.error_status_table[n] = s.error_status_table[n] & mask;
            }
        }
        if (end_i == s.mb_num) {
            s.error_count = Integer.MAX_VALUE;
        } else {
            int n = end_xy;
            s.error_status_table[n] = s.error_status_table[n] & mask;
            int n2 = end_xy;
            s.error_status_table[n2] = s.error_status_table[n2] | status;
        }
        int n = start_xy;
        s.error_status_table[n] = s.error_status_table[n] | 1;
        if (start_xy > 0 && skip_top * s.mb_width < start_i) {
            int prev_status = s.error_status_table[s.mb_index2xy[start_i - 1]];
            if ((prev_status &= 0xFFFFFFFE) != 112) {
                s.error_count = Integer.MAX_VALUE;
            }
        }
    }

    public static void ff_er_frame_end(MpegEncContext s) {
        int mb_x;
        int mb_xy;
        int error;
        int mb_xy2;
        boolean end_ok;
        int i;
        int[] threshold_part = new int[]{100, 100, 100};
        int threshold = 50;
        int size = s.b8_stride * 2 * s.mb_height;
        AVFrame pic = s.current_picture_ptr;
        if (s.error_recognition == 0 || s.error_count == 0 || s.lowres != 0 || s.picture_structure != 3 || s.error_count == 3 * s.mb_width * (skip_top + skip_bottom)) {
            return;
        }
        if (s.current_picture.motion_val_base[0] == null) {
            i = 0;
            while (i < 2) {
                pic.ref_index[i] = new int[s.mb_stride * s.mb_height * 4];
                pic.motion_val_base[i] = new int[size + 4][2];
                pic.motion_val_offset[i] = 4;
                ++i;
            }
            pic.motion_subsample_log2 = 3;
            s.current_picture_ptr.copyTo(s.current_picture);
        }
        int error_type = 1;
        while (error_type <= 3) {
            end_ok = false;
            i = s.mb_num - 1;
            while (i >= 0) {
                mb_xy2 = s.mb_index2xy[i];
                error = s.error_status_table[mb_xy2];
                if ((error & 1 << error_type) != 0) {
                    end_ok = true;
                }
                if ((error & 8 << error_type) != 0) {
                    end_ok = true;
                }
                if (!end_ok) {
                    int n = mb_xy2;
                    s.error_status_table[n] = s.error_status_table[n] | 1 << error_type;
                }
                if ((error & 1) != 0) {
                    end_ok = false;
                }
                --i;
            }
            ++error_type;
        }
        if (s.partitioned_frame != 0) {
            end_ok = false;
            i = s.mb_num - 1;
            while (i >= 0) {
                mb_xy2 = s.mb_index2xy[i];
                error = s.error_status_table[mb_xy2];
                if ((error & 0x10) != 0) {
                    end_ok = false;
                }
                if ((error & 0x40) != 0 || (error & 0x20) != 0 || (error & 2) != 0) {
                    end_ok = true;
                }
                if (!end_ok) {
                    int n = mb_xy2;
                    s.error_status_table[n] = s.error_status_table[n] | 2;
                }
                if ((error & 1) != 0) {
                    end_ok = false;
                }
                --i;
            }
        }
        if (s.error_recognition >= 4) {
            end_ok = true;
            i = s.mb_num - 2;
            while (i >= s.mb_width + 100) {
                mb_xy2 = s.mb_index2xy[i];
                int error1 = s.error_status_table[mb_xy2];
                int error2 = s.error_status_table[s.mb_index2xy[i + 1]];
                if ((error1 & 1) != 0) {
                    end_ok = true;
                }
                if (error2 == 127 && error1 != 127 && ((error1 & 0x10) != 0 || (error1 & 0x20) != 0 || (error1 & 0x40) != 0)) {
                    end_ok = false;
                }
                if (!end_ok) {
                    int n = mb_xy2;
                    s.error_status_table[n] = s.error_status_table[n] | 0xE;
                }
                --i;
            }
        }
        int distance = 9999999;
        error_type = 1;
        while (error_type <= 3) {
            i = s.mb_num - 1;
            while (i >= 0) {
                mb_xy = s.mb_index2xy[i];
                error = s.error_status_table[mb_xy];
                if (s.mbskip_table[mb_xy] == 0) {
                    ++distance;
                }
                if ((error & 1 << error_type) != 0) {
                    distance = 0;
                }
                if (s.partitioned_frame != 0) {
                    if (distance < threshold_part[error_type - 1]) {
                        int n = mb_xy;
                        s.error_status_table[n] = s.error_status_table[n] | 1 << error_type;
                    }
                } else if (distance < threshold) {
                    int n = mb_xy;
                    s.error_status_table[n] = s.error_status_table[n] | 1 << error_type;
                }
                if ((error & 1) != 0) {
                    distance = 9999999;
                }
                --i;
            }
            ++error_type;
        }
        error = 0;
        i = 0;
        while (i < s.mb_num) {
            mb_xy = s.mb_index2xy[i];
            int old_error = s.error_status_table[mb_xy];
            if ((old_error & 1) != 0) {
                error = old_error & 0xE;
            } else {
                int n = mb_xy;
                s.error_status_table[n] = s.error_status_table[n] | (error |= old_error & 0xE);
            }
            ++i;
        }
        if (s.partitioned_frame == 0) {
            i = 0;
            while (i < s.mb_num) {
                mb_xy = s.mb_index2xy[i];
                error = s.error_status_table[mb_xy];
                if ((error & 0xE) != 0) {
                    error |= 0xE;
                }
                s.error_status_table[mb_xy] = error;
                ++i;
            }
        }
        int mv_error = 0;
        int ac_error = 0;
        int dc_error = 0;
        i = 0;
        while (i < s.mb_num) {
            mb_xy = s.mb_index2xy[i];
            error = s.error_status_table[mb_xy];
            if ((error & 4) != 0) {
                ++dc_error;
            }
            if ((error & 2) != 0) {
                ++ac_error;
            }
            if ((error & 8) != 0) {
                ++mv_error;
            }
            ++i;
        }
        int is_intra_likely = ErrorResilience.is_intra_more_likely(s);
        i = 0;
        while (i < s.mb_num) {
            mb_xy = s.mb_index2xy[i];
            error = s.error_status_table[mb_xy];
            if ((error & 4) != 0 && (error & 8) != 0) {
                s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy] = is_intra_likely != 0 ? 1L : 12296L;
            }
            ++i;
        }
        if (s.last_picture.data_base[0] == null && s.next_picture.data_base[0] == null) {
            i = 0;
            while (i < s.mb_num) {
                mb_xy = s.mb_index2xy[i];
                if ((7 & (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy]) == 0) {
                    s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy] = 1L;
                }
                ++i;
            }
        }
        int mb_y = 0;
        while (mb_y < s.mb_height) {
            mb_x = 0;
            while (mb_x < s.mb_width) {
                mb_xy = mb_x + mb_y * s.mb_stride;
                int mb_type = (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy];
                int dir = s.last_picture.data_base[0] == null ? 1 : 0;
                error = s.error_status_table[mb_xy];
                if ((7 & mb_type) == 0 && (error & 8) == 0 && (error & 2) != 0) {
                    s.mv_dir = dir != 0 ? MpegEncContext.MV_DIR_BACKWARD : MpegEncContext.MV_DIR_FORWARD;
                    s.mb_intra = 0;
                    s.mb_skipped = 0;
                    if ((mb_type & 0x40) != 0) {
                        int mb_index = mb_x * 2 + mb_y * 2 * s.b8_stride;
                        s.mv_type = 1;
                        int j = 0;
                        while (j < 4) {
                            ErrorResilience.mv[0][j][0] = s.current_picture.motion_val_base[dir][s.current_picture.motion_val_offset[dir] + mb_index + (j & 1) + (j >> 1) * s.b8_stride][0];
                            ErrorResilience.mv[0][j][1] = s.current_picture.motion_val_base[dir][s.current_picture.motion_val_offset[dir] + mb_index + (j & 1) + (j >> 1) * s.b8_stride][1];
                            ++j;
                        }
                    } else {
                        s.mv_type = 0;
                        ErrorResilience.mv[0][0][0] = s.current_picture.motion_val_base[dir][s.current_picture.motion_val_offset[dir] + mb_x * 2 + mb_y * 2 * s.b8_stride][0];
                        ErrorResilience.mv[0][0][1] = s.current_picture.motion_val_base[dir][s.current_picture.motion_val_offset[dir] + mb_x * 2 + mb_y * 2 * s.b8_stride][1];
                    }
                    s.dsp.clear_blocks(s.block, 0);
                    s.mb_x = mb_x;
                    s.mb_y = mb_y;
                    ErrorResilience.decode_mb(s, 0);
                }
                ++mb_x;
            }
            ++mb_y;
        }
        if (s.pict_type == 3) {
            mb_y = 0;
            while (mb_y < s.mb_height) {
                mb_x = 0;
                while (mb_x < s.mb_width) {
                    int xy = mb_x * 2 + mb_y * 2 * s.b8_stride;
                    mb_xy2 = mb_x + mb_y * s.mb_stride;
                    int mb_type = (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy2];
                    error = s.error_status_table[mb_xy2];
                    if ((7 & mb_type) == 0 && (error & 8) != 0 && (error & 2) != 0) {
                        s.mv_dir = MpegEncContext.MV_DIR_FORWARD | MpegEncContext.MV_DIR_BACKWARD;
                        if (s.last_picture.data_base[0] == null) {
                            s.mv_dir &= ~MpegEncContext.MV_DIR_FORWARD;
                        }
                        if (s.next_picture.data_base[0] == null) {
                            s.mv_dir &= ~MpegEncContext.MV_DIR_BACKWARD;
                        }
                        s.mb_intra = 0;
                        s.mv_type = 0;
                        s.mb_skipped = 0;
                        if (s.pp_time != 0) {
                            int time_pp = s.pp_time;
                            int time_pb = s.pb_time;
                            ErrorResilience.mv[0][0][0] = s.next_picture.motion_val_base[0][s.next_picture.motion_val_offset[0] + xy][0] * time_pb / time_pp;
                            ErrorResilience.mv[0][0][1] = s.next_picture.motion_val_base[0][s.next_picture.motion_val_offset[0] + xy][1] * time_pb / time_pp;
                            ErrorResilience.mv[1][0][0] = s.next_picture.motion_val_base[0][s.next_picture.motion_val_offset[0] + xy][0] * (time_pb - time_pp) / time_pp;
                            ErrorResilience.mv[1][0][1] = s.next_picture.motion_val_base[0][s.next_picture.motion_val_offset[0] + xy][1] * (time_pb - time_pp) / time_pp;
                        } else {
                            ErrorResilience.mv[0][0][0] = 0;
                            ErrorResilience.mv[0][0][1] = 0;
                            ErrorResilience.mv[1][0][0] = 0;
                            ErrorResilience.mv[1][0][1] = 0;
                        }
                        s.dsp.clear_blocks(s.block, 0);
                        s.mb_x = mb_x;
                        s.mb_y = mb_y;
                        ErrorResilience.decode_mb(s, 0);
                    }
                    ++mb_x;
                }
                ++mb_y;
            }
        } else {
            ErrorResilience.guess_mv(s);
        }
        mb_y = 0;
        while (mb_y < s.mb_height) {
            mb_x = 0;
            while (mb_x < s.mb_width) {
                int mb_xy3 = mb_x + mb_y * s.mb_stride;
                int mb_type = (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy3];
                error = s.error_status_table[mb_xy3];
                if ((7 & mb_type) == 0 || s.partitioned_frame == 0) {
                    int x;
                    int y;
                    int[] dest_y_base = s.current_picture.data_base[0];
                    int dest_y_offset = s.current_picture.data_offset[0] + mb_x * 16 + mb_y * 16 * s.linesize;
                    int[] dest_cb_base = s.current_picture.data_base[1];
                    int dest_cb_offset = s.current_picture.data_offset[1] + mb_x * 8 + mb_y * 8 * s.uvlinesize;
                    int[] dest_cr_base = s.current_picture.data_base[2];
                    int dest_cr_offset = s.current_picture.data_offset[2] + mb_x * 8 + mb_y * 8 * s.uvlinesize;
                    int[] dc_ptr_base = dc_val_base;
                    int dc_ptr_offset = dc_val[0] + mb_x * 2 + mb_y * 2 * s.b8_stride;
                    int n = 0;
                    while (n < 4) {
                        int dc = 0;
                        y = 0;
                        while (y < 8) {
                            x = 0;
                            while (x < 8) {
                                dc += dest_y_base[dest_y_offset + x + (n & 1) * 8 + (y + (n >> 1) * 8) * s.linesize];
                                ++x;
                            }
                            ++y;
                        }
                        dc_ptr_base[dc_ptr_offset + (n & 1) + (n >> 1) * s.b8_stride] = dc + 4 >> 3;
                        ++n;
                    }
                    int dcv = 0;
                    int dcu = 0;
                    y = 0;
                    while (y < 8) {
                        x = 0;
                        while (x < 8) {
                            dcu += dest_cb_base[dest_cb_offset + x + y * s.uvlinesize];
                            dcv += dest_cr_base[dest_cr_offset + x + y * s.uvlinesize];
                            ++x;
                        }
                        ++y;
                    }
                    ErrorResilience.dc_val_base[ErrorResilience.dc_val[1] + mb_x + mb_y * s.mb_stride] = dcu + 4 >> 3;
                    ErrorResilience.dc_val_base[ErrorResilience.dc_val[2] + mb_x + mb_y * s.mb_stride] = dcv + 4 >> 3;
                }
                ++mb_x;
            }
            ++mb_y;
        }
        ErrorResilience.guess_dc(s, dc_val_base, dc_val[0], s.mb_width * 2, s.mb_height * 2, s.b8_stride, 1);
        ErrorResilience.guess_dc(s, dc_val_base, dc_val[1], s.mb_width, s.mb_height, s.mb_stride, 0);
        ErrorResilience.guess_dc(s, dc_val_base, dc_val[2], s.mb_width, s.mb_height, s.mb_stride, 0);
        ErrorResilience.filter181(dc_val_base, dc_val[0], s.mb_width * 2, s.mb_height * 2, s.b8_stride);
        mb_y = 0;
        while (mb_y < s.mb_height) {
            mb_x = 0;
            while (mb_x < s.mb_width) {
                int mb_xy4 = mb_x + mb_y * s.mb_stride;
                int mb_type = (int)s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy4];
                error = s.error_status_table[mb_xy4];
                if ((mb_type & 0x78) == 0 && (error & 2) != 0) {
                    int[] dest_y_base = s.current_picture.data_base[0];
                    int dest_y_offset = s.current_picture.data_offset[0] + mb_x * 16 + mb_y * 16 * s.linesize;
                    int[] dest_cb_base = s.current_picture.data_base[1];
                    int dest_cb_offset = s.current_picture.data_offset[1] + mb_x * 8 + mb_y * 8 * s.uvlinesize;
                    int[] dest_cr_base = s.current_picture.data_base[2];
                    int dest_cr_offset = s.current_picture.data_offset[2] + mb_x * 8 + mb_y * 8 * s.uvlinesize;
                    ErrorResilience.put_dc(s, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, mb_x, mb_y);
                }
                ++mb_x;
            }
            ++mb_y;
        }
        if ((error_concealment & 2) != 0) {
            ErrorResilience.h_block_filter(s, s.current_picture.data_base[0], s.current_picture.data_offset[0], s.mb_width * 2, s.mb_height * 2, s.linesize, 1);
            ErrorResilience.h_block_filter(s, s.current_picture.data_base[1], s.current_picture.data_offset[1], s.mb_width, s.mb_height, s.uvlinesize, 0);
            ErrorResilience.h_block_filter(s, s.current_picture.data_base[2], s.current_picture.data_offset[2], s.mb_width, s.mb_height, s.uvlinesize, 0);
            ErrorResilience.v_block_filter(s, s.current_picture.data_base[0], s.current_picture.data_offset[0], s.mb_width * 2, s.mb_height * 2, s.linesize, 1);
            ErrorResilience.v_block_filter(s, s.current_picture.data_base[1], s.current_picture.data_offset[1], s.mb_width, s.mb_height, s.uvlinesize, 0);
            ErrorResilience.v_block_filter(s, s.current_picture.data_base[2], s.current_picture.data_offset[2], s.mb_width, s.mb_height, s.uvlinesize, 0);
        }
        i = 0;
        while (i < s.mb_num) {
            int mb_xy5 = s.mb_index2xy[i];
            error = s.error_status_table[mb_xy5];
            if (s.pict_type != 3 && (error & 0xE) != 0) {
                s.mbskip_table[mb_xy5] = 0;
            }
            s.mbintra_table[mb_xy5] = 1;
            ++i;
        }
    }
}

