# lein-lib

Leiningen plugin for building local libraries from source when required by various services.

Unlike listing the dependency in `:dependencies`, lein-lib will include the library in `:source-paths` and `:resource-paths`, compiling the library files each time the service is compiled. It will handle dependencies of the local library by concatenating them to the dependencies of the requiring service.

Libraries can require each other using the lein-lib convention, and any top-level parent-library will include all libraries along this local dependency tree.

Requires the Truly monorepo, source-controlled at the top level with all subprojects in their own directories at the top level.

e.g.,
```
root/
   clj-core-common/
   core-api/
   ...
```
## Usage

To use, navigate to `mono/lein-lib` and run `$ lein install` in that directory. Now, you should be able to require `lein-lib` in the plugins key of other project.clj files.
E.g.,

```
:plugins [[com.trulywireless/lein-lib "0.2.0-SNAPSHOT"]]
```

To add a local dependency, add a `:local-libs` key whose value is a list of strings of directory names. Each directory name should be the root of a local library.

e.g.,

```
;; Building with external artifacts (not using lein-lib)
:dependencies [...<maven-style coordinates here>...]
;; Building from source (using lein lib)
:local-libs ["clj-core-common" "clj-utils"]
```

Note that lein-lib will operate recursively for each project that uses it, so libraries can use lein-lib to require other libraries.

## License

Copyright © 2017 Truly Wireless
