/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.maven;

import com.microsoft.windowsazure.maven.ConnectionStringUtils;
import com.microsoft.windowsazure.services.blob.client.CloudBlob;
import com.microsoft.windowsazure.services.blob.client.CloudBlobClient;
import com.microsoft.windowsazure.services.blob.client.CloudBlobContainer;
import com.microsoft.windowsazure.services.blob.client.CloudBlobDirectory;
import com.microsoft.windowsazure.services.blob.client.CloudBlockBlob;
import com.microsoft.windowsazure.services.blob.client.ListBlobItem;
import com.microsoft.windowsazure.services.core.storage.CloudStorageAccount;
import com.microsoft.windowsazure.services.core.storage.StorageErrorCode;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;

public class AzureBlobWagon
extends StreamWagon {
    private CloudStorageAccount storageAccount = null;
    private String baseBlobContainer = null;
    private CloudBlobClient blobClient = null;
    public static final String WAGON_PROTOCOL = "azureblob";
    static final String USEDEVELOPMENTSTORAGE_STRING = "UseDevelopmentStorage";
    static final String ACCOUNTKEY_STRING = "AccountKey";
    static final String DEFAULTENDPOINTSPROTOCOL_STRING = "DefaultEndpointsProtocol";

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        CloudBlockBlob blob = null;
        String resourceName = inputData.getResource().getName();
        String blobName = null;
        blobName = StringUtils.isNotEmpty((CharSequence)this.baseBlobContainer) ? this.baseBlobContainer + (this.baseBlobContainer.endsWith("/") ? resourceName : "/" + resourceName) : resourceName;
        try {
            blob = this.blobClient.getBlockBlobReference(blobName);
            if (!blob.exists()) {
                throw new ResourceDoesNotExistException("Blob with URI '" + blobName + "' doesn't exist in Azure at " + this.storageAccount.getBlobEndpoint());
            }
            inputData.setInputStream((InputStream)blob.openInputStream());
            inputData.getResource().setContentLength(blob.getProperties().getLength());
            inputData.getResource().setLastModified(blob.getProperties().getLastModified().getTime());
        }
        catch (URISyntaxException e) {
            throw new ResourceDoesNotExistException("Blob with URI '" + blobName + "' doesn't exist in Azure at " + this.storageAccount.getBlobEndpoint(), (Throwable)e);
        }
        catch (StorageException e) {
            throw new TransferFailedException("Failed to get resource '" + resourceName + "' from Azure at " + this.storageAccount.getBlobEndpoint(), (Throwable)e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        CloudBlockBlob blob = null;
        String resourceName = outputData.getResource().getName();
        String blobName = null;
        blobName = StringUtils.isNotEmpty((CharSequence)this.baseBlobContainer) ? this.baseBlobContainer + (this.baseBlobContainer.endsWith("/") ? resourceName : "/" + resourceName) : resourceName;
        try {
            blob = this.blobClient.getBlockBlobReference(blobName);
            if (resourceName.contains("/")) {
                blob.getContainer().createIfNotExist();
            } else {
                this.blobClient.getContainerReference("$root").createIfNotExist();
            }
            outputData.setOutputStream((OutputStream)blob.openOutputStream());
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException("Blob with URI '" + blobName + "' doesn't exist in Azure at " + this.storageAccount.getBlobEndpoint(), (Throwable)e);
        }
        catch (StorageException e) {
            throw new TransferFailedException("Failed to put resource '" + resourceName + "' to Azure at " + this.storageAccount.getBlobEndpoint(), (Throwable)e);
        }
        this.fireTransferDebug("resource = " + outputData.getResource());
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        String connectionString;
        String password = null;
        AuthenticationInfo authInfo = this.getAuthenticationInfo();
        if (authInfo != null) {
            password = authInfo.getPassword();
            if (password == null) {
                password = authInfo.getPrivateKey();
            }
            if (password == null) {
                password = authInfo.getPassphrase();
            }
        }
        if ((connectionString = this.getRepository().getUrl()) == null) {
            throw new AuthenticationException("Azure storage connection string must be specified in URL parameter for repository " + this.getRepository().getId());
        }
        if (!(connectionString = ConnectionStringUtils.storageConnectionString(connectionString)).startsWith(DEFAULTENDPOINTSPROTOCOL_STRING) && !connectionString.startsWith(USEDEVELOPMENTSTORAGE_STRING)) {
            throw new AuthenticationException("Azure storage connection string must start with 'DefaultEndpointsProtocol' or 'UseDevelopmentStorage' for repository " + this.getRepository().getId());
        }
        if (password == null && !connectionString.contains(ACCOUNTKEY_STRING)) {
            throw new AuthenticationException("Azure storage account key must be specified in Password, Private Key or Passphrase parameter for repository " + this.getRepository().getId());
        }
        if (!connectionString.contains(ACCOUNTKEY_STRING) && !StringUtils.isEmpty((CharSequence)password)) {
            connectionString = connectionString.concat(";AccountKey=" + password);
        }
        try {
            this.storageAccount = CloudStorageAccount.parse((String)connectionString);
        }
        catch (URISyntaxException e) {
            throw new ConnectionException("Can not open connection to Azure blob storage account. Invalid URI", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new ConnectionException("Can not open connection to Azure blob storage account. Invalid key", (Throwable)e);
        }
        this.baseBlobContainer = ConnectionStringUtils.blobContainer(this.getRepository().getUrl());
        this.blobClient = this.storageAccount.createCloudBlobClient();
        this.blobClient.setTimeoutInMs(this.getTimeout());
    }

    public void closeConnection() throws ConnectionException {
        this.blobClient = null;
        this.storageAccount = null;
    }

    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        ArrayList<String> result = new ArrayList<String>();
        String dirname = destinationDirectory;
        if (StringUtils.isNotEmpty((CharSequence)this.baseBlobContainer)) {
            dirname = this.baseBlobContainer + (this.baseBlobContainer.endsWith("/") ? destinationDirectory : "/" + destinationDirectory);
        }
        try {
            CloudBlobDirectory blobDir = this.blobClient.getDirectoryReference(dirname);
            Iterable blobs = blobDir.listBlobs();
            if (blobs != null) {
                for (ListBlobItem blob : blobs) {
                    String blobDirURL;
                    if (CloudBlob.class.isAssignableFrom(blob.getClass())) {
                        result.add(StringUtils.substringAfterLast((String)((CloudBlob)blob).getName(), (String)"/"));
                        continue;
                    }
                    if (!CloudBlobDirectory.class.isAssignableFrom(blob.getClass()) || (blobDirURL = ((CloudBlobDirectory)blob).getUri().toString()) == null || blobDirURL.length() <= 1 || !blobDirURL.endsWith("/")) continue;
                    result.add(StringUtils.substringAfterLast((String)blobDirURL.substring(0, blobDirURL.length() - 1), (String)"/") + "/");
                }
            }
            if (StringUtils.isEmpty((CharSequence)destinationDirectory)) {
                Iterator iter = this.blobClient.listContainers().iterator();
                while (iter.hasNext()) {
                    result.add(((CloudBlobContainer)iter.next()).getName() + "/");
                }
            }
            if (result.isEmpty() && StringUtils.isNotEmpty((CharSequence)this.baseBlobContainer)) {
                throw new ResourceDoesNotExistException("Blob container/directory with URL '" + blobDir.getUri().toString() + "' doesn't exist");
            }
        }
        catch (URISyntaxException e) {
            throw new ResourceDoesNotExistException("Blob container/directory doesn't exist");
        }
        catch (StorageException e) {
            if (StorageErrorCode.ACCESS_DENIED.toString().equals(e.getErrorCode())) {
                throw new AuthorizationException("Failed to authorize access to Azure Blob storage account");
            }
            throw new TransferFailedException("Failed to get file list", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            if (StorageException.class.isAssignableFrom(e.getCause().getClass())) {
                StorageException storeEx = (StorageException)e.getCause();
                if (storeEx.getHttpStatusCode() == 403) {
                    throw new AuthorizationException("Failed to authorize access to Azure Blob storage account");
                }
                throw new TransferFailedException("Failed to get file list", (Throwable)storeEx);
            }
            throw e;
        }
        return result;
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        boolean result = false;
        if (StringUtils.isEmpty((CharSequence)resourceName)) {
            throw new IllegalArgumentException("Parameter 'resourceName' must not be empty");
        }
        String blobName = null;
        blobName = StringUtils.isNotEmpty((CharSequence)this.baseBlobContainer) ? this.baseBlobContainer + (this.baseBlobContainer.endsWith("/") ? resourceName : "/" + resourceName) : resourceName;
        try {
            CloudBlockBlob blob = this.blobClient.getBlockBlobReference(blobName);
            if (blob.getContainer().getName().length() >= 3) {
                result = blob.exists();
            } else {
                this.fireTransferDebug("Invalid resource name '" + blobName + "'. Resource names for Azure blobs must have containers with 3 chars length at least");
            }
        }
        catch (StorageException e) {
            throw new TransferFailedException("Can not access blob '" + resourceName + "'", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException("Blob '" + resourceName + "' has an invalid URI", (Throwable)e);
        }
        return result;
    }
}

