;; CLN v24.05 - RPC methods generated from doc/schemas directory
;;
;; Do not edit this file directly.
;; See clnrpc-utils/generate-rpcmethods.

(in-ns 'tonyaldon.cln.rpc)

(def rpcmethods
  ["addgossip" "addpsbtoutput" "autoclean-once" "autoclean-status"
   "autocleaninvoice" "batching" "bkpr-channelsapy" "bkpr-dumpincomecsv"
   "bkpr-inspect" "bkpr-listaccountevents" "bkpr-listbalances" "bkpr-listincome"
   "blacklistrune" "check" "checkmessage" "checkrune" "close"
   "commando-blacklist" "commando-listrunes" "commando-rune" "commando"
   "connect" "createinvoice" "createonion" "createrune" "datastore"
   "datastoreusage" "decode" "decodepay" "deldatastore" "delforward"
   "delinvoice" "delpay" "deprecations" "dev-forget-channel"
   "disableinvoicerequest" "disableoffer" "disconnect" "emergencyrecover"
   "feerates" "fetchinvoice" "fundchannel" "fundchannel_cancel"
   "fundchannel_complete" "fundchannel_start" "funderupdate" "fundpsbt"
   "getinfo" "getlog" "getroute" "help" "invoice" "invoicerequest" "keysend"
   "listchannels" "listclosedchannels" "listconfigs" "listdatastore"
   "listforwards" "listfunds" "listhtlcs" "listinvoicerequests" "listinvoices"
   "listnodes" "listoffers" "listpays" "listpeerchannels" "listpeers"
   "listsendpays" "listsqlschemas" "listtransactions" "makesecret"
   "multifundchannel" "multiwithdraw" "newaddr" "notifications" "offer"
   "openchannel_abort" "openchannel_bump" "openchannel_init"
   "openchannel_signed" "openchannel_update" "parsefeerate" "pay" "ping"
   "plugin" "preapproveinvoice" "preapprovekeysend" "recover" "recoverchannel"
   "renepay" "renepaystatus" "reserveinputs" "sendcustommsg" "sendinvoice"
   "sendonion" "sendonionmessage" "sendpay" "sendpsbt" "setchannel" "setconfig"
   "setpsbtversion" "showrunes" "signinvoice" "signmessage" "signpsbt"
   "splice_init" "splice_signed" "splice_update" "sql-template" "staticbackup"
   "stop" "txdiscard" "txprepare" "txsend" "unreserveinputs" "upgradewallet"
   "utxopsbt" "wait" "waitanyinvoice" "waitblockheight" "waitinvoice"
   "waitsendpay" "withdraw"])

(defn addgossip
  "Send addgossip request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  MESSAGE
      - type: hex
      - description: The raw, hex-encoded, gossip message to add to the local gossip view."
  [rpc-info message]
  (call rpc-info "addgossip" {:message message}))

(defn addpsbtoutput
  "Send addpsbtoutput request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  SATOSHI
      - type: sat
      - description: The satoshi value of the output. It can be a whole number, a whole number ending in *sat*, or a number with 1 to 8 decimal places ending in *btc*.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :initialpsbt
      - type: string
      - description: Base 64 encoded PSBT to add the output to. If not specified, one will be generated automatically.

  :locktime
      - type: u32
      - description: If not set, it is set to a recent block height (if no initial psbt is specified).

  :destination
      - type: string
      - description: If it is not set, an internal address is generated."
  [rpc-info satoshi & opt-params]
  (call rpc-info
        "addpsbtoutput"
        (merge {:satoshi satoshi} (apply hash-map opt-params))))

(defn autoclean-once
  "Send autoclean-once request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  SUBSYSTEM
      - type: string
      - description: What subsystem to clean. Currently supported subsystems are:
          * `failedforwards`: routed payments which did not succeed (`failed` or `local_failed` in listforwards `status`).
          * `succeededforwards`: routed payments which succeeded (`settled` in listforwards `status`).
          * `failedpays`: payment attempts which did not succeed (`failed` in listpays `status`).
          * `succeededpays`: payment attempts which succeeded (`complete` in listpays `status`).
          * `expiredinvoices`: invoices which were not paid (and cannot be) (`expired` in listinvoices `status`).
          * `paidinvoices`: invoices which were paid (`paid` in listinvoices `status).

  AGE
      - type: u64
      - description: Non-zero number in seconds. How many seconds old an entry must be to delete it."
  [rpc-info subsystem age]
  (call rpc-info "autoclean-once" {:subsystem subsystem, :age age}))

(defn autoclean-status
  "Send autoclean-status request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :subsystem
      - type: string
      - description: What subsystem to ask about. Currently supported subsystems are:
          * `failedforwards`: routed payments which did not succeed (`failed` or `local_failed` in listforwards `status`).
          * `succeededforwards`: routed payments which succeeded (`settled` in listforwards `status`).
          * `failedpays`: payment attempts which did not succeed (`failed` in listpays `status`).
          * `succeededpays`: payment attempts which succeeded (`complete` in listpays `status`).
          * `expiredinvoices`: invoices which were not paid (and cannot be) (`expired` in listinvoices `status`).
          * `paidinvoices`: invoices which were paid (`paid` in listinvoices `status)."
  [rpc-info & opt-params]
  (call rpc-info "autoclean-status" (apply hash-map opt-params)))

(defn autocleaninvoice
  "Send autocleaninvoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :expired_by
      - type: u64
      - description: How long an invoice must be expired (seconds) before we delete it.

  :cycle_seconds
      - type: u64
      - description: The interval (in seconds) between cleaning expired invoices."
  [rpc-info & opt-params]
  (call rpc-info "autocleaninvoice" (apply hash-map opt-params)))

(defn batching
  "Send batching request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ENABLE
      - type: boolean
      - description: Whether to enable or disable transaction batching."
  [rpc-info enable]
  (call rpc-info "batching" {:enable enable}))

(defn bkpr-channelsapy
  "Send bkpr-channelsapy request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :start_time
      - type: u64
      - description: UNIX timestamp (in seconds) to filter events after the provided timestamp.

  :end_time
      - type: u64
      - description: UNIX timestamp (in seconds) to filter events up to and at the provided timestamp."
  [rpc-info & opt-params]
  (call rpc-info "bkpr-channelsapy" (apply hash-map opt-params)))

(defn bkpr-dumpincomecsv
  "Send bkpr-dumpincomecsv request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  CSV_FORMAT
      - type: string
      - description: CSV format to use. See RETURN VALUE for options.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :csv_file
      - type: string
      - description: On-disk destination of the generated CSV file.

  :consolidate_fees
      - type: boolean
      - description: If true, we emit a single, consolidated event for any onchain-fees for a txid and account. Otherwise, events for every update to the onchain fee calculation for this account and txid will be printed. Note that this means that the events emitted are non-stable, i.e. calling **dumpincomecsv** twice may result in different onchain fee events being emitted, depending on how much information we've logged for that transaction.

  :start_time
      - type: u64
      - description: UNIX timestamp (in seconds) that filters events after the provided timestamp.

  :end_time
      - type: u64
      - description: UNIX timestamp (in seconds) that filters events up to and at the provided timestamp."
  [rpc-info csv_format & opt-params]
  (call rpc-info
        "bkpr-dumpincomecsv"
        (merge {:csv_format csv_format} (apply hash-map opt-params))))

(defn bkpr-inspect
  "Send bkpr-inspect request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ACCOUNT
      - type: string
      - description: Channel account to inspect."
  [rpc-info account]
  (call rpc-info "bkpr-inspect" {:account account}))

(defn bkpr-listaccountevents
  "Send bkpr-listaccountevents request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :account
      - type: string
      - description: Receive events for the specified account."
  [rpc-info & opt-params]
  (call rpc-info "bkpr-listaccountevents" (apply hash-map opt-params)))

(defn bkpr-listbalances
  "Send bkpr-listbalances request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details."
  [rpc-info]
  (call rpc-info "bkpr-listbalances"))

(defn bkpr-listincome
  "Send bkpr-listincome request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :consolidate_fees
      - type: boolean
      - description: If true, we emit a single, consolidated event for any onchain-fees for a txid and account. Otherwise, events for every update to the onchain fee calculation for this account and txid will be printed. Note that this means that the events emitted are non-stable, i.e. calling **listincome** twice may result in different onchain fee events being emitted, depending on how much information we've logged for that transaction.

  :start_time
      - type: u32
      - description: UNIX timestamp (in seconds) that filters events after the provided timestamp.

  :end_time
      - type: u32
      - description: UNIX timestamp (in seconds) that filters events up to and at the provided timestamp."
  [rpc-info & opt-params]
  (call rpc-info "bkpr-listincome" (apply hash-map opt-params)))

(defn blacklistrune
  "Send blacklistrune request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :start
      - type: u64
      - description: First rune unique id to blacklist.

  :end
      - type: u64
      - description: Final rune unique id to blacklist (defaults to start)."
  [rpc-info & opt-params]
  (call rpc-info "blacklistrune" (apply hash-map opt-params)))

(defn check
  "Send check request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  COMMAND_TO_CHECK
      - type: string
      - description: Name of the relevant command."
  [rpc-info command_to_check]
  (call rpc-info "check" {:command_to_check command_to_check}))

(defn checkmessage
  "Send checkmessage request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  MESSAGE
      - type: string
      - description: Message to be checked against the signature.

  ZBASE
      - type: string
      - description: The Zbase32 encoded signature to verify.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :pubkey
      - type: pubkey
      - description: The Zbase32 encoded signature to verify."
  [rpc-info message zbase & opt-params]
  (call rpc-info
        "checkmessage"
        (merge {:message message, :zbase zbase} (apply hash-map opt-params))))

(defn checkrune
  "Send checkrune request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  RUNE
      - type: string
      - description: Rune to check for authorization.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :nodeid
      - type: string
      - description: Node id of requesting node *(required until v23.11)*.

  :method
      - type: string
      - description: Method for which rune needs to be validated *(required until v23.11)*.

  :params
      - type: array
      - description: Array of positional parameters.

      or

      - type: object
      - description: Parameters for method."
  [rpc-info rune & opt-params]
  (call rpc-info "checkrune" (merge {:rune rune} (apply hash-map opt-params))))

(defn close
  "Send close request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: string
      - description: Peer id, channel id or short_channel_id. If the given *id* is a peer ID (66 hex digits as a string), then it applies to the active channel of the direct peer corresponding to the given peer ID. If the given *id* is a channel ID (64 hex digits as a string, or the short channel ID *blockheight:txindex:outindex* form), then it applies to that channel.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :unilateraltimeout
      - type: u32
      - description: If it is not zero, the command will unilaterally close the channel when that number of seconds is reached. If *unilateraltimeout* is zero, then the command will wait indefinitely until the peer is online and can negotiate a mutual close.

  :destination
      - type: string
      - description: Any Bitcoin bech32 type. If the peer hasn't offered the option_shutdown_anysegwit feature, then taproot addresses (or other v1+ segwit) are not allowed. Tell your friends to upgrade!

  :fee_negotiation_step
      - type: string
      - description: It controls how closing fee negotiation is performed assuming the peer proposes a fee that is different than our estimate. (Note that modern peers use the quick-close protocol which does not allow negotiation: see *feerange* instead).
      
      On every negotiation step we must give up some amount from our proposal towards the peer's proposal. This parameter can be an integer in which case it is interpreted as number of satoshis to step at a time. Or it can be an integer followed by `%` to designate a percentage of the interval to give up. A few examples, assuming the peer proposes a closing fee of 3000 satoshi and our estimate shows it must be 4000:
          * `10`: our next proposal will be 4000-10=3990.
          * `10%`: our next proposal will be 4000-(10% of (4000-3000))=3900.
          * '1': our next proposal will be 3999. This is the most extreme case when we insist on our fee as much as possible.
          * `100%`: our next proposal will be 3000. This is the most relaxed case when we quickly accept the peer's proposal.

  :wrong_funding
      - type: outpoint
      - description: It can only be specified if both sides have offered the `shutdown_wrong_funding` feature (enabled by the **experimental-shutdown-wrong-funding** option). It must be a transaction id followed by a colon then the output number. Instead of negotiating a shutdown to spend the expected funding transaction, the shutdown transaction will spend this output instead. This is only allowed if this peer opened the channel and the channel is unused: it can rescue openings which have been manually miscreated.

  :force_lease_closed
      - type: boolean
      - description: If the channel has funds leased to the peer (option_will_fund), we prevent initiation of a mutual close unless this flag is passed in.

  :feerange
      - type: array
      - description: An optional array [ *min*, *max* ], indicating the minimum and maximum feerates to offer: the peer will obey these if it supports the quick-close protocol. *slow* and *unilateral_close* are the defaults. Note that the maximum fee will be capped at the final commitment transaction fee (unless the experimental anchor-outputs option is negotiated)."
  [rpc-info id & opt-params]
  (call rpc-info "close" (merge {:id id} (apply hash-map opt-params))))

(defn commando-blacklist
  "Send commando-blacklist request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :start
      - type: u64
      - description: First rune unique id to blacklist.

  :end
      - type: u64
      - description: Final rune unique id to blacklist (defaults to start)."
  [rpc-info & opt-params]
  (call rpc-info "commando-blacklist" (apply hash-map opt-params)))

(defn commando-listrunes
  "Send commando-listrunes request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :rune
      - type: string
      - description: Optional rune to list."
  [rpc-info & opt-params]
  (call rpc-info "commando-listrunes" (apply hash-map opt-params)))

(defn commando-rune
  "Send commando-rune request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :rune
      - type: string
      - description: If supplied, the restrictions are simple appended to that *rune* (it doesn't need to be a rune belonging to this node). If not supplied, a new *rune* is constructed, with a new unique id.

  :restrictions
      - type: array
      - description: Alternatives use a simple language to examine the command which is being run:
          * time: the current UNIX time, e.g. \"time<1656759180\".
          * id: the node_id of the peer, e.g. \"id=024b9a1fa8e006f1e3937f65f66c408e6da8e1ca728ea43222a7381df1cc449605\".
          * method: the command being run, e.g. \"method=withdraw\".
          * per: how often the rune can be used, with suffix \"sec\" (default), \"min\", \"hour\", \"day\" or \"msec\", \"usec\" or \"nsec\". e.g. \"per=5sec\".
          * rate: the rate limit, per minute, e.g. \"rate=60\" is equivalent to \"per=1sec\".
          * pnum: the number of parameters. e.g. \"pnum<2\".
          * pnameX: the parameter named X (with any punctuation like `_` removed). e.g. \"pnamedestination=1RustyRX2oai4EYYDpQGWvEL62BBGqN9T\".
          * parrN: the N'th parameter. e.g. \"parr0=1RustyRX2oai4EYYDpQGWvEL62BBGqN9T\".

      or

      - type: string
      - description: A rune which allows most *get* and *list* commands, and the *summary* command."
  [rpc-info & opt-params]
  (call rpc-info "commando-rune" (apply hash-map opt-params)))

(defn commando
  "Send commando request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  PEER_ID
      - type: pubkey
      - description: Peer to command.

  METHOD
      - type: string
      - description: Method to invoke on peer.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :params
      - type: array
      - description: Array of positional parameters.

      or

      - type: object
      - description: Parameters for method.

  :rune
      - type: string
      - description: Rune to authorize the command.

  :filter
      - type: object
      - description: Filter to peer to apply to any successful result."
  [rpc-info peer_id method & opt-params]
  (call rpc-info
        "commando"
        (merge {:peer_id peer_id, :method method} (apply hash-map opt-params))))

(defn connect
  "Send connect request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: string
      - description: The target node's public key. As a convenience, *id* may be of the form *id@host* or *id@host:port*. In this case, the *host* and *port* parameters must be omitted. This can fail if your C-lightning node is a fresh install that has not connected to any peers yet (your node has no gossip yet), or if the target *id* is a fresh install that has no channels yet (nobody will gossip about a node until it has one published channel).

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :host
      - type: string
      - description: The peer's hostname or IP address. If *host* is not specified (or doesn't work), the connection will be attempted to an IP belonging to *id* obtained through gossip with other already connected peers. If *host* begins with a `/` it is interpreted as a local path and the connection will be made to that local socket (see **bind-addr** in lightningd-config(5)).

  :port
      - type: u16
      - description: The peer's port number. If not specified, the *port* depends on the current network:
          * bitcoin **mainnet**: 9735.
          * bitcoin **testnet**: 19735.
          * bitcoin **signet**: 39735.
          * bitcoin **regtest**: 19846."
  [rpc-info id & opt-params]
  (call rpc-info "connect" (merge {:id id} (apply hash-map opt-params))))

(defn createinvoice
  "Send createinvoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  INVSTRING
      - type: string
      - description: The bolt11 form, but the final signature is ignored. Minimal sanity checks are done. (Note: if **experimental-offers** is enabled, *invstring* can actually be an unsigned bolt12 invoice).

  LABEL
      - type: string
      - description:

      or

      - type: integer
      - description:

  PREIMAGE
      - type: hex
      - description: The preimage to supply upon successful payment of the invoice."
  [rpc-info invstring label preimage]
  (call rpc-info
        "createinvoice"
        {:invstring invstring, :label label, :preimage preimage}))

(defn createonion
  "Send createonion request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  HOPS
      - type: array
      - description: A JSON list of dicts, each specifying a node and the payload destined for that node.

  ASSOCDATA
      - type: hex
      - description: The associated data that the onion should commit to. If the onion is to be used to send a payment later it MUST match the `payment_hash` of the payment in order to be valid.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :session_key
      - type: secret
      - description: Can be used to specify a secret that is used to generate the shared secrets used to encrypt the onion for each hop. It should only be used for testing or if a specific shared secret is important. If not specified it will be securely generated internally, and the shared secrets will be returned.

  :onion_size
      - type: u16
      - description: A size different from the default payment onion (1300 bytes). May be used for custom protocols like trampoline routing."
  [rpc-info hops assocdata & opt-params]
  (call rpc-info
        "createonion"
        (merge {:hops hops, :assocdata assocdata} (apply hash-map opt-params))))

(defn createrune
  "Send createrune request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :rune
      - type: string
      - description: If supplied, the restrictions are simple appended to that *rune* (it doesn't need to be a rune belonging to this node). If not supplied, a new *rune* is constructed, with a new unique id.

  :restrictions
      - type: array
      - description: Alternatives use a simple language to examine the command which is being run:
          * time: the current UNIX time, e.g. \"time<1656759180\".
          * id: the node_id of the peer, e.g. \"id=024b9a1fa8e006f1e3937f65f66c408e6da8e1ca728ea43222a7381df1cc449605\".
          * method: the command being run, e.g. \"method=withdraw\".
          * per: how often the rune can be used, with suffix \"sec\" (default), \"min\", \"hour\", \"day\" or \"msec\", \"usec\" or \"nsec\". e.g. \"per=5sec\".
          * rate: the rate limit, per minute, e.g. \"rate=60\" is equivalent to \"per=1sec\".
          * pnum: the number of parameters. e.g. \"pnum<2\".
          * pnameX: the parameter named X e.g. \"pnamedestination=1RustyRX2oai4EYYDpQGWvEL62BBGqN9T\".  NOTE: until v24.05, X had to remove underscores from the parameter name (e.g. `pnameamount_msat` had to be specified as `pnameamountmsat`) but that is now fixed.
          * parrN: the N'th parameter. e.g. \"parr0=1RustyRX2oai4EYYDpQGWvEL62BBGqN9T\".
          * pinvX_N: parse the parameter X as an invoice (bolt11 or bolt12) and extract field N for comparison.  Fails if parameter X is not present, does not parse, or N is not one of the following field names:
            * amount
            * description
            * node

      or

      - type: string
      - description: A rune which allows most *get* and *list* commands, and the *summary* command."
  [rpc-info & opt-params]
  (call rpc-info "createrune" (apply hash-map opt-params)))

(defn datastore
  "Send datastore request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  KEY
      - type: array
      - description: An array of values to form a hierarchy (though a single value is treated as a one-element array). Using the first element of the key as the plugin name (e.g. `[ 'summary' ]`) is recommended.

      or

      - type: string
      - description:

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :string
      - type: string
      - description: Data to be saved in string format.

  :hex
      - type: hex
      - description: Data to be saved in hex format.

  :mode
      - type: string
      - description: Write mode to determine how the record is updated:
          * `must-create`: fails if it already exists.
          * `must-replace`: fails if it doesn't already exist.
          * `create-or-replace`: never fails.
          * `must-append`: must already exist, append this to what's already there.
          * `create-or-append`: append if anything is there, otherwise create.

  :generation
      - type: u64
      - description: If specified, means that the update will fail if the previously-existing data is not exactly that generation. This allows for simple atomicity. This is only legal with *mode* `must-replace` or `must-append`."
  [rpc-info key & opt-params]
  (call rpc-info "datastore" (merge {:key key} (apply hash-map opt-params))))

(defn datastoreusage
  "Send datastoreusage request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :key
      - type: array
      - description: Key is an array of values (though a single value is treated as a one-element array). Used as the starting point to traverse the datastore.

      or

      - type: string
      - description:"
  [rpc-info & opt-params]
  (call rpc-info "datastoreusage" (apply hash-map opt-params)))

(defn decode
  "Send decode request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  STRING
      - type: string
      - description: Value to be decoded:
          * a *bolt11* or *bolt12* string (optionally prefixed by `lightning:` or `LIGHTNING:`) as specified by the BOLT 11 and BOLT 12 specifications.
          * a *rune* as created by lightning-commando-rune(7).
          * an *emergency_recover* string generated by hsmtool like `lightning-hsmtool getemergencyrecover <path/to/emergency.recover>`. It holds `emergency.recover` contents and starts with `clnemerg1`."
  [rpc-info string]
  (call rpc-info "decode" {:string string}))

(defn decodepay
  "Send decodepay request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  BOLT11
      - type: string
      - description: Bolt11 invoice to decode.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :description
      - type: string
      - description: Description of the invoice to decode."
  [rpc-info bolt11 & opt-params]
  (call rpc-info
        "decodepay"
        (merge {:bolt11 bolt11} (apply hash-map opt-params))))

(defn deldatastore
  "Send deldatastore request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  KEY
      - type: array
      - description: Key is an array of values (though a single value is treated as a one-element array), to form a heirarchy. Using the first element of the key as the plugin name (e.g. [ 'summary' ]) is recommended. A key can either have children or a value, never both: parents are created and removed automatically.

      or

      - type: string
      - description:

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :generation
      - type: u64
      - description: If specified, means that the update will fail if the previously-existing data is not exactly that generation. This allows for simple atomicity. This is only legal with mode `must-replace` or `must-append`."
  [rpc-info key & opt-params]
  (call rpc-info "deldatastore" (merge {:key key} (apply hash-map opt-params))))

(defn delforward
  "Send delforward request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  IN_CHANNEL
      - type: short_channel_id
      - description: Only the matching forwards on the given inbound channel are deleted. Note: for **listforwards** entries without an *in_htlc_id* entry (no longer created in v22.11, but can exist from older versions), a value of 18446744073709551615 can be used, but then it will delete *all* entries without *in_htlc_id* for this *in_channel* and *status*.

  IN_HTLC_ID
      - type: u64
      - description: The unique HTLC id the sender gave this (not present if incoming channel was closed before upgrade to v22.11).

  STATUS
      - type: string
      - description: The status of the forward to delete. You cannot delete forwards which have status *offered* (i.e. are currently active)."
  [rpc-info in_channel in_htlc_id status]
  (call rpc-info
        "delforward"
        {:in_channel in_channel, :in_htlc_id in_htlc_id, :status status}))

(defn delinvoice
  "Send delinvoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  LABEL
      - type: string
      - description:

      or

      - type: u64
      - description:

  STATUS
      - type: string
      - description: Label of the invoice to be deleted. The caller should be particularly aware of the error case caused by the *status* changing just before this command is invoked!

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :desconly
      - type: boolean
      - description: If set to True, the invoice is not deleted, but has its description removed (this can save space with very large descriptions, as would be used with lightning-invoice(7) *deschashonly*."
  [rpc-info label status & opt-params]
  (call rpc-info
        "delinvoice"
        (merge {:label label, :status status} (apply hash-map opt-params))))

(defn delpay
  "Send delpay request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  PAYMENT_HASH
      - type: hash
      - description: The unique identifier of a payment.

  STATUS
      - type: string
      - description: Expected status of the payment. Only deletes if the payment status matches. Deleting a `pending` payment will return an error.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :partid
      - type: u64
      - description: Specific partid to delete (must be paired with *groupid*).

  :groupid
      - type: u64
      - description: Specific groupid to delete (must be paired with *partid*)."
  [rpc-info payment_hash status & opt-params]
  (call rpc-info
        "delpay"
        (merge {:payment_hash payment_hash, :status status}
               (apply hash-map opt-params))))

(defn deprecations
  "Send deprecations request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ENABLE
      - type: boolean
      - description: Flag to enable or disable deprecated APIs. Setting it to `false` will neither accept deprecated parameters or commands, nor output deprecated fields."
  [rpc-info enable]
  (call rpc-info "deprecations" {:enable enable}))

(defn dev-forget-channel
  "Send dev-forget-channel request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: pubkey
      - description: The peer id of the channel to be forgotten. Checks if the channel is still active by checking its funding transaction.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :short_channel_id
      - type: short_channel_id
      - description: The short channel id of the channel you want to remove.

  :channel_id
      - type: hash
      - description: The channel id of the channel you want to remove.

  :force
      - type: boolean
      - description: Ignores UTXO check for forced removal."
  [rpc-info id & opt-params]
  (call rpc-info
        "dev-forget-channel"
        (merge {:id id} (apply hash-map opt-params))))

(defn disableinvoicerequest
  "Send disableinvoicerequest request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  INVREQ_ID
      - type: string
      - description: A specific invoice can be disabled by providing the `invreq_id`, which is presented by lightning-invoicerequest(7)."
  [rpc-info invreq_id]
  (call rpc-info "disableinvoicerequest" {:invreq_id invreq_id}))

(defn disableoffer
  "Send disableoffer request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  OFFER_ID
      - type: hash
      - description: The id we use to identify this offer."
  [rpc-info offer_id]
  (call rpc-info "disableoffer" {:offer_id offer_id}))

(defn disconnect
  "Send disconnect request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: pubkey
      - description: The public key of the peer to terminate the connection. It can be discovered in the output of the listpeers command, which returns a set of peers:
      {
        'peers':
        [
          {
            'id': '0563aea81...',
            'connected': true,
            ...
          }
        ]
      }

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :force
      - type: boolean
      - description: If set to True, it will disconnect even with an active channel."
  [rpc-info id & opt-params]
  (call rpc-info "disconnect" (merge {:id id} (apply hash-map opt-params))))

(defn emergencyrecover
  "Send emergencyrecover request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details."
  [rpc-info]
  (call rpc-info "emergencyrecover"))

(defn feerates
  "Send feerates request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  STYLE
      - type: string
      - description: Fee rate style to use. This can be:
          *perkw* - provide feerate in units of satoshis per 1000 weight (e.g. the minimum fee is usually `253perkw`).
          *perkb* - provide feerate in units of satoshis per 1000 virtual bytes (eg. the minimum fee is usually `1000perkb`)."
  [rpc-info style]
  (call rpc-info "feerates" {:style style}))

(defn fetchinvoice
  "Send fetchinvoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  OFFER
      - type: string
      - description: Offer string to get an actual invoice that can be paid.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :amount_msat
      - type: msat
      - description: Required if the offer does not specify an amount at all, otherwise it is optional (but presumably if you set it to less than the offer, you will get an error from the issuer).

  :quantity
      - type: u64
      - description: Required if the offer specifies quantity_max, otherwise it is not allowed.

  :recurrence_counter
      - type: u64
      - description: Required if the offer specifies recurrence, otherwise it is not allowed. recurrence_counter should first be set to 0, and incremented for each successive invoice in a given series.

  :recurrence_start
      - type: number
      - description: Required if the offer specifies recurrence_base with start_any_period set, otherwise it is not allowed. It indicates what period number to start at.

  :recurrence_label
      - type: string
      - description: Required if recurrence_counter is set, and otherwise is not allowed. It must be the same as prior fetchinvoice calls for the same recurrence, as it is used to link them together.

  :timeout
      - type: number
      - description: If we don't get a reply before this we fail (default, 60 seconds).

  :payer_note
      - type: string
      - description: To ask the issuer to include in the fetched invoice."
  [rpc-info offer & opt-params]
  (call rpc-info
        "fetchinvoice"
        (merge {:offer offer} (apply hash-map opt-params))))

(defn fundchannel
  "Send fundchannel request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: pubkey
      - description: Id is the peer id obtained from connect.

  AMOUNT
      - type: sat_or_all
      - description: The amount in satoshis taken from the internal wallet to fund the channel (but if we have any anchor channels, this will always leave at least `min-emergency- msat` as change). The string *all* can be used to specify all available funds (or 16777215 satoshi if more is available and large channels were not negotiated with the peer). Otherwise, it is in satoshi precision; it can be a whole number, a whole number ending in *sat*, a whole number ending in *000msat*, or a number with 1 to 8 decimal places ending in *btc*. The value cannot be less than the dust limit, currently set to 546, nor more than 16777215 satoshi (unless large channels were negotiated with the peer).

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :utxos
      - type: array
      - description: The utxos to be used to fund the channel, as an array of `txid:vout`.

  :reserve
      - type: sat
      - description: The amount we want the peer to maintain on its side of the channel. It can be a whole number, a whole number ending in *sat*, a whole number ending in *000msat*, or a number with 1 to 8 decimal places ending in *btc*.

  :request_amt
      - type: sat
      - description: An amount of liquidity you'd like to lease from the peer. If peer supports `option_will_fund`, indicates to them to include this much liquidity into the channel. Must also pass in *compact_lease*.

  :channel_type
      - type: array
      - description:

  :push_msat
      - type: msat
      - description: The amount of millisatoshis to push to the channel peer at open. Note that this is a gift to the peer -- these satoshis are added to the initial balance of the peer at channel start and are largely unrecoverable once pushed.

  :minconf
      - type: u32
      - description: The minimum number of confirmations that used outputs should have.

  :mindepth
      - type: u32
      - description: Number of confirmations required before we consider the channel active.

  :feerate
      - type: feerate
      - description: Used for the opening transaction and (unless *option_anchors_zero_fee_htlc_tx* is negotiated), as initial feerate for commitment and HTLC transactions (see NOTES in lightning-feerates(7)).

  :announce
      - type: boolean
      - description: Whether to announce this channel or not. An unannounced channel is considered private.

  :close_to
      - type: string
      - description: A Bitcoin address to which the channel funds should be sent to on close. Only valid if both peers have negotiated `option_upfront_shutdown_script`. Returns `close_to` set to closing script iff is negotiated.

  :compact_lease
      - type: string
      - description: A compact representation of the peer's expected channel lease terms. If the peer's terms don't match this set, we will fail to open the channel."
  [rpc-info id amount & opt-params]
  (call rpc-info
        "fundchannel"
        (merge {:id id, :amount amount} (apply hash-map opt-params))))

(defn fundchannel_cancel
  "Send fundchannel_cancel request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: pubkey
      - description: Node id of the remote peer with which to cancel."
  [rpc-info id]
  (call rpc-info "fundchannel_cancel" {:id id}))

(defn fundchannel_complete
  "Send fundchannel_complete request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: pubkey
      - description: Node id of the remote peer.

  PSBT
      - type: string
      - description: Transaction to use for funding (does not need to be signed but must be otherwise complete)."
  [rpc-info id psbt]
  (call rpc-info "fundchannel_complete" {:id id, :psbt psbt}))

(defn fundchannel_start
  "Send fundchannel_start request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: pubkey
      - description: The peer id obtained from connect.

  AMOUNT
      - type: sat
      - description: Satoshi value that the channel will be funded at. This value MUST be accurate, otherwise the negotiated commitment transactions will not encompass the correct channel value.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :reserve
      - type: sat
      - description: The amount we want the peer to maintain on its side.

  :channel_type
      - type: array
      - description: Each bit set in this channel_type.

  :push_msat
      - type: msat
      - description: Amount of millisatoshis to push to the channel peer at open. Note that this is a gift to the peer -- these satoshis are added to the initial balance of the peer at channel start and are largely unrecoverable once pushed.

  :mindepth
      - type: u32
      - description: Number of confirmations required before we consider the channel active.

  :feerate
      - type: feerate
      - description: Feerate for subsequent commitment transactions: see **fundchannel**. Note that this is ignored for channels with *option_anchors_zero_fee_htlc_tx* (we always use a low commitment fee for these).

  :announce
      - type: boolean
      - description: Whether or not to announce this channel.

  :close_to
      - type: string
      - description: Bitcoin address to which the channel funds should be sent to on close. Only valid if both peers have negotiated `option_upfront_shutdown_script`. Returns `close_to` set to closing script iff is negotiated."
  [rpc-info id amount & opt-params]
  (call rpc-info
        "fundchannel_start"
        (merge {:id id, :amount amount} (apply hash-map opt-params))))

(defn funderupdate
  "Send funderupdate request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :fuzz_percent
      - type: u32
      - description: A percentage to fuzz the resulting contribution amount by. Valid values are 0 to 100. Note that turning this on with (match, 100) policy will randomly fail `option_will_fund` leases, as most clients expect an exact or greater match of their `requested_funds`.

  :reserve_tank_msat
      - type: msat
      - description: Amount of sats to leave available in the node wallet.

  :policy_mod
      - type: msat
      - description: Number or 'modification' to apply to the policy.

  :channel_fee_max_base_msat
      - type: msat
      - description: A commitment to a maximum `channel_fee_base_msat` that your node will charge for routing payments over this leased channel during the lease duration.

  :lease_fee_base_msat
      - type: msat
      - description: Flat fee for a channel lease. Node will receive this much extra added to their channel balance, paid by the opening node. Note that the minimum is 1sat.

  :fund_probability
      - type: u32
      - description: The percent of v2 channel open requests to apply our policy to. Valid values are integers from 0 (fund 0% of all open requests) to 100 (fund every request). Useful for randomizing opens that receive funds. Useful for randomizing opens that receive funds.

  :funding_weight
      - type: u32
      - description: To calculate the fee the peer will compensate your node for its contributing inputs to the funding transaction. The total fee is calculated as the `open_channel2`.`funding_feerate_perkw` times this *funding_weight* divided by 1000. Node will have this funding fee added to their channel balance, paid by the opening node.

  :per_channel_min_msat
      - type: msat
      - description: Minimum amount that we will contribute to a channel open.

  :policy
      - type: string
      - description: Funder plugin will use to decide how much capital to commit to a v2 open channel request.
      There are three policy options, detailed below:
          * `match` -- Contribute *policy_mod* percent of their requested funds. Valid *policy_mod* values are 0 to 200. If this is a channel lease request, we match based on their requested funds. If it is not a channel lease request (and *lease_only* is false), then we match their funding amount. Note: any lease match less than 100 will likely fail, as clients will not accept a lease less than their request.
          * `available` -- Contribute *policy_mod* percent of our available node wallet funds. Valid *policy_mod* values are 0 to 100.
          * `fixed` -- Contributes a fixed  *policy_mod* sats to v2 channel open requests.

  :max_their_funding_msat
      - type: msat
      - description: Maximum funding sats that we will consider to activate our contribution policy to the v2 open. Any channel open above this will not be funded.

  :channel_fee_max_proportional_thousandths
      - type: u32
      - description: A commitment to a maximum `channel_fee_proportional_millionths` that your node will charge for routing payments over this leased channel during the lease duration. Note that it's denominated in 'thousandths'. A setting of `1` is equal to 1k ppm; `5` is 5k ppm, etc.

  :leases_only
      - type: boolean
      - description: Only contribute funds to `option_will_fund` requests which pay to lease funds. It will fund any v2 open request using *policy* even if it's they're not seeking to lease funds. Note that `option_will_fund` commits funds for 4032 blocks (~1mo). Must also set *lease_fee_base_msat*, *lease_fee_basis*, *funding_weight*, *channel_fee_max_base_msat*, and *channel_fee_max_proportional_thousandths* to advertise available channel leases.

  :lease_fee_basis
      - type: u32
      - description: A basis fee that's calculated as 1/10k of the total requested funds the peer is asking for. Node will receive the total of *lease_fee_basis* times requested funds / 10k satoshis added to their channel balance, paid by the opening node.

  :per_channel_max_msat
      - type: msat
      - description: Maximum amount that we will contribute to a channel open.

  :min_their_funding_msat
      - type: msat
      - description: Minimum funding sats that we require in order to activate our contribution policy to the v2 open.

  :compact_lease
      - type: hex
      - description: A compact description of the channel lease params. When opening a channel, passed in to `fundchannel` to indicate the terms we expect from the peer."
  [rpc-info & opt-params]
  (call rpc-info "funderupdate" (apply hash-map opt-params)))

(defn fundpsbt
  "Send fundpsbt request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  SATOSHI
      - type: sat_or_all
      - description: The minimum satoshi value of the output(s) needed (or the string `all` meaning use all unreserved inputs). If a value, it can be a whole number, a whole number ending in *sat*, a whole number ending in *000msat*, or a number with 1 to 8 decimal places ending in *btc*.

  FEERATE
      - type: feerate
      - description: Used for the transaction as initial feerate.

  STARTWEIGHT
      - type: u32
      - description: The weight of the transaction before *fundpsbt* has added any inputs.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :reserve
      - type: u32
      - description: If not zero, then *reserveinputs* is called (successfully, with *exclusive* true) on the returned PSBT for this number of blocks.

  :minconf
      - type: u32
      - description: The minimum number of confirmations that used outputs should have.

  :nonwrapped
      - type: boolean
      - description: To signal to filter out any p2sh-wrapped inputs from funding this PSBT.

  :excess_as_change
      - type: boolean
      - description: Flag to add a change output for the excess sats.

  :locktime
      - type: u32
      - description: The locktime of the transaction. if not set, it is set to a recent block height.

  :opening_anchor_channel
      - type: boolean
      - description: To signel that it needs emergency reserve for anchors so that we can lowball our commitment tx fees, and min-emergency-msat for reserving some sats for closing anchor channels.

  :min_witness_weight
      - type: u32
      - description: Minimum weight to use for a UTXO's witness. If the actual witness weight is greater than the provided minimum, the actual witness weight will be used."
  [rpc-info satoshi feerate startweight & opt-params]
  (call rpc-info
        "fundpsbt"
        (merge {:satoshi satoshi, :feerate feerate, :startweight startweight}
               (apply hash-map opt-params))))

(defn getinfo
  "Send getinfo request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details."
  [rpc-info]
  (call rpc-info "getinfo"))

(defn getlog
  "Send getlog request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :level
      - type: string
      - description: A string that represents the log level."
  [rpc-info & opt-params]
  (call rpc-info "getlog" (apply hash-map opt-params)))

(defn getroute
  "Send getroute request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: pubkey
      - description: Node pubkey to find the best route for the payment.

  AMOUNT_MSAT
      - type: msat
      - description: Amount to send. It can be a whole number, or a whole number ending in *msat* or *sat*, or a number with three decimal places ending in *sat*, or a number with 1 to 11 decimal places ending in *btc*. The 0 value is special: it ignores any *htlc_minimum_msat* setting on channels, and simply returns a possible route (if any) which is useful for simple probing.

  RISKFACTOR
      - type: u64
      - description: A non-negative floating-point field controls this tradeoff; it is the annual cost of your funds being stuck (as a percentage). For example, if you thought the convenience of keeping your funds liquid (not stuck) was worth 20% per annum interest, *riskfactor* would be 20. If you didn't care about risk, *riskfactor* would be zero.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :cltv
      - type: u32
      - description: Cltv-blocks to spare.

  :fromid
      - type: pubkey
      - description: The node to start the route from.

  :fuzzpercent
      - type: u32
      - description: Used to distort fees to provide some randomization to the route generated, but it was not properly implemented and is ignored.

  :exclude
      - type: array
      - description: A JSON array of short-channel-id/direction (e.g. ['564334x877x1/0', '564195x1292x0/1' ]) or node-id which should be excluded from consideration for routing. Note if the source or destination is excluded, the command result is undefined.

  :maxhops
      - type: u32
      - description: The maximum number of channels to return."
  [rpc-info id amount_msat riskfactor & opt-params]
  (call rpc-info
        "getroute"
        (merge {:id id, :amount_msat amount_msat, :riskfactor riskfactor}
               (apply hash-map opt-params))))

(defn help
  "Send help request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :command
      - type: string
      - description: Command to get information about."
  [rpc-info & opt-params]
  (call rpc-info "help" (apply hash-map opt-params)))

(defn invoice
  "Send invoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  AMOUNT_MSAT
      - type: msat_or_any
      - description: The string `any`, which creates an invoice that can be paid with any amount. Otherwise it is a positive value in millisatoshi precision; it can be a whole number, or a whole number ending in *msat* or *sat*, or a number with three decimal places ending in *sat*, or a number with 1 to 11 decimal places ending in *btc*.

  LABEL
      - type: string
      - description:

      or

      - type: integer
      - description:

  DESCRIPTION
      - type: string
      - description: A short description of purpose of payment, e.g. *1 cup of coffee*. This value is encoded into the BOLT11 invoice and is viewable by any node you send this invoice to (unless *deschashonly* is true as described below). It must be UTF-8, and cannot use *\\u* JSON escape codes.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :expiry
      - type: u64
      - description: The time the invoice is valid for, in seconds. If no value is provided the default of 604800 (1 week) is used.

  :deschashonly
      - type: boolean
      - description: If True, then the bolt11 returned contains a hash of the *description*, rather than the *description* itself: this allows much longer descriptions, but they must be communicated via some other mechanism.

  :cltv
      - type: u32
      - description: If specified, sets the *min_final_cltv_expiry* for the invoice. Otherwise, it's set to the parameter **cltv-final**.

  :preimage
      - type: hex
      - description: A 64-digit hex string to be used as payment preimage for the created invoice. By default, if unspecified, lightningd will generate a secure pseudorandom preimage seeded from an appropriate entropy source on your system. **IMPORTANT**: if you specify the *preimage*, you are responsible, to ensure appropriate care for generating using a secure pseudorandom generator seeded with sufficient entropy, and keeping the preimage secret. This parameter is an advanced feature intended for use with cutting-edge cryptographic protocols and should not be used unless explicitly needed.

  :exposeprivatechannels
      - type: boolean
      - description: If *True* unpublished channels are always considered as a route hint candidate; if *False*, never.

      or

      - type: array
      - description: Array of short channel ids (or a remote alias), only those specific channels will be considered candidates, even if they are public or dead-ends.

      or

      - type: short_channel_id
      - description: If it is a short channel id (e.g. *1x1x3*), only this specific channel will be considered candidate, even if it is public or dead-end.

  :fallbacks
      - type: array
      - description: One or more fallback addresses to include in the invoice (in order from most- preferred to least): note that these arrays are not currently tracked to fulfill the invoice."
  [rpc-info amount_msat label description & opt-params]
  (call rpc-info
        "invoice"
        (merge
          {:amount_msat amount_msat, :label label, :description description}
          (apply hash-map opt-params))))

(defn invoicerequest
  "Send invoicerequest request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  AMOUNT
      - type: msat
      - description: A positive value in millisatoshi precision; it can be a whole number, or a whole number ending in *msat* or *sat*, or a number with three decimal places ending in *sat*, or a number with 1 to 11 decimal places ending in *btc*.

  DESCRIPTION
      - type: string
      - description: A short description of purpose of the payment, e.g. *ATM withdrawl*. This value is encoded into the resulting `invoice_request` and is viewable by anyone you expose it to. It must be UTF-8, and cannot use *\\u* JSON escape codes.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :issuer
      - type: string
      - description: Who is issuing it (i.e. you) if appropriate.

  :label
      - type: string
      - description: An internal-use name for the offer, which can be any UTF-8 string.

  :absolute_expiry
      - type: u64
      - description: The time the offer is valid until, in seconds since the first day of 1970 UTC. If not set, the `invoice_request` remains valid (though it can be deactivated by the issuer of course). This is encoded in the `invoice_request`.

  :single_use
      - type: boolean
      - description: Indicates that the `invoice_request` is only valid once; we may attempt multiple payments, but as soon as one is successful no more invoices are accepted (i.e. only one person can take the money)."
  [rpc-info amount description & opt-params]
  (call rpc-info
        "invoicerequest"
        (merge {:amount amount, :description description}
               (apply hash-map opt-params))))

(defn keysend
  "Send keysend request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  DESTINATION
      - type: pubkey
      - description: The 33 byte, hex-encoded, node ID of the node that the payment should go to.

  AMOUNT_MSAT
      - type: msat
      - description: A whole number, or a whole number with suffix `msat` or `sat`, or a three decimal point number with suffix `sat`, or an 1 to 11 decimal point number suffixed by `btc`.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :retry_for
      - type: u32
      - description: Until *retry_for* seconds passes, the command will keep finding routes and retrying the payment. However, a payment may be delayed for up to `maxdelay` blocks by another node; clients should be prepared for this worst case.

  :maxdelay
      - type: u32
      - description: Number of blocks the payment may be delayed.

  :routehints
      - type: array
      - description:

  :label
      - type: string
      - description: Used to attach a label to payments, and is returned in lightning-listpays(7) and lightning-listsendpays(7).

  :exemptfee
      - type: msat
      - description: Used for tiny payments which would be dominated by the fee leveraged by forwarding nodes. Setting `exemptfee` allows the `maxfeepercent` check to be skipped on fees that are smaller than *exemptfee*.

  :extratlvs
      - type: object
      - description: Dictionary of additional fields to insert into the final tlv. The format is 'fieldnumber': 'hexstring'.

  :maxfeepercent
      - type: number
      - description: Limits the money paid in fees as percentage of the total amount that is to be transferred."
  [rpc-info destination amount_msat & opt-params]
  (call rpc-info
        "keysend"
        (merge {:destination destination, :amount_msat amount_msat}
               (apply hash-map opt-params))))

(defn listchannels
  "Send listchannels request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :short_channel_id
      - type: short_channel_id
      - description: If short_channel_id is a short channel id, then only known channels with a matching short_channel_id are returned. Otherwise, it must be null.

  :source
      - type: pubkey
      - description: If source is a node id, then only channels leading from that node id are returned.

  :destination
      - type: pubkey
      - description: If destination is a node id, then only channels leading to that node id are returned."
  [rpc-info & opt-params]
  (call rpc-info "listchannels" (apply hash-map opt-params)))

(defn listclosedchannels
  "Send listclosedchannels request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :id
      - type: pubkey
      - description: If no *id* is supplied, then channel data on all historical channels are given. Supplying *id* will filter the results to only match channels to that peer. Note that prior to v23.05, old peers were forgotten."
  [rpc-info & opt-params]
  (call rpc-info "listclosedchannels" (apply hash-map opt-params)))

(defn listconfigs
  "Send listconfigs request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :config
      - type: string
      - description: Configuration option name to restrict return."
  [rpc-info & opt-params]
  (call rpc-info "listconfigs" (apply hash-map opt-params)))

(defn listdatastore
  "Send listdatastore request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :key
      - type: array
      - description: All immediate children of the *key* (or root children) are returned.
          Using the first element of the key as the plugin name (e.g. `[ 'summary' ]`) is recommended.
          An array of values to form a hierarchy (though a single value is treated as a one-element array).

      or

      - type: string
      - description:"
  [rpc-info & opt-params]
  (call rpc-info "listdatastore" (apply hash-map opt-params)))

(defn listforwards
  "Send listforwards request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :status
      - type: string
      - description: If specified, then only the forwards with the given status are returned.

  :in_channel
      - type: short_channel_id
      - description: Only the matching forwards on the given inbound channel are returned.

  :out_channel
      - type: short_channel_id
      - description: Only the matching forwards on the given outbount channel are returned.

  :index
      - type: string
      - description: If neither *in_channel* nor *out_channel* is specified, it controls ordering.

  :start
      - type: u64
      - description: If `index` is specified, `start` may be specified to start from that value, which is generally returned from lightning-wait(7).

  :limit
      - type: u32
      - description: If `index` is specified, `limit` can be used to specify the maximum number of entries to return."
  [rpc-info & opt-params]
  (call rpc-info "listforwards" (apply hash-map opt-params)))

(defn listfunds
  "Send listfunds request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :spent
      - type: boolean
      - description: If True, then the *outputs* will include spent outputs in addition to the unspent ones."
  [rpc-info & opt-params]
  (call rpc-info "listfunds" (apply hash-map opt-params)))

(defn listhtlcs
  "Send listhtlcs request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :id
      - type: string
      - description: A short channel id (e.g. 1x2x3) or full 64-byte hex channel id, it will only list htlcs for that channel (which must be known)."
  [rpc-info & opt-params]
  (call rpc-info "listhtlcs" (apply hash-map opt-params)))

(defn listinvoicerequests
  "Send listinvoicerequests request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :invreq_id
      - type: string
      - description: A specific invoice can be queried by providing the `invreq_id`, which is presented by lightning-invoicerequest(7), or can be calculated from a bolt12 invoice.

  :active_only
      - type: boolean
      - description: If it is *True* then only active invoice requests are returned."
  [rpc-info & opt-params]
  (call rpc-info "listinvoicerequests" (apply hash-map opt-params)))

(defn listinvoices
  "Send listinvoices request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :label
      - type: string
      - description:

      or

      - type: integer
      - description:

  :invstring
      - type: string
      - description: The string value to query a specific invoice.

  :payment_hash
      - type: hex
      - description: A payment_hash of the invoice to get the details of a specific invoice.

  :offer_id
      - type: string
      - description: A local `offer_id` the invoice was issued for a specific invoice details.

  :index
      - type: string
      - description: If neither *in_channel* nor *out_channel* is specified, it controls ordering.

  :start
      - type: u64
      - description: If `index` is specified, `start` may be specified to start from that value, which is generally returned from lightning-wait(7).

  :limit
      - type: u32
      - description: If `index` is specified, `limit` can be used to specify the maximum number of entries to return."
  [rpc-info & opt-params]
  (call rpc-info "listinvoices" (apply hash-map opt-params)))

(defn listnodes
  "Send listnodes request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :id
      - type: pubkey
      - description: The public key of the node to list."
  [rpc-info & opt-params]
  (call rpc-info "listnodes" (apply hash-map opt-params)))

(defn listoffers
  "Send listoffers request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :offer_id
      - type: hash
      - description: Offer_id to get details for (if it exists).

  :active_only
      - type: boolean
      - description: If set and is true, only offers with `active` true are returned."
  [rpc-info & opt-params]
  (call rpc-info "listoffers" (apply hash-map opt-params)))

(defn listpays
  "Send listpays request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :bolt11
      - type: string
      - description: Bolt11 string to get the payment details.

  :payment_hash
      - type: hash
      - description: Payment hash to get the payment details.

  :status
      - type: string
      - description: To filter the payment by status."
  [rpc-info & opt-params]
  (call rpc-info "listpays" (apply hash-map opt-params)))

(defn listpeerchannels
  "Send listpeerchannels request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :id
      - type: pubkey
      - description: If supplied, limits the channels to just the peer with the given ID, if it exists."
  [rpc-info & opt-params]
  (call rpc-info "listpeerchannels" (apply hash-map opt-params)))

(defn listpeers
  "Send listpeers request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :id
      - type: pubkey
      - description: If supplied, limits the result to just the peer with the given ID, if it exists.

  :level
      - type: string
      - description: Supplying level will show log entries related to that peer at the given log level."
  [rpc-info & opt-params]
  (call rpc-info "listpeers" (apply hash-map opt-params)))

(defn listsendpays
  "Send listsendpays request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :bolt11
      - type: string
      - description: Bolt11 invoice.

  :payment_hash
      - type: hash
      - description: The hash of the payment_preimage.

  :status
      - type: string
      - description: Whether the invoice has been paid, pending, or failed.

  :index
      - type: string
      - description: If neither bolt11 or payment_hash is specified, `index` controls ordering, by `created` (default) or `updated`.

  :start
      - type: u64
      - description: If `index` is specified, `start` may be specified to start from that value, which is generally returned from lightning-wait(7).

  :limit
      - type: u32
      - description: If `index` is specified, `limit` can be used to specify the maximum number of entries to return."
  [rpc-info & opt-params]
  (call rpc-info "listsendpays" (apply hash-map opt-params)))

(defn listsqlschemas
  "Send listsqlschemas request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :table
      - type: string
      - description:"
  [rpc-info & opt-params]
  (call rpc-info "listsqlschemas" (apply hash-map opt-params)))

(defn listtransactions
  "Send listtransactions request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details."
  [rpc-info]
  (call rpc-info "listtransactions"))

(defn makesecret
  "Send makesecret request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :hex
      - type: hex
      - description: One of `hex` or `string` must be specified: `hex` can be any hex data.

  :string
      - type: string
      - description: One of `hex` or `string` must be specified: `string` is a UTF-8 string interpreted literally."
  [rpc-info & opt-params]
  (call rpc-info "makesecret" (apply hash-map opt-params)))

(defn multifundchannel
  "Send multifundchannel request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  DESTINATIONS
      - type: array
      - description: There must be at least one entry in *destinations*; it cannot be an empty array.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :feerate
      - type: feerate
      - description: Feerate used for the opening transaction, and if *commitment_feerate* is not set, as initial feerate for commitment and HTLC transactions. See NOTES in lightning-feerates(7) for possible values.

  :minconf
      - type: integer
      - description: Minimum number of confirmations that used outputs should have.

  :utxos
      - type: array
      - description:

  :minchannels
      - type: integer
      - description: Re-attempt funding as long as at least this many peers remain (must not be zero). The **multifundchannel** command will only fail if too many peers fail the funding process.

  :commitment_feerate
      - type: feerate
      - description: Initial feerate for commitment and HTLC transactions. See *feerate* for valid values."
  [rpc-info destinations & opt-params]
  (call rpc-info
        "multifundchannel"
        (merge {:destinations destinations} (apply hash-map opt-params))))

(defn multiwithdraw
  "Send multiwithdraw request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  OUTPUTS
      - type: array
      - description: An array containing objects of the form `{address: amount}`. The `amount` may be the string *all*, indicating that all onchain funds be sent to the specified address. Otherwise, it is in satoshi precision; it can be a whole number, a whole number ending in *sat*, a whole number ending in *000msat*, or a number with 1 to 8 decimal places ending in *btc*.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :feerate
      - type: feerate
      - description: Feerate used for the withdrawals. See NOTES in lightning-feerates(7) for possible values.

  :minconf
      - type: u32
      - description: Minimum number of confirmations that used outputs should have.

  :utxos
      - type: array
      - description:"
  [rpc-info outputs & opt-params]
  (call rpc-info
        "multiwithdraw"
        (merge {:outputs outputs} (apply hash-map opt-params))))

(defn newaddr
  "Send newaddr request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :addresstype
      - type: string
      - description: It specifies the type of address wanted; currently *bech32* (e.g. `tb1qu9j4lg5f9rgjyfhvfd905vw46eg39czmktxqgg` on bitcoin testnet or `bc1qwqdg6squsna38e46795at95yu9atm8azzmyvckulcc7kytlcckxswvvzej` on bitcoin mainnet), or *p2tr* taproot addresses. The special value *all* generates all known address types for the same underlying key."
  [rpc-info & opt-params]
  (call rpc-info "newaddr" (apply hash-map opt-params)))

(defn notifications
  "Send notifications request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ENABLE
      - type: boolean
      - description: Whether to enable or disable notifications."
  [rpc-info enable]
  (call rpc-info "notifications" {:enable enable}))

(defn offer
  "Send offer request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  AMOUNT
      - type: msat_or_any
      - description:

      or

      - type: currency
      - description:

  DESCRIPTION
      - type: string
      - description: A short description of purpose of the offer, e.g. *coffee*. This value is encoded into the resulting offer and is viewable by anyone you expose this offer to. It must be UTF-8, and cannot use *\\u* JSON escape codes.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :absolute_expiry
      - type: u64
      - description: Time the offer is valid until,in seconds since the first day of 1970 UTC. If not set, the offer remains valid (though it can be deactivated by the issuer of course). This is encoded in the offer.

  :single_use
      - type: boolean
      - description: Indicates that the offer is only valid once; we may issue multiple invoices, but as soon as one is paid all other invoices will be expired (i.e. only one person can pay this offer).

  :recurrence_limit
      - type: u32
      - description: To indicate the maximum period which exists. eg. `12` means there are 13 periods, from 0 to 12 inclusive. This is encoded in the offer.

  :recurrence_base
      - type: string
      - description:

      or

      - type: integer
      - description:

  :quantity_max
      - type: u64
      - description: Invoice can specify more than one of the items up (and including) this maximum: 0 is a special value meaning `no maximuim`. The *amount* for the invoice will need to be multiplied accordingly. This is encoded in the offer.

  :recurrence_paywindow
      - type: string
      - description: Argument of form `-time+time[%]`. The first time is the number of seconds before the start of a period in which an invoice and payment is valid, the second time is the number of seconds after the start of the period. For example *-604800+86400* means you can fetch an pay the invoice 4 weeks before the given period starts, and up to 1 day afterwards. The optional *%* indicates that the amount of the invoice will be scaled by the time remaining in the period. This is encoded in the offer.

  :label
      - type: string
      - description: An internal-use name for the offer, which can be any UTF-8 string. This is *NOT* encoded in the offer not sent to the issuer.

  :issuer
      - type: string
      - description: Who is issuing this offer (i.e. you) if appropriate.

  :recurrence
      - type: string
      - description: An invoice is expected at regular intervals. The argument is a positive number followed by one of `seconds`, `minutes`, `hours`, `days`, `weeks`, `months` or `years` (variants without the trailing `s` are also permitted). This is encoded in the offer. The semantics of recurrence is fairly predictable, but fully documented in BOLT 12. e.g. `4weeks`."
  [rpc-info amount description & opt-params]
  (call rpc-info
        "offer"
        (merge {:amount amount, :description description}
               (apply hash-map opt-params))))

(defn openchannel_abort
  "Send openchannel_abort request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  CHANNEL_ID
      - type: hash
      - description: Channel id of the channel to be aborted."
  [rpc-info channel_id]
  (call rpc-info "openchannel_abort" {:channel_id channel_id}))

(defn openchannel_bump
  "Send openchannel_bump request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  CHANNEL_ID
      - type: hash
      - description: Id of the channel to RBF.

  AMOUNT
      - type: sat
      - description: Satoshi value that we will contribute to the channel. This value will be _added_ to the provided PSBT in the output which is encumbered by the 2-of-2 script for this channel.

  INITIALPSBT
      - type: string
      - description: The funded, incomplete PSBT that specifies the UTXOs and change output for our channel contribution. It can be updated, see `openchannel_update`; *initialpsbt* must have at least one input. Must have the Non-Witness UTXO (PSBT_IN_NON_WITNESS_UTXO) set for every input. An error (code 309) will be returned if this requirement is not met.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :funding_feerate
      - type: feerate
      - description: Feerate for the funding transaction."
  [rpc-info channel_id amount initialpsbt & opt-params]
  (call rpc-info
        "openchannel_bump"
        (merge
          {:channel_id channel_id, :amount amount, :initialpsbt initialpsbt}
          (apply hash-map opt-params))))

(defn openchannel_init
  "Send openchannel_init request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: pubkey
      - description: Node id of the remote peer.

  AMOUNT
      - type: sat
      - description: Satoshi value that we will contribute to the channel. This value will be _added_ to the provided PSBT in the output which is encumbered by the 2-of-2 script for this channel.

  INITIALPSBT
      - type: string
      - description: Funded, incomplete PSBT that specifies the UTXOs and change output for our channel contribution. It can be updated, see `openchannel_update`; *initialpsbt* must have at least one input. Must have the Non-Witness UTXO (PSBT_IN_NON_WITNESS_UTXO) set for every input. An error (code 309) will be returned if this requirement is not met.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :request_amt
      - type: sat
      - description: An amount of liquidity you'd like to lease from the peer. If peer supports `option_will_fund`, indicates to them to include this much liquidity into the channel. Must also pass in *compact_lease*.

  :channel_type
      - type: array
      - description: Each bit set in this channel_type.

  :announce
      - type: boolean
      - description: Whether or not to announce this channel.

  :close_to
      - type: string
      - description: Bitcoin address to which the channel funds should be sent on close. Only valid if both peers have negotiated `option_upfront_shutdown_script`.

  :commitment_feerate
      - type: feerate
      - description: Feerate for commitment transactions for non-anchor channels: see **fundchannel**. For anchor channels, it is ignored.

  :compact_lease
      - type: hex
      - description: A compact representation of the peer's expected channel lease terms. If the peer's terms don't match this set, we will fail to open the channel.

  :funding_feerate
      - type: feerate
      - description: Feerate for the funding transaction."
  [rpc-info id amount initialpsbt & opt-params]
  (call rpc-info
        "openchannel_init"
        (merge {:id id, :amount amount, :initialpsbt initialpsbt}
               (apply hash-map opt-params))))

(defn openchannel_signed
  "Send openchannel_signed request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  CHANNEL_ID
      - type: hash
      - description: Id of the channel.

  SIGNED_PSBT
      - type: string
      - description: The PSBT returned from `openchannel_update` (where *commitments_secured* was true) with partial signatures or finalized witness stacks included for every input that we contributed to the PSBT."
  [rpc-info channel_id signed_psbt]
  (call rpc-info
        "openchannel_signed"
        {:channel_id channel_id, :signed_psbt signed_psbt}))

(defn openchannel_update
  "Send openchannel_update request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  CHANNEL_ID
      - type: hash
      - description: Id of the channel.

  PSBT
      - type: string
      - description: Updated PSBT to be sent to the peer. May be identical to the PSBT last returned by either `openchannel_init` or `openchannel_update`."
  [rpc-info channel_id psbt]
  (call rpc-info "openchannel_update" {:channel_id channel_id, :psbt psbt}))

(defn parsefeerate
  "Send parsefeerate request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  FEERATE_STR
      - type: string
      - description: The feerate string to parse."
  [rpc-info feerate_str]
  (call rpc-info "parsefeerate" {:feerate_str feerate_str}))

(defn pay
  "Send pay request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  BOLT11
      - type: string
      - description: Bolt11 invoice, if **experimental-offers** is enabled, it can actually be a bolt12 invoice, such as one received from lightningd-fetchinvoice(7). If it does not contain an amount, *amount_msat* is required, otherwise if it is specified it must be *null*.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :description
      - type: string
      - description: It is only required for bolt11 invoices which do not contain a description themselves, but contain a description hash: in this case *description* is required. *description* is then checked against the hash inside the invoice before it will be paid.

  :amount_msat
      - type: msat
      - description: *amount_msat* is in millisatoshi precision; it can be a whole number, or a whole number with suffix *msat* or *sat*, or a three decimal point number with suffix *sat*, or an 1 to 11 decimal point number suffixed by *btc*.

  :exclude
      - type: array
      - description: *exclude* is a JSON array of short-channel-id/direction (e.g. [ '564334x877x1/0', '564195x1292x0/1' ]) or pubkey which should be excluded from consideration for routing.

  :maxfee
      - type: msat
      - description: *maxfee* overrides both *maxfeepercent* and *exemptfee* defaults (and if you specify *maxfee* you cannot specify either of those), and creates an absolute limit on what fee we will pay. This allows you to implement your own heuristics rather than the primitive ones used here.

  :retry_for
      - type: u16
      - description: Until *retry_for* seconds passes, the command will keep finding routes and retrying the payment.

  :maxdelay
      - type: u16
      - description: A payment may be delayed for up to `maxdelay` blocks by another node; clients should be prepared for this worst case.

  :localinvreqid
      - type: hex
      - description: `localinvreqid` is used by offers to link a payment attempt to a local `invoice_request` offer created by lightningd-invoicerequest(7). This  ensures that we only make a single payment for an offer, and that the offer is marked `used` once paid.

  :riskfactor
      - type: number
      - description: The *riskfactor* is described in detail in lightning-getroute(7).

  :label
      - type: string
      - description: It is used to attach a label to payments, and is returned in lightning- listpays(7) and lightning-listsendpays(7).

  :exemptfee
      - type: msat
      - description: This option can be used for tiny payments which would be dominated by the fee leveraged by forwarding nodes. Setting `exemptfee` allows the  `maxfeepercent` check to be skipped on fees that are smaller than `exemptfee`.

  :partial_msat
      - type: msat
      - description: Explicitly state that you are only paying some part of the invoice.  Presumably someone else is paying the rest (otherwise the payment will time out at the recipient).  Note that this is currently not supported for self-payment (please file an issue if you need this)

  :maxfeepercent
      - type: number
      - description: Percentage of the amount that is to be paid."
  [rpc-info bolt11 & opt-params]
  (call rpc-info "pay" (merge {:bolt11 bolt11} (apply hash-map opt-params))))

(defn ping
  "Send ping request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: pubkey
      - description: The pubkey of the node to ping.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :len
      - type: u16
      - description: The length of the ping.

  :pongbytes
      - type: u16
      - description: The length of the reply. A value of 65532 to 65535 means `don't reply`."
  [rpc-info id & opt-params]
  (call rpc-info "ping" (merge {:id id} (apply hash-map opt-params))))

(defn plugin
  "Send plugin request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  SUBCOMMAND
      - type: string
      - description: Determines what action is taken:
        - *subcommand* **start** takes a *path* to an executable as argument and starts it as plugin. *path* may be an absolute path or a path relative to the plugins directory (default *~/.lightning/plugins*). If the plugin is already running and the executable (checksum) has changed, the plugin is killed and restarted except if its an important (or builtin) plugin. If the plugin doesn't complete the 'getmanifest' and 'init' handshakes within 60 seconds, the command will timeout and kill the plugin. Additional *options* may be passed to the plugin, but requires all parameters to be passed as keyword=value pairs using the `-k|--keyword` option which is recommended. For example the following command starts the plugin helloworld.py (present in the plugin directory) with the option greeting set to 'A crazy':
        ```shell.
        lightning-cli -k plugin subcommand=start plugin=helloworld.py greeting='A crazy'.
        ```.
        - *subcommand* **stop** takes a plugin executable *path* or *name* as argument and stops the plugin. If the plugin subscribed to 'shutdown', it may take up to 30 seconds before this command returns. If the plugin is important and dynamic, this will shutdown `lightningd`.
        - *subcommand* **startdir** starts all executables it can find in *directory* (excl. subdirectories) as plugins. Checksum and timeout behavior as in **start** applies.
        - *subcommand* **rescan** starts all plugins in the default plugins directory (default *~/.lightning/plugins*) that are not already running. Checksum and timeout behavior as in **start** applies.
        - *subcommand* **list** lists all running plugins (incl. non-dynamic).

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :plugin
      - type: string
      - description: *path* or *name* of a plugin executable to start or stop.

  :directory
      - type: string
      - description: *path* of a directory containing plugins.

  :options
      - type: array
      - description:"
  [rpc-info subcommand & opt-params]
  (call rpc-info
        "plugin"
        (merge {:subcommand subcommand} (apply hash-map opt-params))))

(defn preapproveinvoice
  "Send preapproveinvoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  BOLT11
      - type: string
      - description: Bolt11 invoice to submit to the HSM to check."
  [rpc-info bolt11]
  (call rpc-info "preapproveinvoice" {:bolt11 bolt11}))

(defn preapprovekeysend
  "Send preapprovekeysend request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  DESTINATION
      - type: pubkey
      - description: It is a 33 byte, hex-encoded, node ID of the node that the payment should go to.

  PAYMENT_HASH
      - type: hex
      - description: It is the unique identifier of a payment.

  AMOUNT_MSAT
      - type: msat
      - description: The amount to send in millisatoshi precision; it can be a whole number, or a whole number with suffix `msat` or `sat`, or a three decimal point number with suffix `sat`, or an 1 to 11 decimal point number suffixed by `btc`."
  [rpc-info destination payment_hash amount_msat]
  (call rpc-info
        "preapprovekeysend"
        {:destination destination,
         :payment_hash payment_hash,
         :amount_msat amount_msat}))

(defn recover
  "Send recover request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  HSMSECRET
      - type: string
      - description: Either a codex32 secret starting with `cl1` as returned by `hsmtool getcodexsecret`, or a raw 64 character hex string."
  [rpc-info hsmsecret]
  (call rpc-info "recover" {:hsmsecret hsmsecret}))

(defn recoverchannel
  "Send recoverchannel request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  SCB
      - type: array
      - description: SCB of the channels in an array."
  [rpc-info scb]
  (call rpc-info "recoverchannel" {:scb scb}))

(defn renepay
  "Send renepay request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  INVSTRING
      - type: string
      - description: Bolt11 invoice which the RPC command attempts to pay. Currently, **renepay** supports bolt11 invoices only.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :amount_msat
      - type: msat
      - description: If the *invstring* does not contain an amount, *amount_msat* is required, otherwise if it is specified it must be *null*. in millisatoshi precision; it can be a whole number, or a whole number with suffix *msat* or *sat*, or a three decimal point number with suffix *sat*, or an 1 to 11 decimal point number suffixed by *btc*.

  :maxfee
      - type: msat
      - description: *maxfee* is a hard bound, in the sense that the command will never attempt a payment when the fees exceed that value.

  :maxdelay
      - type: u32
      - description: Overrides the value of `max-locktime-blocks` for this payment. It serves to limit the locktime of funds in the payment HTLC measured in blocks.

  :retry_for
      - type: u32
      - description: Measured in seconds specifies how much time it is allowed for the command to keep retrying the payment.

  :description
      - type: string
      - description: Only required for bolt11 invoices which do not contain a description themselves, but contain a description hash: in this case *description* is required. *description* is then checked against the hash inside the invoice before it will be paid.

  :label
      - type: string
      - description: Used to attach a label to payments, and is returned in lightning-listpays(7) and lightning-listsendpays(7).

  :dev_use_shadow
      - type: boolean
      - description:"
  [rpc-info invstring & opt-params]
  (call rpc-info
        "renepay"
        (merge {:invstring invstring} (apply hash-map opt-params))))

(defn renepaystatus
  "Send renepaystatus request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :invstring
      - type: string
      - description: If specified, the command will return a list of payment attempts whose invoice matches *invstring*, otherwise all payments with be listed."
  [rpc-info & opt-params]
  (call rpc-info "renepaystatus" (apply hash-map opt-params)))

(defn reserveinputs
  "Send reserveinputs request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  PSBT
      - type: string
      - description: The PSBT to reserve inputs from.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :exclusive
      - type: boolean
      - description: If set to *False*, existing reservations are simply extended, rather than causing failure.

  :reserve
      - type: u32
      - description: The number of blocks to reserve. By default, reservations are for the next 72 blocks (approximately 6 hours)."
  [rpc-info psbt & opt-params]
  (call rpc-info
        "reserveinputs"
        (merge {:psbt psbt} (apply hash-map opt-params))))

(defn sendcustommsg
  "Send sendcustommsg request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  NODE_ID
      - type: pubkey
      - description: The node specified by `node_id` must be a peer, i.e., it must have a direct connection with the node receiving the RPC call, and the connection must be established. For a method to send arbitrary messages over multiple hops, including hops that do not understand the custom message, see the `createonion` and `sendonion` RPC methods. Messages can only be injected if the connection is handled by `openingd` or `channeld`. Messages cannot be injected when the peer is handled by `onchaind` or `closingd` since these do not have a connection, or are synchronous daemons that do not handle spontaneous messages.

  MSG
      - type: hex
      - description: Must be a hex encoded well-formed message, including the 2-byte type prefix, but excluding the length prefix which will be added by the RPC method. The message types may not be one of the internally handled types, since that may cause issues with the internal state tracking of Core Lightning. We do (as of *v23.11*) allow sending of even types, but note that peers (as per the spec) will disconnect on receiving unknown even types."
  [rpc-info node_id msg]
  (call rpc-info "sendcustommsg" {:node_id node_id, :msg msg}))

(defn sendinvoice
  "Send sendinvoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  INVREQ
      - type: string
      - description: The bolt12 invoice_request string beginning with `lnr1`.

  LABEL
      - type: string
      - description: The unique label to use for this invoice.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :amount_msat
      - type: msat
      - description: Required if the *offer* does not specify an amount at all, or specifies it in a different currency. Otherwise you may set it (e.g. to provide a tip).

  :timeout
      - type: u32
      - description: Seconds to wait for the offering node to pay the invoice or return an error. This will also be the timeout on the invoice that is sent.

  :quantity
      - type: u64
      - description: Quantity is is required if the offer specifies quantity_max, otherwise it is not allowed."
  [rpc-info invreq label & opt-params]
  (call rpc-info
        "sendinvoice"
        (merge {:invreq invreq, :label label} (apply hash-map opt-params))))

(defn sendonion
  "Send sendonion request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ONION
      - type: hex
      - description: Hex-encoded 1366 bytes long blob that was returned by either of the tools that can generate onions. It contains the payloads destined for each hop and some metadata. Please refer to [BOLT 04][bolt04] for further details. If is specific to the route that is being used and the *payment_hash* used to construct, and therefore cannot be reused for other payments or to attempt a separate route. The custom onion can generally be created using the `devtools/onion` CLI tool, or the **createonion** RPC command.

  FIRST_HOP
      - type: object
      - description: Instructs Core Lightning which peer to send the onion to. It is a JSON dictionary that corresponds to the first element of the route array returned by *getroute*.

  PAYMENT_HASH
      - type: hash
      - description: Specifies the 32 byte hex-encoded hash to use as a challenge to the HTLC that we are sending. It is specific to the onion and has to match the one the onion was created with.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :description
      - type: string
      - description: If provided, it will be returned in *waitsendpay* and *listsendpays* results.

  :amount_msat
      - type: msat
      - description: Used to annotate the payment, and is returned by *waitsendpay* and *listsendpays*.

  :bolt11
      - type: string
      - description: If provided, it will be returned in *waitsendpay* and *listsendpays* results.

  :localinvreqid
      - type: hash
      - description: `localinvreqid` is used by offers to link a payment attempt to a local `invoice_request` offer created by lightningd-invoicerequest(7).

  :groupid
      - type: u64
      - description: Grouping key to disambiguate multiple attempts to pay an invoice or the same payment_hash.

  :label
      - type: string
      - description: Can be used to provide a human readable reference to retrieve the payment at a later time.

  :partid
      - type: u16
      - description: If provided and non-zero, allows for multiple parallel partial payments with the same *payment_hash*.

  :destination
      - type: pubkey
      - description: If provided, it will be returned in **listpays** result.

  :shared_secrets
      - type: array
      - description: A JSON list of 32 byte hex-encoded secrets that were used when creating the onion. Core Lightning can send a payment with a custom onion without the knowledge of these secrets, however it will not be able to parse an eventual error message since that is encrypted with the shared secrets used in the onion. If *shared_secrets* is provided Core Lightning will decrypt the error, act accordingly, e.g., add a `channel_update` included in the error to its network view, and set the details in *listsendpays* correctly. If it is not provided Core Lightning will store the encrypted onion, and expose it in *listsendpays* allowing the caller to decrypt it externally. If it is not provided the Core Lightning node does not know how long the route is, which channels or nodes are involved, and what an eventual error could have been. It can therefore be used for oblivious payments."
  [rpc-info onion first_hop payment_hash & opt-params]
  (call rpc-info
        "sendonion"
        (merge {:onion onion, :first_hop first_hop, :payment_hash payment_hash}
               (apply hash-map opt-params))))

(defn sendonionmessage
  "Send sendonionmessage request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  FIRST_ID
      - type: pubkey
      - description: The (presumably well-known) public key of the start of the path.

  BLINDING
      - type: pubkey
      - description: Blinding factor for this path.

  HOPS
      - type: array
      - description: 
      "
  [rpc-info first_id blinding hops]
  (call rpc-info
        "sendonionmessage"
        {:first_id first_id, :blinding blinding, :hops hops}))

(defn sendpay
  "Send sendpay request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ROUTE
      - type: array
      - description:

  PAYMENT_HASH
      - type: hash
      - description: The hash of the payment_preimage.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :description
      - type: string
      - description: Description used in the invoice.

  :amount_msat
      - type: msat
      - description: Amount must be provided if *partid* is non-zero, or the payment is to-self, otherwise it must be equal to the final amount to the destination. it can be a whole number, or a whole number ending in *msat* or *sat*, or a number with three decimal places ending in *sat*, or a number with 1 to 11 decimal places ending in *btc*.

  :bolt11
      - type: string
      - description: Bolt11 invoice to pay. If provided, will be returned in *waitsendpay* and *listsendpays* results.

  :localinvreqid
      - type: hex
      - description: Indicates that this payment is being made for a local invoice_request. This ensures that we only send a payment for a single-use invoice_request once.

  :payment_secret
      - type: secret
      - description: Value that the final recipient requires to accept the payment, as defined by the `payment_data` field in BOLT 4 and the `s` field in the BOLT 11 invoice format. It is required if *partid* is non-zero.

  :payment_metadata
      - type: hex
      - description: Placed in the final onion hop TLV.

  :groupid
      - type: u64
      - description: Allows you to attach a number which appears in **listsendpays** so payments can be identified as part of a logical group. The *pay* plugin uses this to identify one attempt at a MPP payment, for example.

  :label
      - type: string
      - description: The label provided when creating the invoice_request.

  :partid
      - type: u64
      - description: Must not be provided for self-payments. If provided and non-zero, allows for multiple parallel partial payments with the same *payment_hash*. The *amount_msat* amount (which must be provided) for each **sendpay** with matching *payment_hash* must be equal, and **sendpay** will fail if there are differing values given."
  [rpc-info route payment_hash & opt-params]
  (call rpc-info
        "sendpay"
        (merge {:route route, :payment_hash payment_hash}
               (apply hash-map opt-params))))

(defn sendpsbt
  "Send sendpsbt request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  PSBT
      - type: string
      - description: The fully signed psbt to be sent.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :reserve
      - type: u32
      - description: Number of blocks to increase reservation of any of our inputs by."
  [rpc-info psbt & opt-params]
  (call rpc-info "sendpsbt" (merge {:psbt psbt} (apply hash-map opt-params))))

(defn setchannel
  "Send setchannel request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  ID
      - type: string
      - description: Should contain a scid (short channel ID), channel id or peerid (pubkey) of the channel to be modified. If *id* is set to `all`, the updates are applied to all channels in states CHANNELD_NORMAL CHANNELD_AWAITING_LOCKIN or DUALOPEND_AWAITING_LOCKIN. If *id* is a peerid, all channels with the +peer in those states are changed.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :feebase
      - type: msat
      - description: Value in millisatoshi that is added as base fee to any routed payment: if omitted, it is unchanged. It can be a whole number, or a whole number ending in *msat* or *sat*, or a number with three decimal places ending in *sat*, or a number with 1 to 11 decimal places ending in *btc*.

  :feeppm
      - type: u32
      - description: Value that is added proportionally per-millionths to any routed payment volume in satoshi. For example, if ppm is 1,000 and 1,000,000 satoshi is being routed through the channel, an proportional fee of 1,000 satoshi is added, resulting in a 0.1% fee.

  :htlcmin
      - type: msat
      - description: Value that limits how small an HTLC we will forward: if omitted, it is unchanged. It can be a whole number, or a whole number ending in *msat* or *sat*, or a number with three decimal places ending in *sat*, or a number with 1 to 11 decimal places ending in *btc*. Note that the peer also enforces a minimum for the channel: setting it below that will simply set it to that value with a warning. Also note that *htlcmin* only applies to forwarded HTLCs: we can still send smaller payments ourselves.

  :htlcmax
      - type: msat
      - description: Value that limits how large an HTLC we will forward: if omitted, it is unchanged. It can be a whole number, or a whole number ending in *msat* or *sat*, or a number with three decimal places ending in *sat*, or a number with 1 to 11 decimal places ending in *btc*. Note that *htlcmax* only applies to forwarded HTLCs: we can still send larger payments ourselves.

  :enforcedelay
      - type: u32
      - description: Number of seconds to delay before enforcing the new fees/htlc max. This gives the network a chance to catch up with the new rates and avoids rejecting HTLCs before they do. This only has an effect if rates are increased (we always allow users to overpay fees) or *htlcmax* is decreased, and only applied to a single rate increase per channel (we don't remember an arbitrary number of prior feerates) and if the node is restarted the updated configuration is enforced immediately.

  :ignorefeelimits
      - type: boolean
      - description: If set to True means to allow the peer to set the commitment transaction fees (or closing transaction fees) to any value they want. This is dangerous: they could set an exorbitant fee (so HTLCs are unenforcable), or a tiny fee (so that commitment transactions cannot be relayed), but avoids channel breakage in case of feerate disagreements. (Note: the global `ignore_fee_limits` setting overrides this)."
  [rpc-info id & opt-params]
  (call rpc-info "setchannel" (merge {:id id} (apply hash-map opt-params))))

(defn setconfig
  "Send setconfig request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  CONFIG
      - type: string
      - description: Name of the config variable which should be set to the value of the variable.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :val
      - type: string
      - description:

      or

      - type: integer
      - description:

      or

      - type: boolean
      - description:"
  [rpc-info config & opt-params]
  (call rpc-info
        "setconfig"
        (merge {:config config} (apply hash-map opt-params))))

(defn setpsbtversion
  "Send setpsbtversion request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  PSBT
      - type: string
      - description: The PSBT to change versions.

  VERSION
      - type: u32
      - description: The version to set."
  [rpc-info psbt version]
  (call rpc-info "setpsbtversion" {:psbt psbt, :version version}))

(defn showrunes
  "Send showrunes request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :rune
      - type: string
      - description: If specified, only details of that rune will be returned."
  [rpc-info & opt-params]
  (call rpc-info "showrunes" (apply hash-map opt-params)))

(defn signinvoice
  "Send signinvoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  INVSTRING
      - type: string
      - description: Bolt11 form, but the final signature is ignored. Minimal sanity checks are done."
  [rpc-info invstring]
  (call rpc-info "signinvoice" {:invstring invstring}))

(defn signmessage
  "Send signmessage request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  MESSAGE
      - type: string
      - description: Less than 65536 characters long message to be signed by the node."
  [rpc-info message]
  (call rpc-info "signmessage" {:message message}))

(defn signpsbt
  "Send signpsbt request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  PSBT
      - type: string
      - description: The psbt to be signed.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :signonly
      - type: array
      - description: Input numbers to sign."
  [rpc-info psbt & opt-params]
  (call rpc-info "signpsbt" (merge {:psbt psbt} (apply hash-map opt-params))))

(defn splice_init
  "Send splice_init request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  CHANNEL_ID
      - type: hash
      - description: The channel id of the channel to be spliced.

  RELATIVE_AMOUNT
      - type: integer
      - description: A positive or negative amount of satoshis to add or subtract from the channel. Note you may need to add a double dash (--) after splice_init if using a negative *relative_amount* so it is not interpretted as a command modifier. For example: ```shell lightning-cli splice_init -- $CHANNEL_ID -100000 ```.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :initialpsbt
      - type: string
      - description: The (optional) base 64 encoded PSBT to begin with. If not specified, one will be generated automatically.

  :feerate_per_kw
      - type: u32
      - description: The miner fee we promise our peer to pay for our side of the splice transaction. It is calculated by `feerate_per_kw` * our_bytes_in_splice_tx / 1000.

  :force_feerate
      - type: boolean
      - description: By default splices will fail if the fee provided looks too high. This is to protect against accidentally setting your fee higher than intended. Set `force_feerate` to true to skip this saftey check."
  [rpc-info channel_id relative_amount & opt-params]
  (call rpc-info
        "splice_init"
        (merge {:channel_id channel_id, :relative_amount relative_amount}
               (apply hash-map opt-params))))

(defn splice_signed
  "Send splice_signed request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  CHANNEL_ID
      - type: hash
      - description: The channel id of the channel to be spliced.

  PSBT
      - type: string
      - description: The final version of the psbt to complete the splice with.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :sign_first
      - type: boolean
      - description: A flag that makes our node offer the final splice signature first (defaults to false). When false, the node will calculate who should sign first based off who is adding inputting the least sats to the splice as per spec."
  [rpc-info channel_id psbt & opt-params]
  (call rpc-info
        "splice_signed"
        (merge {:channel_id channel_id, :psbt psbt}
               (apply hash-map opt-params))))

(defn splice_update
  "Send splice_update request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  CHANNEL_ID
      - type: hash
      - description: The channel id of the channel to be spliced.

  PSBT
      - type: string
      - description: The base 64 encoded PSBT returned from `splice_init` with any changes added by the user."
  [rpc-info channel_id psbt]
  (call rpc-info "splice_update" {:channel_id channel_id, :psbt psbt}))

(defn sql-template
  "Send sql-template request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  QUERY
      - type: string
      - description: The standard sqlite3 query to run.
      Note that queries like \"SELECT *\" are fragile, as columns will change across releases; see lightning-listsqlschemas(7)."
  [rpc-info query]
  (call rpc-info "sql-template" {:query query}))

(defn staticbackup
  "Send staticbackup request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details."
  [rpc-info]
  (call rpc-info "staticbackup"))

(defn stop
  "Send stop request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details."
  [rpc-info]
  (call rpc-info "stop"))

(defn txdiscard
  "Send txdiscard request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  TXID
      - type: txid
      - description: The transaction id, inputs should be unreseverd from."
  [rpc-info txid]
  (call rpc-info "txdiscard" {:txid txid}))

(defn txprepare
  "Send txprepare request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  OUTPUTS
      - type: array
      - description: Format is like: [{destination1: amount1}, {destination2: amount2}] or [{destination: *all*}]. It supports any number of **confirmed** outputs.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :feerate
      - type: feerate
      - description: Used for the transaction as initial feerate.

  :minconf
      - type: u32
      - description: The minimum number of confirmations that used outputs should have.

  :utxos
      - type: array
      - description: To be used to fund the transaction, as an array of `txid:vout`. These must be drawn from the node's available UTXO set."
  [rpc-info outputs & opt-params]
  (call rpc-info
        "txprepare"
        (merge {:outputs outputs} (apply hash-map opt-params))))

(defn txsend
  "Send txsend request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  TXID
      - type: txid
      - description: The transaction id of the transaction created by `txprepare` rpc command."
  [rpc-info txid]
  (call rpc-info "txsend" {:txid txid}))

(defn unreserveinputs
  "Send unreserveinputs request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  PSBT
      - type: string
      - description: Inputs to unreserve are the inputs specified in the passed-in *psbt*.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :reserve
      - type: u32
      - description: The number of blocks to decrease reservation by."
  [rpc-info psbt & opt-params]
  (call rpc-info
        "unreserveinputs"
        (merge {:psbt psbt} (apply hash-map opt-params))))

(defn upgradewallet
  "Send upgradewallet request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :feerate
      - type: feerate
      - description: Feerate for the upgrade transaction.

  :reservedok
      - type: boolean
      - description: Tells the wallet to include all P2SH-wrapped inputs, including reserved ones."
  [rpc-info & opt-params]
  (call rpc-info "upgradewallet" (apply hash-map opt-params)))

(defn utxopsbt
  "Send utxopsbt request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  SATOSHI
      - type: sat_or_all
      - description: The minimum satoshi value of the output(s) needed (or the string `all` meaning use all unreserved inputs). If a value, it can be a whole number, a whole number ending in *sat*, a whole number ending in *000msat*, or a number with 1 to 8 decimal places ending in *btc*.

  FEERATE
      - type: feerate
      - description: Used for the transaction as initial feerate.

  STARTWEIGHT
      - type: u32
      - description: The weight of the transaction before *fundpsbt* has added any inputs.

  UTXOS
      - type: array
      - description: An array of `txid:vout`, each of which must be reserved or available.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :reservedok
      - type: boolean
      - description: If set to true, it will also fail if any of the *utxos* are already reserved.

  :reserve
      - type: u32
      - description: If not zero, then *reserveinputs* is called (successfully, with *exclusive* true) on the returned PSBT for this number of blocks.

  :excess_as_change
      - type: boolean
      - description: Flag to add a change output for the excess sats.

  :locktime
      - type: u32
      - description: If not set, it is set to a recent block height.

  :opening_anchor_channel
      - type: boolean
      - description: To signel that it needs emergency reserve for anchors so that we can lowball our commitment tx fees, and min-emergency-msat for reserving some sats for closing anchor channels.

  :min_witness_weight
      - type: u32
      - description: Minimum weight to use for a UTXO's witness. If the actual witness weight is greater than the provided minimum, the actual witness weight will be used."
  [rpc-info satoshi feerate startweight utxos & opt-params]
  (call rpc-info
        "utxopsbt"
        (merge {:satoshi satoshi,
                :feerate feerate,
                :startweight startweight,
                :utxos utxos}
               (apply hash-map opt-params))))

(defn wait
  "Send wait request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  SUBSYSTEM
      - type: string
      - description: The subsystem to get the next index value from.
        `invoices`: corresponding to `listinvoices` (added in *v23.08*).
        `sendpays`: corresponding to `listsendpays` (added in *v23.11*).
        `forwards`: corresponding to `listforwards` (added in *v23.11*).

  INDEXNAME
      - type: string
      - description: The name of the index to get the next value for.
        `created` is incremented by one for every new object.
        `updated` is incremented by one every time an object is changed.
        `deleted` is incremented by one every time an object is deleted.

  NEXTVALUE
      - type: u64
      - description: The next value of the index."
  [rpc-info subsystem indexname nextvalue]
  (call rpc-info
        "wait"
        {:subsystem subsystem, :indexname indexname, :nextvalue nextvalue}))

(defn waitanyinvoice
  "Send waitanyinvoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :lastpay_index
      - type: u64
      - description: Ignores any invoices paid prior to or including this index. 0 is equivalent to not specifying and negative value is invalid.

  :timeout
      - type: u64
      - description: If specified, wait at most that number of seconds, which must be an integer. If the specified *timeout* is reached, this command will return with an error. You can specify this to 0 so that **waitanyinvoice** will return immediately with an error if no pending invoice is available yet. If unspecified, this command will wait indefinitely."
  [rpc-info & opt-params]
  (call rpc-info "waitanyinvoice" (apply hash-map opt-params)))

(defn waitblockheight
  "Send waitblockheight request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  BLOCKHEIGHT
      - type: u32
      - description: Current blockheight of the blockchain if the value is greater than this number. If it is a present or past block height, then the command returns immediately.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :timeout
      - type: u32
      - description: Only wait up to specified seconds."
  [rpc-info blockheight & opt-params]
  (call rpc-info
        "waitblockheight"
        (merge {:blockheight blockheight} (apply hash-map opt-params))))

(defn waitinvoice
  "Send waitinvoice request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  LABEL
      - type: string
      - description:

      or

      - type: integer
      - description:"
  [rpc-info label]
  (call rpc-info "waitinvoice" {:label label}))

(defn waitsendpay
  "Send waitsendpay request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  PAYMENT_HASH
      - type: hash
      - description: The hash of the *payment_preimage*.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :timeout
      - type: u32
      - description: A timeout in seconds, for this RPC command to return. If the *timeout* is provided and the given amount of time passes without the payment definitely succeeding or definitely failing, this command returns with a 200 error code (payment still in progress). If *timeout* is not provided this call will wait indefinitely. Indicating a *timeout* of 0 effectively makes this call a pollable query of the status of the payment.

  :partid
      - type: u64
      - description: Unique ID within this (multi-part) payment. It must match that of the **sendpay** command.

  :groupid
      - type: u64
      - description: Grouping key to disambiguate multiple attempts to pay the same payment_hash."
  [rpc-info payment_hash & opt-params]
  (call rpc-info
        "waitsendpay"
        (merge {:payment_hash payment_hash} (apply hash-map opt-params))))

(defn withdraw
  "Send withdraw request to lightningd via unix socket.

  The connection is done via :socket-file specified in RPC-INFO.
  :json-id-prefix key of RPC-INFO is used as the first part of
  the JSON-RPC request id.  See tonyaldon.cln.rpc/call for more details.

  DESTINATION
      - type: string
      - description: Any Bitcoin accepted type, including bech32.

  SATOSHI
      - type: sat_or_all
      - description: The amount to be withdrawn from the internal wallet (expressed, as name suggests, in satoshi). The string *all* can be used to specify withdrawal of all available funds (but if we have any anchor channels, this will always leave at least `min-emergency-msat` as change). Otherwise, it is in satoshi precision; it can be a whole number, a whole number ending in *sat*, a whole number ending in *000msat*, or a number with 1 to 8 decimal places ending in *btc*.

  Use OPT-PARAMS to set optional parameters of the request.
  The following keyword argument(s) can be passed with values:

  :feerate
      - type: feerate
      - description: Used for the withdrawal as initial feerate.

  :minconf
      - type: u16
      - description: Minimum number of confirmations that used outputs should have.

  :utxos
      - type: array
      - description: Specifies the utxos to be used to be withdrawn from, as an array of `txid:vout`. These must be drawn from the node's available UTXO set."
  [rpc-info destination satoshi & opt-params]
  (call rpc-info
        "withdraw"
        (merge {:destination destination, :satoshi satoshi}
               (apply hash-map opt-params))))
