;; src/pod/verter/tools.clj
(ns pod.verter.tools
  (:require [bencode.core :refer [read-bencode write-bencode]]
            [cheshire.core :as json]
            [clojure.string :as s]
            [verter.tools :as vt]
            [pod.core :as pod])
  (:gen-class))

(def pod-fns
  {"hash-it"          vt/hash-it
   "measure-it"       vt/measure-it
   "unmeasure-it"     vt/unmeasure-it
   "now"              vt/now
   "ts->date"         vt/ts->date
   "inst->date"       vt/inst->date
   "remove-nil-vals"  vt/remove-nil-vals
   "fmk"              vt/fmk
   "to-multi-queries" vt/to-multi-queries
   "squuid"           vt/squuid})

(def describe-map
  (pod/make-describe "pod.verter.tools" pod-fns))

(defn invoke-fn [var-name args]
  (let [short-name (last (s/split var-name #"/"))]
    (if-let [f (get pod-fns short-name)]
      (try
        (pod/safe-invoke f args)
        (catch Throwable e
          (throw (ex-info (str "Error invoking " var-name ": " (.getMessage e))
                          {:var var-name :args args} e))))
      (throw (ex-info (str "Var not found: " var-name)
                      {:var var-name})))))

(defn -main [& _args]
  (pod/pod-main
    (constantly describe-map)
    invoke-fn))
