(ns com.timezynk.useful.predicates
  "Commonly used predicates."
  (:require [clojure.string :as string])
  (:import [java.time LocalDate]
           [java.time.format DateTimeParseException]))

(defn yyyymmdd? [s]
  (try
    (->> s
         (re-find #"^(\d{4})(\d{2})(\d{2})$")
         (rest)
         (string/join \-)
         (LocalDate/parse))
    s
    (catch ClassCastException _)
    (catch DateTimeParseException _)))

(defn yyyy-mm-dd? [s]
  (try
    (LocalDate/parse s)
    s
    (catch DateTimeParseException _)))

(defn personnummer?
  "Truthy if `x` is a valid Swedish social security number, `nil` otherwise."
  [x]
  (try
    (->> x
         (re-find #"^(\d{8})-\d{4}$")
         (second)
         (yyyymmdd?))
    (catch NullPointerException _)
    (catch ClassCastException _)))
