(ns com.timezynk.useful.string
  "Helpers for turning objects, data structures, etc into strings."
  (:require [clojure.repl :refer [pst]]
            [clojure.string :as string]
            [com.timezynk.useful.core :refer [with-err-str]]))

(defn- client-id [req]
  (let [{:keys [headers]} req]
    (or (get headers "x-tz-client")
        (get headers :x-tz-client)
        (get headers "user-agent")
        (get headers :user-agent))))

(defn from-request
  "String representation of an HTTP request. Aims for maximum aid to debugging."
  [req]
  (let [company-id (get-in req [:user :company-id])
        user-id (get-in req [:user :id])
        client (client-id req)]
    (cond-> (str (-> req :request-method name string/upper-case) " " (:uri req))
      company-id (str ", company: " company-id)
      user-id (str ", user: " user-id)
      client (str ", client: " client))))

(defn from-throwable
  ([t]
   (from-throwable t 32))
  ([t depth]
   (with-err-str (pst t depth))))
