(ns com.timezynk.useful.rest.middleware.logger
  (:require [clojure.tools.logging :as log]
            [com.timezynk.useful.env :as env]
            [com.timezynk.useful.string :as string]))

(defn- get-cause ^Throwable [^Throwable t]
  (when t
    (let [^Throwable cause (.getCause t)]
      (if (or (nil? cause) (= cause t))
        t
        (recur cause)))))

(defn spec
  [req e]
  (when-not env/test?
    (log/warn
      (get-cause e)
      "Spec validation exception 400" (string/from-request req))))

(defn validation
  [req e]
  (when-not env/test?
    (log/warn
      (get-cause e)
      "Validation exception 400" (string/from-request req))))

(defn authorization
  [req e]
  (when-not env/test?
    (let [{:keys [user modules roles session]} req
          {:keys [action object instance]} (:object e)]
      (log/warn (get-cause (:throwable e))
                (cond-> "Exception 401 :"
                  user     (str "\n    user = " user)
                  modules  (str "\n    modules = " modules)
                  roles    (str "\n    roles = " roles)
                  session  (str "\n    scope = " (:scope session))
                  action   (str "\n    action = " action)
                  object   (str "\n    object = " object)
                  instance (str "\n    instance = " instance))))))

(defn slingshot
  [req e]
  (when-not env/test?
    (let [code (get-in e [:object :code] 500)]
      (log/logp
        (if (>= code 500) :error :warn)
        (get-cause (:throwable e))
        "Caught slingshot exception" code
        (string/from-request req)))))

(defn generic
  [req e]
  (when-not env/test?
    (log/error
      (get-cause e)
      "Caught exception 500"
      (string/from-request req))))
