(ns com.timezynk.useful.repl
  (:require [ns-tracker.core :as t]))

(defn- check-namespace-changes [track]
  (try
    (doseq [ns-sym (track)]
      (println (str ">>>>>>>> "  ns-sym " reloaded <<<<<<<<"))
      (require ns-sym :reload))
    (catch Throwable e (.printStackTrace e)))
  (Thread/sleep 500))

(defn track-file-changes
  "Read more: http://cmdrdats.wordpress.com/2012/08/14/auto-reloading-code-with-clojure/"
  [& dirs]
  (let [track (t/ns-tracker dirs)]
    (doto
     (Thread.
      #(while true (check-namespace-changes track)))
      (.setDaemon true)
      (.start))))
