(ns com.timezynk.useful.base64
  (:require [clojure.string :refer [split join]])
  (:import [org.apache.commons.codec.binary Base64]))

(defn decode ^"[B" [^"[B" bytes]
  (Base64/decodeBase64 bytes))

(defn decode-string ^"[B" [^String s]
  (Base64/decodeBase64 s))

(defn encode ^"[B" [^"[B" bytes]
  (Base64/encodeBase64 bytes))

(defn is-base64? [^"[B" bytes]
  (Base64/isBase64 bytes))

(defn base64-str ^String [^"[B" bytes]
  (Base64/encodeBase64String bytes))

(defn base64-str-urlsafe ^String [^"[B" bytes]
  (Base64/encodeBase64URLSafeString bytes))

(defn vec->b64 ^String [v]
  (join "$" (map base64-str v)))

(defn b64->vec [^String s]
  (map decode-string (split s #"\$")))
