(ns com.timezynk.useful.test.token
  (:require [com.timezynk.clj-jwt.core :as jwt]
            [com.timezynk.useful.mongo :as um])
  (:import [org.bson.types ObjectId]))

(defn parse [token]
  (jwt/str->jwt token))

(def user-id
  (comp um/object-id :sub :claims parse))

(def company-id
  (comp um/object-id :x-tz-cid :claims parse))

(def role
  (comp keyword :x-tz-rol :claims parse))

(defn create [company-id role & {:keys [user-id]}]
  (-> {:sub (str (or user-id (ObjectId.)))
       :x-tz-cid (when company-id
                   (str company-id))
       :x-tz-rol (if (um/object-id? role)
                   (str role)
                   (name role))}
      jwt/jwt
      jwt/to-str))
