(ns com.timezynk.useful.rest.middleware.handler
  (:require [cheshire.core :as json]
            [com.timezynk.useful.env :as env]))

(def ^:private ^:const HEADERS
  {"Content-Type" "application/json"
   "Cache-Control" "no-cache"})

(defn spec [e]
  {:status 400
   :headers HEADERS
   :body (json/encode e)})

(defn validation [e]
  {:status 400
   :headers HEADERS
   :body (json/encode (:errors e))})

(defn authorization [e]
  {:status (:code e 401)
   :headers HEADERS
   :body (json/encode {:error "Unauthorized"})})

(defn slingshot [e]
  {:status (:code e 500)
   :headers HEADERS
   :body (json/encode e)})

(defn generic [e]
  {:status 500
   :headers HEADERS
   :body (json/encode (merge {:error (.getMessage e)}
                             (when env/development?
                               {:trace (map str (.getStackTrace e))})))})
