(ns com.timezynk.useful.time)

(defmacro sleep-pad
  "Makes `body` last at least as long as `min-duration` by sleeping after.
   Measures `min-duration` and `min-sleep` in milliseconds."
  [min-duration min-sleep & body]
  `(let [next-ts# (+ (System/currentTimeMillis) ~min-duration)]
     ~@body
     (Thread/sleep (max ~min-sleep
                        (- next-ts# (System/currentTimeMillis))))))
