(ns com.timezynk.useful.channel.message
  (:require [com.timezynk.useful.channel.context :as c]
            [com.timezynk.useful.channel.subscriber.hook :as h]))

(def ^{:dynamic true} *reply-channel* nil)

(defrecord ChannelMessage [prio task enqueued-at]
  Comparable
  (compareTo [this o]
    (compare (:prio this) (:prio o))))

(defn make
  "ChannelMessage constructor which sets :enqueued-at to the current time."
  [prio task]
  (ChannelMessage. prio task (System/currentTimeMillis)))

(defn report
  "Human-readable report on the course of the message through the processing
   pipeline. Intended for logging."
  [message wait-time run-time]
  (when-let [task (:task message)]
    (let [{:keys [context topic cname]} task
          new-id (get-in task [:message 0 :id])
          hook (get-in task [:subscriber :f])]
      (format "[%s] %s in %s -> %s %d/%d"
              (if context
                (c/pretty-print context)
                "N/A")
              (cond-> (name topic)
                new-id (str " " new-id))
              (name cname)
              (h/pretty-print hook)
              wait-time
              run-time))))
