(ns com.timezynk.useful.prometheus.routes
  (:use compojure.core)
  (:import [io.prometheus.client.exporter.common TextFormat]
           [io.prometheus.client CollectorRegistry]
           [java.io StringWriter]))

(defn metrics [req]
  (let [^CollectorRegistry registry CollectorRegistry/defaultRegistry
        ^StringWriter writer (StringWriter.)]
    (TextFormat/write004 writer (.metricFamilySamples registry))
    {:status 200
     :headers {"Content-Type" TextFormat/CONTENT_TYPE_004}
     :body (.toString writer)}))

(defroutes http-routes
  (GET "/metrics" req (metrics req)))
