(ns com.timezynk.useful.bcrypt
  (:import [jBCrypt BCrypt]))

(def ^{:private true
       :doc "Default salting rounds"}
  salt-rounds
  8)

(defn gen-salt [] (BCrypt/gensalt salt-rounds))

(defn hash-password [^String password]
  (if password
    (BCrypt/hashpw password (gen-salt))
    "*"))

(defn compare-password [^String pwhash ^String password]
  (when (= 60 (.length pwhash))
    (BCrypt/checkpw password pwhash)))
