(defproject com.timezynk/useful "1.15.0"
  :description "Useful functions"
  :dependencies [[cheshire "5.10.0"]
                 [com.novemberain/validateur "2.6.0"]
                 [com.timezynk/domain "1.3.1"]
                 [commons-codec "1.10"]
                 [compojure "1.5.1" :scope "provided"]
                 [congomongo "2.1.0" :scope "provided"]
                 [enlive "1.1.6"]
                 [io.prometheus/simpleclient "0.9.0"]
                 [io.prometheus/simpleclient_common "0.9.0"]
                 [io.prometheus/simpleclient_hotspot "0.9.0"]
                 [jbcrypt "0.3"]
                 [joda-time "2.9.2"]
                 [org.clojure/clojure "1.10.1" :scope "provided"]
                 [ch.qos.logback/logback-classic "1.2.9"]
                 [org.clojure/tools.logging "1.2.3"]
                 [potemkin "0.4.5"]
                 [slingshot "0.12.2"]
                 [tortue/spy "2.9.0"]
                 [com.sproutsocial/nsq-j "0.9.4"]]
  :min-lein-version "2.0.0"
  :local-repo ".m2"
  :test2junit-output-dir "test-results"
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :profiles {:kaocha {:dependencies [[lambdaisland/kaocha "1.60.945"]]
                      :jvm-opts ["-Djdk.tls.client.protocols=TLSv1,TLSv1.1,TLSv1.2"]}}

  :jvm-opts ["-Dclojure.tools.logging.factory=clojure.tools.logging.impl/slf4j-factory"]
  :aliases {"kaocha" ["with-profile" "+kaocha" "run" "-m" "kaocha.runner"]}
  :test-paths ["src" "test"]
  :plugins [[lein-difftest "2.0.0"]
            [s3-wagon-private "1.1.2"]
            [lein-cljfmt "0.6.7"]
            [test2junit "1.4.2"]
            [lein-pprint "1.3.2"]])
