(defproject com.timezynk/useful "1.13.0"
  :description "Useful functions"
  :warn-on-reflection true
  :dependencies [[cheshire "5.10.0"]
                 [com.novemberain/validateur "2.6.0"]
                 [commons-codec "1.10"]
                 [compojure "1.5.1" :scope "provided"]
                 [congomongo "2.1.0" :scope "provided"]
                 [enlive "1.1.6"]
                 [io.prometheus/simpleclient "0.9.0"]
                 [io.prometheus/simpleclient_common "0.9.0"]
                 [io.prometheus/simpleclient_hotspot "0.9.0"]
                 [jbcrypt "0.3"]
                 [joda-time "2.9.2"]
                 [org.clojure/clojure "1.10.1" :scope "provided"]
                 [org.clojure/tools.logging "0.3.1"]
                 [potemkin "0.4.5"]
                 [slingshot "0.12.2"]]
  :min-lein-version "2.0.0"
  :local-repo ".m2"
  :test2junit-output-dir "test-results"
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :profiles {:kaocha {:dependencies [[lambdaisland/kaocha "1.60.945"]]
                      :jvm-opts ["-Djdk.tls.client.protocols=TLSv1,TLSv1.1,TLSv1.2"]}}

  :aliases {"kaocha" ["with-profile" "+kaocha" "run" "-m" "kaocha.runner"]}
  :test-paths ["src" "test"]
  :plugins [[lein-difftest "2.0.0"]
            [s3-wagon-private "1.1.2"]
            [lein-cljfmt "0.6.7"]
            [test2junit "1.4.2"]
            [lein-pprint "1.3.2"]])
