(ns com.timezynk.domus.mongo.db
  (:require
   [clojure.tools.logging :as log]
   [somnium.congomongo :as mongo]))

(def ^:const DUPLICATE_KEY_ERROR 11000)
(def ^:private default-mongo-url (atom nil))

(defn mongo-url []
  (or
   (System/getenv "MONGO_URL")
   @default-mongo-url
   (log/error "MONGO_URL environment variable must be set or default set with set-default-mongo-url!")))

(defn make-connection [url]
  (when url
    (log/info "MongoDB servers" url)
    (let [conn (mongo/make-connection url)]
      (mongo/set-write-concern conn :acknowledged)
      conn)))

(defn set-default-mongo-url! [url]
  (reset! default-mongo-url url))

(def db
  (delay (make-connection (mongo-url))))

(defn wrap-mongo [handler db]
  (fn [request]
    (mongo/with-mongo (force db)
      (handler request))))
