(defproject com.timezynk/domus "1.1.0"
  :description  "MongoDB utilities"
  :url          "https://gitlab.com/timezynk/libs-domus"
  :license      {:name "BSD 3 Clause"
                 :url  "https://opensource.org/licenses/BSD-3-Clause"}
  :dependencies [[ch.qos.logback/logback-core "1.5.6" :scope "provided"]
                 [ch.qos.logback/logback-classic "1.5.6" :scope "provided"]
                 [ch.qos.logback.contrib/logback-jackson "0.1.5" :scope "provided"]
                 [ch.qos.logback.contrib/logback-json-classic "0.1.5" :scope "provided"]
                 [com.timezynk/mongo "0.9.14"]
                 [com.timezynk/useful "4.10.0"
                  :scope "provided"
                  :exclusions [com.google.code.gson/gson]]
                 [congomongo "2.6.0"]
                 [joda-time "2.10"]
                 [org.apache.logging.log4j/log4j-to-slf4j "2.17.2"
                  :scope "provided"
                  :exclusions [org.slf4j/slf4j-api]]
                 [org.clojure/clojure "1.11.1" :scope "provided"]
                 [org.clojure/tools.logging "1.2.4" :scope "provided"]]
  :min-lein-version "2.0.0"
  :test2junit-output-dir "test-results"
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :profiles {:dev {:resource-paths ["resources-dev"]
                   :dependencies [[com.eureton/effective "0.9.0"
                                   :exclusions [org.clojure/tools.reader]]
                                  [ns-tracker "0.4.0"]
                                  [org.codehaus.janino/janino "3.1.9"]
                                  [tortue/spy "2.14.0"]]}
             :test {:jvm-opts ["-DCLJ_TEST=1"]}
             :kaocha {:dependencies [[lambdaisland/kaocha "1.71.1119"]]
                      :jvm-opts ["-Djdk.tls.client.protocols=TLSv1,TLSv1.1,TLSv1.2"]}}
  :jvm-opts ["-Dclojure.tools.logging.factory=com.timezynk.useful.logger/factory"]
  :aliases {"kaocha" ["with-profile" "+kaocha" "run" "-m" "kaocha.runner"]}
  :plugins [[lein-difftest "2.0.0"]
            [test2junit "1.4.4"]
            [lein-cljfmt "0.9.0"]
            [lein-pprint "1.3.2"]
            [com.github.clj-kondo/lein-clj-kondo "0.2.1"]])
