(ns com.timezynk.domain.mongo.test.join-logs
  (:require [clojure.test :refer [deftest is testing]]
            [com.timezynk.domain.mongo.core :refer [join-close-entries]]))

(def base-entry
  {:log-info {:user-id 1
              :type :update}
   :archived false
   :field "A"
   :value 1})

(defn entry
  ([tstamp] (entry tstamp {}))
  ([tstamp overrides]
   (merge base-entry
          {:log-info (merge (:log-info base-entry)
                            {:tstamp tstamp})}
          overrides)))

(deftest join-close-entries-joins-close
  (let [entries [(entry 1000)
                 (entry 20000 {:y 1})
                 (entry 80000 {:z 1})]]
    ;; first two are within DISTINCT_LIMIT → joined
    (is (= [(entry 20000 {:y 1})
            (entry 80000 {:z 1})]
           (join-close-entries entries)))))

(deftest join-close-entries-does-not-join-distant
  (let [entries [(entry 1000 {:x 1})
                 (entry 70000 {:x 2})]]
    (is (= entries
           (join-close-entries entries)))))

(deftest join-close-entries-does-not-join-undo
  (let [entries [(entry 1000 {:value 1})
                 (entry 20000 {:value 2})
                 ;; undo back to original state
                 (entry 30000 {:value 1})]]
    ;; second and third must not be joined
    (is (= [(entry 20000 {:value 2})
            (entry 30000 {:value 1})]
           (join-close-entries entries)))))

(deftest join-close-entries-multiple-groups
  (let [entries [(entry 1000)
                 (entry 20000 {:x 1})
                 (entry 150000 {:x 2})
                 (entry 170000 {:x 3})]]
    (is (= [(entry 20000 {:x 1})
            (entry 170000 {:x 3})]
           (join-close-entries entries)))))

(deftest join-close-entries-edge-cases
  (testing "empty input"
    (is (= [] (join-close-entries []))))

  (testing "single entry"
    (let [e (entry 1000)]
      (is (= [e] (join-close-entries [e]))))))

