(ns com.timezynk.domain.mongo.id
  "ID conversions from MongoDB to Clojure and back."
  (:require [clojure.set :as cljset]
            [clojure.walk :as walk]))

(def mongo-dictionary
  {:id :_name
   :vid :_id
   :pid :_pid
   "vid" :_id})

(def clj-dictionary
  {:_name :id
   :_id :vid
   :_pid :pid})

;; TODO this might not be enough for restrictions. What if :id is not a "root" key?
(defn ->mongo [m]
  (-> m
      (dissoc :_id :_name :_pid)
      (cljset/rename-keys mongo-dictionary)))

(defn ->clj [m]
  (-> m
      (dissoc :id :vid :pid)
      (cljset/rename-keys clj-dictionary)))

(defn ->->mongo [m]
  (walk/postwalk-replace mongo-dictionary m))
