(ns com.timezynk.domain.dtc
  (:refer-clojure :exclude [name])
  (:require [clojure.string :as string]))

(def name
  (some-fn :ability-name :name))

(def collection
  (memoize
   (fn [dtc]
     (-> dtc
         (:name)
         (clojure.core/name)
         (string/replace #"\-" (constantly "."))
         (str (get dtc :version ""))
         (keyword)))))
