(ns com.timezynk.domain.workflow
  (:require [slingshot.slingshot :refer [throw+]]
            [com.timezynk.assembly-line :as line :refer [assembly-line]]
            [com.timezynk.cancancan.core :as ability]
            [com.timezynk.useful.mongo :as um]
            [com.timezynk.useful.rest :refer [json-response]]
            [com.timezynk.domain.mongo.core :as m]))

(def log
  (partial assembly-line
           [:validate (fn [_ id]
                        (when-not (um/object-id? id)
                          (throw+ {:code 400
                                   :type :validation-error
                                   :document {:id id}
                                   :message "Invalid ID."})))
            :execute (fn [env _]
                       (let [{:keys [coll restriction]} env]
                         (m/fetch-log coll restriction)))
            :authorize (fn [env docs]
                         (let [{:keys [ability-object]} env]
                           (ability/authorize-all! :read ability-object docs)))
            :render (fn [_ docs]
                      (json-response docs))]
            :environment))
