(ns com.timezynk.domain.route
  (:require [com.timezynk.assembly-line :as line]
            [com.timezynk.domain.context :as context]
            [com.timezynk.domain.dtc :as dtc]
            [com.timezynk.domain.pack :as pack]
            [com.timezynk.domain.station :as station]
            [com.timezynk.domain.workflow :as workflow]
            [compojure.core :refer [GET]]))

(defn log? [dtc & options]
  (let [{:keys [get log]
         :or {get true
              log true}} options]
    (and get
         log
         (not (:skip-logging dtc)))))

(defn log [dtc & options]
  (let [{:keys [log path pre-process-dtc]
         :or {log true}} options
        path (or path (str "/" (name (:name dtc))))]
    (GET (str path "/:id/log") _
      (fn [req]
        (binding [context/*request* req]
          (let [dtc (if pre-process-dtc
                      (pre-process-dtc :log dtc req)
                      dtc)]
            (-> {:coll (dtc/collection dtc)
                 :ability-object (dtc/name dtc)
                 :restriction (pack/pack-query dtc req)}
                (workflow/log)
                (station/insert log)
                (line/prepare (-> req :params :id))
                (deref))))))))
