(defproject com.timezynk/domain "3.1.0"
  :description "Database modeling library for Clojure and MongoDB"
  :url "https://gitlab.com/timezynk/libraries/domain"
  :license {:name "BSD 3 Clause"
            :url "https://opensource.org/licenses/BSD-3-Clause"}
  :scm {:name "git"
        :url  "https://gitlab.com/timezynk/libraries/domain"}
  :dependencies [[ch.qos.logback/logback-core "1.5.6" :scope "provided"]
                 [ch.qos.logback/logback-classic "1.5.6" :scope "provided"]
                 [ch.qos.logback.contrib/logback-jackson "0.1.5" :scope "provided"]
                 [ch.qos.logback.contrib/logback-json-classic "0.1.5" :scope "provided"]
                 [com.novemberain/validateur "1.2.0"]
                 [com.timezynk/assembly-line "1.0.1"]
                 [com.timezynk/bus "1.3.0" :scope "provided"]
                 [com.timezynk/cancancan "0.3.0" :scope "provided"]
                 [com.timezynk/domus "1.0.2" :scope "provided"]
                 [com.timezynk/useful "4.21.0" :scope "provided"]
                 [compojure "1.7.1" :scope "provided" :exclusions [commons-codec]]
                 [congomongo "2.6.0" :scope "provided"]
                 [org.clojure/clojure "1.11.1" :scope "provided"]
                 [org.flatland/useful "0.11.6"
                  :exclusions [org.clojure/tools.macro
                               org.clojure/tools.reader]]
                 [slingshot "0.12.2"]
                 [tortue/spy "2.14.0"]]
  :test-paths ["src" "test"]

  :profiles {:dev {:dependencies [[com.eureton/effective "0.10.0"]
                                  [lambdaisland/kaocha "1.91.1392"]
                                  [ns-tracker "0.4.0"]
                                  [org.codehaus.janino/janino "3.1.12"]
                                  [tortue/spy "2.15.0"]]
                   :resource-paths ["resources-dev"]}
             :test {:jvm-opts ["-DCLJ_TEST=1"]}
             :kaocha {:jvm-opts ["-Djdk.tls.client.protocols=TLSv1,TLSv1.1,TLSv1.2"]}}
  :aliases {"kaocha" ["with-profile" "+kaocha" "run" "-m" "kaocha.runner"]}

  :repl-options {:init-ns com.timezynk.domain.core
                 :init (do
                         (require '[somnium.congomongo :as mongo]
                                  '[com.timezynk.domus.mongo.db :as db]
                                  '[com.timezynk.useful.date :as ud]
                                  '[com.timezynk.useful.env :as ue]
                                  '[com.timezynk.useful.mongo :as um]
                                  '[com.timezynk.useful.repl :as repl]
                                  '[kaocha.repl :as krepl])
                         (use 'clojure.stacktrace)
                         (import '[java.time Duration LocalDate LocalDateTime
                                   Period ZonedDateTime ZoneId ZoneOffset]
                                 '[org.bson.types ObjectId])
                         (repl/track-file-changes "src" "test")
                         (db/set-default-mongo-url! (System/getenv "MONGO_URL"))
                         (mongo/set-connection! @db/db))}

  :plugins [[lein-difftest "2.0.0"]
            [lein-cljfmt "0.9.0"]
            [lein-pprint "1.3.2"]
            [lein-libdir "0.1.1"]
            [test2junit "1.4.4"]
            [com.github.clj-kondo/lein-clj-kondo "0.2.5"]])
