(ns com.timezynk.cancancan.condition.common
  "General-purpose authorization predicate factories.")

(defn same-id
  "True if `fa` applied to the signed-in user and `fb` applied to `instance`
   result in the same ID, false otherwise."
  ([f] (same-id f f))
  ([fa fb]
   (fn [user _ _]
     (fn [_action _object instance]
       (= (str (fa user))
          (str (fb instance)))))))

(def same-company-id
  "True if the signed-in user and `instance` belong to the same company,
   false otherwise."
  (same-id :company-id))

(defn succeed
  "Always `true`."
  [_ _ _]
  (constantly true))

(defn fail
  "Always `false`."
  [_ _ _]
  (constantly false))

(defn module-active
  "True if `module` is active for the signed-in user, false otherwise"
  [module]
  (fn [_ _ modules]
    (fn [_ _ _]
      (contains? @modules module))))
