(ns com.timezynk.cancancan.restriction.common
  "Factories for general-purpose database query restrictors.")

(defn user-id
  "Query restriction for setting `:user-id` to the ID of the signed-in user."
  [user _ _]
  (fn [_ _ _]
    {:user-id (:id user)}))

(defn company-id
  "Query restriction for setting `:company-id` to the ID of the company which
   the signed-in user belongs to."
  [user _ _]
  (fn [_ _ _]
    {:company-id (:company-id user)}))
