(defproject com.timezynk/cancancan "0.1.0"
  :description "Clojure implementation of the cancancan library"
  :url "https://gitlab.com/timezynk/libs-cancancan"
  :license {:name  "BSD 3 Clause"
            :url "https://opensource.org/licenses/BSD-3-Clause"}
  :dependencies [[ch.qos.logback/logback-core "1.2.12"]
                 [ch.qos.logback/logback-classic "1.2.12"]
                 [ch.qos.logback.contrib/logback-jackson "0.1.5"]
                 [ch.qos.logback.contrib/logback-json-classic "0.1.5"]
                 [org.apache.logging.log4j/log4j-to-slf4j "2.17.2" :exclusions [org.slf4j/slf4j-api]]
                 [org.clojure/clojure "1.11.1"]
                 [org.clojure/tools.logging "1.2.4"]
                 [slingshot "0.12.2"]]
  :repl-options {:init-ns com.timezynk.cancancan.core}
  :min-lein-version "2.0.0"
  :test2junit-output-dir "test-results"
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :profiles {:dev {:resource-paths ["resources-dev"]
                   :dependencies [[org.codehaus.janino/janino "3.1.9"]]}
             :test {:jvm-opts ["-DCLJ_TEST=1"]}}
  :aliases {"test" ["with-profile" "+test" "test"]}
  :test-paths ["test"]
  :jvm-opts ["-Dclojure.tools.logging.factory=clojure.tools.logging.impl/slf4j-factory"]
  :plugins [[lein-difftest "2.0.0"]
            [test2junit "1.4.4"]
            [lein-cljfmt "0.9.0"]
            [lein-pprint "1.3.2"]
            [com.github.clj-kondo/lein-clj-kondo "0.2.1"]])
