(defproject com.timezynk/bus "1.3.5"
  :description "General-purpose message bus"
  :url "https://gitlab.com/timezynk/libs-bus"
  :license {:name "BSD 3 Clause"
            :url  "https://opensource.org/licenses/BSD-3-Clause"}
  :dependencies [[ch.qos.logback/logback-core "1.5.6" :scope "provided"]
                 [ch.qos.logback/logback-classic "1.5.6" :scope "provided"]
                 [ch.qos.logback.contrib/logback-jackson "0.1.5" :scope "provided"]
                 [ch.qos.logback.contrib/logback-json-classic "0.1.5" :scope "provided"]
                 [com.timezynk/domus "1.2.0" :scope "provided"]
                 [com.timezynk/mongo "0.13.0"]
                 [com.timezynk/useful "4.22.0" :scope "provided"]
                 [org.apache.logging.log4j/log4j-to-slf4j "2.23.1" :exclusions [org.slf4j/slf4j-api]]
                 [org.clojure/clojure "1.11.1" :scope "provided"]
                 [org.clojure/tools.logging "1.3.0"]]
  :min-lein-version "2.0.0"
  :test2junit-output-dir "test-results"
  :repl-options {:init-ns com.timezynk.bus.core}
  :profiles {:dev {:resource-paths ["resources-dev"]
                   :dependencies [[org.codehaus.janino/janino "3.1.9"]
                                  [tortue/spy "2.14.0"]]}
             :test {:jvm-opts ["-DCLJ_TEST=1"]}}
  :jvm-opts ["-Dclojure.tools.logging.factory=com.timezynk.useful.logger/factory"]
  :plugins [[lein-difftest "2.0.0"]
            [lein-cljfmt "0.9.0"]
            [lein-pprint "1.3.2"]
            [test2junit "1.4.4"]
            [com.github.clj-kondo/lein-clj-kondo "0.2.1"]])
