(ns com.timezynk.bus.subscriber
  (:require [com.timezynk.bus.message :as message]
            [com.timezynk.bus.task :as task]))

(defonce ^:private current-task-id (atom 0))

(defprotocol Subscriber
  (publish [this topic cname message reply-channel context]
           "Publish message to subscriber"))

(defn eligible-for
  "Sequence of subscribers eligible for topic on cname."
  [bus topic cname]
  (let [{:keys [group subscribers]} bus
        on-topic (get-in @subscribers [group topic])]
    (concat (get on-topic nil)
            (when cname
              (get on-topic cname)))))

(defrecord RequestResponse [collection-name f]
  Subscriber
  (publish [this topic cname message reply-channel context]
    (let [task-id (swap! current-task-id inc)]
      (.put reply-channel [:queued task-id])
      (message/make 5 (task/->RequestResponse this
                                              task-id
                                              topic
                                              cname
                                              message
                                              reply-channel
                                              context)))))

(defrecord Broadcast [collection-name f]
  Subscriber
  (publish [this topic cname message _reply-channel context]
    (message/make 10
                  (task/->Broadcast this topic cname message context))))
