(ns andy.util
  (:require
    #?(:clj [clojure.instant :as instant])
    #?(:clj  [clojure.test :refer :all]
       :cljs [cljs.test :refer-macros [deftest is are]])
    #?(:cljs [tiltontec.util.base :refer-macros [trx prog1]]
       :clj  [tiltontec.util.base :refer :all])

    #?(:clj  [tiltontec.cell.base :refer :all :as cty]
       :cljs [tiltontec.cell.base
              :refer-macros [without-c-dependency]
              :refer [c-optimized-away? c-formula? c-value c-optimize cache-value
                      c-unbound? c-input? ia-type? cells-init
                      c-model mdead? c-valid? c-useds c-ref? md-ref?
                      c-state +pulse+ c-pulse-observed
                      *call-stack* *defer-changes* unbound
                      c-rule c-me c-value-state c-callers caller-ensure
                      *causation*
                      c-synaptic? caller-drop
                      c-pulse c-pulse-last-changed c-ephemeral? c-slot
                      *depender*
                      *c-prop-depth* md-slot-owning? c-lazy] :as cty])

    #?(:cljs [tiltontec.cell.integrity
              :refer-macros [with-integrity]]
       :clj  [tiltontec.cell.integrity :refer [with-integrity]])

    #?(:clj  [tiltontec.cell.observer :refer [defobserver fn-obs]]
       :cljs [tiltontec.cell.observer :refer-macros [defobserver fn-obs]])

    #?(:clj  [tiltontec.cell.synapse :refer :all]
       :cljs [tiltontec.cell.synapse :refer-macros [with-synapse]])

    #?(:cljs [tiltontec.cell.core
              :refer-macros [cF cF+ c_F cF_
                             cf-freeze with-c-accumulating with-c-conj with-c-associating with-c-latest]
              :refer [cI c-reset! make-c-formula]]
       :clj  [tiltontec.cell.core :refer :all])

    #?(:clj  [tiltontec.model.core :refer :all :as md]
       :cljs [tiltontec.model.core
              :refer-macros [cFkids the-kids mdv!]
              :refer [md-get md-name fget fm! make md-reset! md-getx]
              :as md])

    #?(:clj [taoensso.nippy :as nippy])

    [#?(:cljs cljs.pprint :clj clojure.pprint) :refer [pprint cl-format]]))

(defn char-string [char len]
  (apply str (repeat len char)))

(defn team-short-name [team-id]
  (case team-id 633 "LIV" 420 "ARG" 410 "FRA" "ARS"))

(defn half-game [n]
  (let [f (java.io.File. (str "/Users/kennethtilton/Downloads/1001553-" n))
        ary (byte-array (.length f))
        is (java.io.FileInputStream. f)]
    (.read is ary)
    (nippy/thaw ary)))

(defn fmt-game-time [gtime]
  (let [gt-tenths (/ gtime 100)
        gt-min (int (/ gt-tenths 600))
        gt-sec-tenths (mod gt-tenths 600)
        gt-sec (int (/ gt-sec-tenths 10))
        gt-sten (int (mod gt-sec-tenths 10))]
    (cl-format nil "~3d:~2,'0d.~d"
      gt-min gt-sec gt-sten)))

(defn wcf-half-game [n]
  (let [f (java.io.File. (str "/Users/kennethtilton/Downloads/games/1137359-" n))
        ary (byte-array (.length f))
        is (java.io.FileInputStream. f)]
    (.read is ary)
    (nippy/thaw ary)))


;;; --- logging watches --------------------------------

(defn std-watch [slot me new prior c]
  (prn :obs!!!!!! slot new))

(defn xstd-watch [slot me new prior c])


;;; --- time utilities --------------------------------

(defn event-millis [e]
  (when-let [et (:collection/event-time e)]
    (let [edate (instant/read-instant-date et)]
      (.getTime edate))))

(defn event-interval-seconds [earlier later]
  (int (Math/ceil (/ (- (event-millis later) (event-millis earlier)) 1000.0))))


;;; --- accessors --------------------------------------

(defn event [me] (mget me :event))
(defn possession [me] (mget me :possession))

(defn latest-event-millis
  "For any model tracking :events, return
  the event-millis of the last."
  [me]
  (event-millis (last (mget me :events))))

(defn dbg-trigger-event-millis
  "For any model tracking :events, return
  the event-millis of the first event, which triggered the model's creation."
  [me]
  (prn :firstevts!!!!!!! (first (mget me :events)))
  (event-millis (first (mget me :events))))

(defn trigger-event-millis
  "For any model tracking :events, return
  the event-millis of the first event, which triggered the model's creation."
  [me]
  (event-millis (first (mget me :events))))

(defn poss-duration [poss]
  (let [lms (latest-event-millis poss)
        trms (trigger-event-millis poss)]
    (cond
      (and lms trms)
      (Math/ceil (/ (- lms trms)
                   1000.0))
      :default 0)))

(defn player-poss-duration [poss]
  (let [lms (latest-event-millis poss)
        trms (trigger-event-millis poss)]
    ;;(prn :player-poss-dur lms trms)
    (cond
      (and lms trms)
      (Math/ceil (/ (- lms trms)
                   1000.0))
      :default 0)))