(ns shadow.graft.modules
  (:require
    [shadow.graft :as graft]
    [shadow.loader :as loader]))

;; this is in its own ns so shadow.graft doesn't depend on shadow.loader
;; since that adds 8kb we might not need when not actually using modules

(defn init [encoder]
  (let [required-modules
        (into-array
          (into #{}
            (for [script (array-seq (js/document.querySelectorAll "script[type=\"shadow/graft\"]"))
                  :let [mod (.getAttribute script data-module)]
                  :when (seq mod)]
              mod)))]

    (-> (loader/load-multiple required-modules)
        (.then #(graft/init encoder)))))
