(ns teachscape.etlio.server.http
  (:refer-clojure :exclude [name])
  (:require [compojure.core :refer [defroutes context GET DELETE]]
            [compojure.handler :as ch]
            [compojure.route   :as rt]
            [ring.adapter.jetty :refer [run-jetty]]
            [ring.middleware.json :as mw]
            [metrics.ring.expose  :as mr]
            [ring.util.response :refer [response]]
            [taoensso.timbre                   :as log]
            [teachscape.etlio.server.fs        :as sfs]
            [teachscape.etlio.server.scheduler :as ss]))

;;
;; Implementation
;;

(defn handle-ping
  []
  (response {:pong "OK"}))

(defn handle-scheduler-tasks-delete
  [name]
  (log/info (format "API request: remove task %s from the scheduler" name))
  (when (ss/remove-by-name! name)
    (response {:deleted name})))

(defroutes api-routes
  (GET    "/ping"                []   (handle-ping))
  (context "/scheduler" []
           (DELETE "/tasks/:id" [id] (handle-scheduler-tasks-delete id)))
  
  (rt/not-found "Not Found"))

(def app (-> (ch/api api-routes)
             mr/expose-metrics-as-json
             mw/wrap-json-response))

;;
;; API
;;

(defn start-server
  "Starts HTTP server (embedded Jetty) on the given port"
  [port]
  (run-jetty app {:port port :join? false :daemon? false}))

