(ns teachscape.etlio.server.fs
  (:refer-clojure :excludes [name])
  (:import java.nio.file.Path))

;;
;; Implementation
;;

(def ^Path tasks-dir-path)

;;
;; API
;;

(defn use-dir!
  [^Path path]
  (alter-var-root (var tasks-dir-path) (constantly path)))

(defn ^Path path-for-task
  [^String name]
  (.resolve tasks-dir-path (if (.endsWith name ".clj")
                             name
                             (str name ".clj"))))

(defn ^String path->str
  [^Path path]
  (.. path toFile getAbsolutePath))
