(ns teachscape.etlio.dsl
  "Contains macros and functions that can be used in the task
   definition DSL.

   teachscape.etlio.api/read-task evalutes task definitions in
   this namespace.")

;;
;; Implementation
;;

(defn empty-task
  ([task-name]
     {:name task-name})
  ([task-name ^String description]
     {:name        task-name
      :description description}))


;;
;; API
;;

(defn context
  [task-m m]
  (assoc task-m :context m))

(defn schedule
  [m sched]
  (assoc m :schedule sched))

(defn setup
  [m & fns]
  (assoc m :setup fns))

(defn inputs
  [m & fns]
  (assoc m :inputs fns))

(defn transforms
  [m & fns]
  (assoc m :transforms fns))

(defn outputs
  [m & fns]
  (assoc m :outputs fns))

(defmacro deftask
  "Defines an ETL task.

   Every task has a name, multiple of inputs,
   multiple transformation steps and multiple outputs"
  [task-name description & body]
  `(let [task# (-> (empty-task ~(name task-name) ~description)
                   ~@body)]
     task#))
