/*
 * Decompiled with CFR 0.152.
 */
package org.giltene;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.misc.Unsafe;

public class PauselessHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 318739534392781639L;
    transient int elementCount;
    transient Entry<K, V>[] elementData;
    transient Entry<K, V>[] resizingIntoElementData;
    transient int modCount = 0;
    private static final int DEFAULT_SIZE = 16;
    final float loadFactor;
    int threshold;
    transient boolean pendingResize = false;
    transient boolean needToKickOffAnotherBackgroundResize = false;
    transient boolean backgroundResizeComplete = false;
    transient boolean indicatedObservedResizingIntoTable = false;
    volatile transient boolean observedResizingIntoTable = false;
    transient AtomicBoolean volatileUpdateIndicator = new AtomicBoolean(false);
    final transient Object rehashMonitor = new Object();
    transient Entry<K, V>[] cachedExpectedHeadsArray = null;
    transient Set<K> keySet;
    transient Collection<V> valuesCollection;
    static final long NSEC_TIME_TO_SPINWAIT_IN_RESIZER_BEFORE_GIVING_UP = 100000000L;
    static final int DEFAULT_NUMBER_OF_BACKGROUND_RESIZER_EXECUTOR_THREADS = 2;
    static final int SMALLEST_CAPACITY_TO_KICK_OFF_BACKGROUND_RESIZE_FOR = 256;
    static final ScheduledExecutorService backgroundResizers = Executors.newScheduledThreadPool(2);

    Entry<K, V>[] newElementArray(int s) {
        return new Entry[s];
    }

    public PauselessHashMap() {
        this(16);
    }

    public PauselessHashMap(int capacity) {
        this(capacity, 0.75f);
    }

    private static final int calculateCapacity(int x) {
        if (x >= 0x40000000) {
            return 0x40000000;
        }
        if (x == 0) {
            return 16;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public PauselessHashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        capacity = PauselessHashMap.calculateCapacity(capacity);
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity);
        this.loadFactor = loadFactor;
        this.computeThreshold();
    }

    public PauselessHashMap(Map<? extends K, ? extends V> map) {
        this(PauselessHashMap.calculateCapacity(map.size()));
        super.putAllImpl(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (!this.pendingResize) {
            this.clearImpl();
        } else {
            Object object = this.rehashMonitor;
            synchronized (object) {
                this.forceFinishResizing();
                this.clearImpl();
            }
        }
    }

    private void clearImpl() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            for (int i = 0; i < this.elementData.length; ++i) {
                this.elementData[i] = null;
            }
            ++this.modCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        if (!this.pendingResize) {
            return this.cloneImpl();
        }
        Object object = this.rehashMonitor;
        synchronized (object) {
            this.forceFinishResizing();
            return this.cloneImpl();
        }
    }

    private Object cloneImpl() {
        try {
            PauselessHashMap map = (PauselessHashMap)super.clone();
            map.keySet = null;
            map.valuesCollection = null;
            map.elementCount = 0;
            map.elementData = this.newElementArray(this.elementData.length);
            map.putAll(this);
            return map;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void computeThreshold() {
        Entry<K, V>[] array = this.resizingIntoElementData != null ? this.resizingIntoElementData : this.elementData;
        this.threshold = (int)((float)array.length * this.loadFactor);
    }

    @Override
    public boolean containsKey(Object key) {
        Entry<K, V> m = this.getEntry(key);
        return m != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<K, V> entry;
        int i;
        if (value != null) {
            for (i = 0; i < this.elementData.length; ++i) {
                entry = this.elementData[i];
                while (entry != null) {
                    if (PauselessHashMap.areEqualValues(value, entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            for (i = 0; i < this.elementData.length; ++i) {
                entry = this.elementData[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        if (this.resizingIntoElementData == null) {
            return false;
        }
        if (value != null) {
            for (i = 0; i < this.resizingIntoElementData.length; ++i) {
                entry = this.resizingIntoElementData[i];
                while (entry != null) {
                    if (PauselessHashMap.areEqualValues(value, entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            for (i = 0; i < this.resizingIntoElementData.length; ++i) {
                entry = this.resizingIntoElementData[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new HashMapEntrySet(this);
    }

    @Override
    public V get(Object key) {
        Entry<K, V> m = this.getEntry(key);
        if (m != null) {
            return (V)m.value;
        }
        return null;
    }

    final Entry<K, V> getEntry(Object key) {
        Entry<K, V> m;
        if (key == null) {
            m = this.findNullKeyEntry();
        } else {
            int hash = PauselessHashMap.computeHashCode(key);
            int index = hash & this.elementData.length - 1;
            m = this.findNonNullKeyEntry(key, index, hash);
        }
        return m;
    }

    final Entry<K, V> findNonNullKeyEntry(Object key, int index, int keyHash) {
        Entry<K, V> m = this.findNonNullKeyEntryInElementData(key, index, keyHash);
        if (m != null) {
            return m;
        }
        if (this.resizingIntoElementData == null) {
            return null;
        }
        int indexInResizedArray = keyHash & this.resizingIntoElementData.length - 1;
        return this.findNonNullKeyEntryInResizingIntoElementData(key, indexInResizedArray, keyHash);
    }

    final Entry<K, V> findNonNullKeyEntryInElementData(Object key, int index, int keyHash) {
        return this.findNonNullKeyEntryInChain(key, this.elementData[index], keyHash);
    }

    final Entry<K, V> findNonNullKeyEntryInResizingIntoElementData(Object key, int index, int keyHash) {
        return this.findNonNullKeyEntryInChain(key, this.resizingIntoElementData[index], keyHash);
    }

    final Entry<K, V> findNonNullKeyEntryInChain(Object key, Entry<K, V> chainHead, int keyHash) {
        while (!(chainHead == null || chainHead.isValid() && chainHead.origKeyHash == keyHash && PauselessHashMap.areEqualKeys(key, chainHead.key))) {
            chainHead = chainHead.next;
        }
        return chainHead;
    }

    final Entry<K, V> findNullKeyEntry() {
        Entry<K, V> m = this.findNullKeyEntryInElementData();
        if (m != null) {
            return m;
        }
        if (this.resizingIntoElementData == null) {
            return null;
        }
        return this.findNullKeyEntryInResizingIntoElementData();
    }

    final Entry<K, V> findNullKeyEntryInElementData() {
        return this.findNullKeyEntryInChain(this.elementData[0]);
    }

    final Entry<K, V> findNullKeyEntryInResizingIntoElementData() {
        return this.findNullKeyEntryInChain(this.resizingIntoElementData[0]);
    }

    final Entry<K, V> findNullKeyEntryInChain(Entry<K, V> chainHead) {
        while (!(chainHead == null || chainHead.isValid() && chainHead.key == null)) {
            chainHead = chainHead.next;
        }
        return chainHead;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return PauselessHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return PauselessHashMap.this.size();
                }

                @Override
                public void clear() {
                    PauselessHashMap.this.clear();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean remove(Object key) {
                    Entry entry;
                    if (!PauselessHashMap.this.pendingResize) {
                        entry = PauselessHashMap.this.removeEntry(key);
                    } else {
                        Object object = PauselessHashMap.this.rehashMonitor;
                        synchronized (object) {
                            PauselessHashMap.this.forceFinishResizing();
                            entry = PauselessHashMap.this.removeEntry(key);
                        }
                    }
                    return entry != null;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator(PauselessHashMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        return this.putImpl(key, value);
    }

    private V putImpl(K key, V value) {
        Entry<K, V> resizingIntoEntry;
        Entry<K, V> entry;
        int index = 0;
        int hash = 0;
        Object result = null;
        if (key == null) {
            entry = this.findNullKeyEntryInElementData();
        } else {
            hash = PauselessHashMap.computeHashCode(key);
            index = hash & this.elementData.length - 1;
            entry = this.findNonNullKeyEntryInElementData(key, index, hash);
        }
        if (this.resizingIntoElementData == null) {
            if (entry == null) {
                entry = this.createHashedEntry(key, index, hash);
                entry.value = value;
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
                return null;
            }
            result = entry.value;
            entry.value = value;
            return (V)result;
        }
        if (!this.indicatedObservedResizingIntoTable) {
            this.indicatedObservedResizingIntoTable = true;
            this.observedResizingIntoTable = true;
        }
        if (entry != null) {
            result = entry.value;
            entry.value = value;
            key = entry.key;
            this.volatileUpdateIndicator.lazySet(true);
        }
        if (key == null) {
            resizingIntoEntry = this.findNullKeyEntryInResizingIntoElementData();
        } else {
            index = hash & this.resizingIntoElementData.length - 1;
            resizingIntoEntry = this.findNonNullKeyEntryInResizingIntoElementData(key, index, hash);
        }
        if (resizingIntoEntry == null) {
            resizingIntoEntry = this.createHashedEntry(key, index, hash);
            if (entry == null) {
                ++this.modCount;
                ++this.elementCount;
            }
        } else if (result == null) {
            result = resizingIntoEntry.value;
        }
        resizingIntoEntry.value = value;
        if (this.backgroundResizeComplete) {
            this.finishResizing();
        }
        if (this.needToKickOffAnotherBackgroundResize) {
            this.rehash();
        }
        return (V)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceFinishResizing() {
        while (this.pendingResize) {
            try {
                Object object = this.rehashMonitor;
                synchronized (object) {
                    if (this.backgroundResizeComplete) {
                        this.finishResizing();
                    } else {
                        if (this.resizingIntoElementData != null) {
                            this.observedResizingIntoTable = true;
                        }
                        if (this.needToKickOffAnotherBackgroundResize) {
                            this.rehash();
                        }
                        this.rehashMonitor.wait(1L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    void finishResizing() {
        this.elementData = this.resizingIntoElementData;
        this.resizingIntoElementData = null;
        this.observedResizingIntoTable = false;
        this.indicatedObservedResizingIntoTable = false;
        this.backgroundResizeComplete = false;
        this.pendingResize = false;
        this.volatileUpdateIndicator.lazySet(false);
        if (this.elementCount > this.threshold) {
            this.rehash();
        }
    }

    Entry<K, V> createEntry(K key, int index, V value) {
        Entry<K, V> entry = new Entry<K, V>(key, value);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    Entry<K, V> createHashedEntry(K key, int index, int hash) {
        Entry<K, int> entry = new Entry<K, int>(key, hash);
        if (this.resizingIntoElementData != null) {
            Entry<K, V> currentHead;
            int indexInResizedArray = hash & this.resizingIntoElementData.length - 1;
            do {
                currentHead = this.resizingIntoElementData[indexInResizedArray];
                entry.next = currentHead;
            } while (!EntryArrayHelper.compareAndSet(this.resizingIntoElementData, indexInResizedArray, currentHead, entry));
            return entry;
        }
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (!map.isEmpty()) {
            this.putAllImpl(map);
        }
    }

    private void putAllImpl(Map<? extends K, ? extends V> map) {
        int capacity;
        if (this.resizingIntoElementData != null && this.backgroundResizeComplete) {
            this.forceFinishResizing();
        }
        if ((capacity = this.elementCount + map.size()) > this.threshold) {
            this.doResize(capacity);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putImpl(entry.getKey(), entry.getValue());
        }
    }

    void rehash(int capacity) {
        if (this.needToKickOffAnotherBackgroundResize || !this.pendingResize) {
            this.kickoffBackgroundResize(capacity);
        }
    }

    void rehash() {
        if (this.needToKickOffAnotherBackgroundResize || !this.pendingResize) {
            this.kickoffBackgroundResize(this.elementData.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (!this.pendingResize) {
            return this.removeImpl(key);
        }
        Object object = this.rehashMonitor;
        synchronized (object) {
            this.forceFinishResizing();
            return this.removeImpl(key);
        }
    }

    private V removeImpl(Object key) {
        Entry<K, V> entry = this.removeEntry(key);
        if (entry != null) {
            return (V)entry.value;
        }
        return null;
    }

    final void removeEntry(Entry<K, V> entry) {
        int index = entry.origKeyHash & this.elementData.length - 1;
        Entry<K, V> m = this.elementData[index];
        if (m == entry) {
            this.elementData[index] = entry.next;
        } else {
            while (m != null && m.next != entry) {
                m = m.next;
            }
            if (m != null) {
                m.next = entry.next;
            }
        }
        ++this.modCount;
        --this.elementCount;
    }

    final Entry<K, V> removeEntry(Object key) {
        Entry<K, V> entryInElementData;
        int index = 0;
        Entry<K, V> last = null;
        if (key != null) {
            int hash = PauselessHashMap.computeHashCode(key);
            index = hash & this.elementData.length - 1;
            entryInElementData = this.elementData[index];
            while (!(entryInElementData == null || entryInElementData.origKeyHash == hash && PauselessHashMap.areEqualKeys(key, entryInElementData.key))) {
                last = entryInElementData;
                entryInElementData = entryInElementData.next;
            }
        } else {
            entryInElementData = this.elementData[0];
            while (entryInElementData != null && entryInElementData.key != null) {
                last = entryInElementData;
                entryInElementData = entryInElementData.next;
            }
        }
        if (entryInElementData == null) {
            return null;
        }
        if (last == null) {
            this.elementData[index] = entryInElementData.next;
        } else {
            last.next = entryInElementData.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entryInElementData;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return PauselessHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return PauselessHashMap.this.size();
                }

                @Override
                public void clear() {
                    PauselessHashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator(PauselessHashMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        Object object = this.rehashMonitor;
        synchronized (object) {
            this.forceFinishResizing();
            stream.defaultWriteObject();
            stream.writeInt(this.elementData.length);
            stream.writeInt(this.elementCount);
            for (Entry entry : this.entrySet()) {
                stream.writeObject(entry.key);
                stream.writeObject(entry.value);
                Entry entry2 = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int length = stream.readInt();
        this.elementData = this.newElementArray(length);
        int i = this.elementCount = stream.readInt();
        while (--i >= 0) {
            Object key = stream.readObject();
            int index = null == key ? 0 : PauselessHashMap.computeHashCode(key) & length - 1;
            this.createEntry(key, index, stream.readObject());
        }
    }

    static int computeHashCode(Object key) {
        return key.hashCode();
    }

    static boolean areEqualKeys(Object key1, Object key2) {
        return key1 == key2 || key1.equals(key2);
    }

    static boolean areEqualValues(Object value1, Object value2) {
        return value1 == value2 || value1.equals(value2);
    }

    final void kickoffBackgroundResize(int capacity) {
        if (capacity < 256) {
            this.doResize(capacity);
            return;
        }
        this.pendingResize = true;
        this.needToKickOffAnotherBackgroundResize = false;
        backgroundResizers.execute(new Resizer(this, capacity, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doResize(int capacity) {
        Resizer resizer = new Resizer(this, capacity, true);
        this.pendingResize = true;
        Object object = this.rehashMonitor;
        synchronized (object) {
            resizer.run();
            this.finishResizing();
        }
    }

    class Resizer
    implements Runnable {
        final PauselessHashMap<K, V> associatedMap;
        final int capacity;
        final boolean isSynchronous;
        long startTimeNsec = 0L;

        Resizer(PauselessHashMap<K, V> hm, int capacity, boolean isSynchronous) {
            this.associatedMap = hm;
            this.capacity = capacity;
            this.isSynchronous = isSynchronous;
        }

        void insertUniqueEquivalentAtHeadOfBucket(Entry<K, V> existingEntry, int bucketIndex) {
            Entry targetBucketHead;
            Object key = existingEntry.key;
            int keyHash = existingEntry.origKeyHash;
            Entry<Object, Object> newEntry = new Entry<Object, Object>(key, existingEntry.value);
            newEntry.setInvalid();
            boolean keyFound = false;
            do {
                targetBucketHead = PauselessHashMap.this.resizingIntoElementData[bucketIndex];
                newEntry.next = targetBucketHead;
                if (this.isSynchronous || PauselessHashMap.this.cachedExpectedHeadsArray[bucketIndex] == targetBucketHead) continue;
                if (key == null) {
                    keyFound = PauselessHashMap.this.findNullKeyEntryInChain(targetBucketHead) != null;
                } else {
                    boolean bl = keyFound = PauselessHashMap.this.findNonNullKeyEntryInChain(key, targetBucketHead, keyHash) != null;
                }
                if (!keyFound) continue;
                return;
            } while (!EntryArrayHelper.compareAndSet(PauselessHashMap.this.resizingIntoElementData, bucketIndex, targetBucketHead, newEntry));
            if (!this.isSynchronous) {
                PauselessHashMap.this.cachedExpectedHeadsArray[bucketIndex] = newEntry;
            }
            newEntry.value = existingEntry.value;
            PauselessHashMap.this.volatileUpdateIndicator.lazySet(true);
            newEntry.setValid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.startTimeNsec == 0L) {
                this.startTimeNsec = System.nanoTime();
            }
            Object object = PauselessHashMap.this.rehashMonitor;
            synchronized (object) {
                int needed_capacity = Math.max(this.capacity, (int)((float)PauselessHashMap.this.elementCount / PauselessHashMap.this.loadFactor));
                needed_capacity = PauselessHashMap.calculateCapacity(this.capacity == 0 ? 1 : needed_capacity << 1);
                if (PauselessHashMap.this.resizingIntoElementData == null) {
                    PauselessHashMap.this.resizingIntoElementData = PauselessHashMap.this.newElementArray(needed_capacity);
                    if (!this.isSynchronous) {
                        PauselessHashMap.this.cachedExpectedHeadsArray = PauselessHashMap.this.newElementArray(needed_capacity);
                    }
                }
                int length = PauselessHashMap.this.resizingIntoElementData.length;
                boolean boolval = PauselessHashMap.this.volatileUpdateIndicator.get();
                PauselessHashMap.this.volatileUpdateIndicator.set(!boolval);
                if (this.isSynchronous) {
                    PauselessHashMap.this.observedResizingIntoTable = true;
                }
                if (!PauselessHashMap.this.observedResizingIntoTable) {
                    if (System.nanoTime() - this.startTimeNsec > 100000000L) {
                        PauselessHashMap.this.needToKickOffAnotherBackgroundResize = true;
                        return;
                    }
                    backgroundResizers.schedule(this, 1L, TimeUnit.MILLISECONDS);
                    return;
                }
                for (int i = 0; i < PauselessHashMap.this.elementData.length; ++i) {
                    Entry existingEntry = PauselessHashMap.this.elementData[i];
                    while (existingEntry != null) {
                        int bucketIndex = existingEntry.origKeyHash & length - 1;
                        this.insertUniqueEquivalentAtHeadOfBucket(existingEntry, bucketIndex);
                        existingEntry = existingEntry.next;
                    }
                    PauselessHashMap.this.elementData[i] = null;
                }
                PauselessHashMap.this.volatileUpdateIndicator.lazySet(!boolval);
                PauselessHashMap.this.cachedExpectedHeadsArray = null;
                PauselessHashMap.this.computeThreshold();
                PauselessHashMap.this.backgroundResizeComplete = true;
                PauselessHashMap.this.rehashMonitor.notifyAll();
            }
        }
    }

    static class EntryArrayHelper {
        static final Unsafe UNSAFE = EntryArrayHelper.getUnsafe();
        static final int objectIndexScale = EntryArrayHelper.calculateShiftForScale(UNSAFE.arrayIndexScale(Object[].class));
        static final int arrayBaseOffset = UNSAFE.arrayBaseOffset(Object[].class);

        EntryArrayHelper() {
        }

        public static int calculateShiftForScale(int scale) {
            if (4 == scale) {
                return 2;
            }
            if (8 == scale) {
                return 3;
            }
            throw new IllegalArgumentException("Unknown pointer size");
        }

        public static Unsafe getUnsafe() {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return (Unsafe)f.get(null);
            }
            catch (Exception exception) {
                return null;
            }
        }

        static boolean compareAndSet(Entry[] array, int index, Entry expected, Entry entry) {
            long offset = arrayBaseOffset + (index << objectIndexScale);
            return UNSAFE.compareAndSwapObject(array, offset, expected, entry);
        }
    }

    static class InternalMapEntry<K, V>
    implements Map.Entry<K, V>,
    Cloneable {
        K key;
        V value;

        InternalMapEntry(K theKey) {
            this.key = theKey;
        }

        InternalMapEntry(K theKey, V theValue) {
            this.key = theKey;
            this.value = theValue;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
            }
            return false;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public V setValue(V object) {
            V result = this.value;
            this.value = object;
            return result;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    static class HashMapEntrySet<KT, VT>
    extends AbstractSet<Map.Entry<KT, VT>> {
        private final PauselessHashMap<KT, VT> associatedMap;

        public HashMapEntrySet(PauselessHashMap<KT, VT> hm) {
            this.associatedMap = hm;
        }

        PauselessHashMap<KT, VT> hashMap() {
            return this.associatedMap;
        }

        @Override
        public int size() {
            return this.associatedMap.elementCount;
        }

        @Override
        public void clear() {
            this.associatedMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            if (!this.associatedMap.pendingResize) {
                return this.removeImpl(object);
            }
            Object object2 = this.associatedMap.rehashMonitor;
            synchronized (object2) {
                this.associatedMap.forceFinishResizing();
                return this.removeImpl(object);
            }
        }

        private boolean removeImpl(Object object) {
            Map.Entry oEntry;
            Entry<KT, VT> entry;
            if (object instanceof Map.Entry && HashMapEntrySet.valuesEq(entry = this.associatedMap.getEntry((oEntry = (Map.Entry)object).getKey()), oEntry)) {
                this.associatedMap.removeEntry(entry);
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry oEntry = (Map.Entry)object;
                Entry<KT, VT> entry = this.associatedMap.getEntry(oEntry.getKey());
                return HashMapEntrySet.valuesEq(entry, oEntry);
            }
            return false;
        }

        private static boolean valuesEq(Entry entry, Map.Entry<?, ?> oEntry) {
            return entry != null && (entry.value == null ? oEntry.getValue() == null : PauselessHashMap.areEqualValues(entry.value, oEntry.getValue()));
        }

        @Override
        public Iterator<Map.Entry<KT, VT>> iterator() {
            return new EntryIterator<KT, VT>(this.associatedMap);
        }
    }

    private static class ValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<V> {
        ValueIterator(PauselessHashMap<K, V> map) {
            super(map);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    private static class KeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<K> {
        KeyIterator(PauselessHashMap<K, V> map) {
            super(map);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    private static class EntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(PauselessHashMap<K, V> map) {
            super(map);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    private static class AbstractMapIterator<K, V> {
        private int position = 0;
        int expectedModCount;
        Entry<K, V> futureEntry;
        Entry<K, V> currentEntry;
        Entry<K, V> prevEntry;
        final PauselessHashMap<K, V> associatedMap;

        AbstractMapIterator(PauselessHashMap<K, V> hm) {
            this.associatedMap = hm;
            this.expectedModCount = hm.modCount;
            this.futureEntry = null;
            this.associatedMap.forceFinishResizing();
        }

        public boolean hasNext() {
            if (this.futureEntry != null) {
                return true;
            }
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.associatedMap.resizingIntoElementData != null) {
                throw new ConcurrentModificationException();
            }
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.futureEntry == null) {
                this.currentEntry = this.associatedMap.elementData[this.position++];
                this.futureEntry = this.currentEntry.next;
                this.prevEntry = null;
            } else {
                if (this.currentEntry != null) {
                    this.prevEntry = this.currentEntry;
                }
                this.currentEntry = this.futureEntry;
                this.futureEntry = this.futureEntry.next;
            }
        }

        public final void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            if (this.prevEntry == null) {
                int index = this.currentEntry.origKeyHash & this.associatedMap.elementData.length - 1;
                this.associatedMap.elementData[index] = this.associatedMap.elementData[index].next;
            } else {
                this.prevEntry.next = this.currentEntry.next;
            }
            this.currentEntry = null;
            ++this.expectedModCount;
            ++this.associatedMap.modCount;
            --this.associatedMap.elementCount;
        }
    }

    static class Entry<K, V>
    extends InternalMapEntry<K, V> {
        final int origKeyHash;
        Entry<K, V> next;
        boolean isValid = true;

        Entry(K theKey, int hash) {
            super(theKey, null);
            this.origKeyHash = hash;
        }

        Entry(K theKey, V theValue) {
            super(theKey, theValue);
            this.origKeyHash = theKey == null ? 0 : PauselessHashMap.computeHashCode(theKey);
        }

        void setInvalid() {
            this.isValid = false;
        }

        void setValid() {
            this.isValid = true;
        }

        boolean isValid() {
            return this.isValid;
        }

        @Override
        public Object clone() {
            Entry entry = (Entry)super.clone();
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }
    }
}

