<a href="https://www.taoensso.com" title="More stuff by @ptaoussanis at www.taoensso.com">
<img src="https://www.taoensso.com/taoensso-open-source.png" alt="Taoensso open-source" width="400"/></a>

**[CHANGELOG]** | [API] | current [Break Version]:

```clojure
[com.taoensso/tukey "1.0.0-SNAPSHOT"] ; Early access (pre-release)
```

<!-- ![build status](https://github.com/ptaoussanis/tukey/workflows/build/badge.svg?branch=master) -->

> See [here](https://taoensso.com/clojure/backers) if you're interested in helping support my open-source work, thanks! - Peter Taoussanis

# Tukey

### Simple stats toolkit for Clojure/Script

A collection of commonly-useful cross-platform statistical and mathematical utils I've needed for machine-learning or other applications.

> John Wilder **Tukey** (1915 – 2000) was an American mathematician best known for development of the Fast Fourier Transform (FFT) algorithm and box plot. The _Tukey range test_, the _Tukey lambda distribution_, the _Tukey test of additivity_, and the _Teichmüller–Tukey lemma_ all bear his name. He is also credited with coining the term 'bit'.

## Features

 * Small, **fast**, cross-platform Clojure/Script codebase.
 * Pleasant, consistant API with **beginner-friendly documentation**.
 * **PRs welcome** for additional functionality, documentation improvements, etc.!

## Quickstart

Add the necessary dependency to your project:

```clojure
[com.taoensso/tukey "1.0.0-SNAPSHOT"]
```

And setup your namespace imports:

```clojure
(ns my-ns 
  (:require [taoensso.tukey :as tukey]))
```

Please check out the extensive [API] docs for more info from here!

## Contacting me / contributions

Please use the project's [GitHub issues page] for all questions, ideas, etc. **Pull requests welcome**. See the project's [GitHub contributors page] for a list of contributors.

Otherwise, you can reach me at [Taoensso.com]. Happy hacking!

\- [Peter Taoussanis]

## License

Distributed under the [EPL v1.0] \(same as Clojure).  
Copyright &copy; 2020 [Peter Taoussanis].

<!--- Standard links -->
[Taoensso.com]: https://www.taoensso.com
[Peter Taoussanis]: https://www.taoensso.com
[@ptaoussanis]: https://www.taoensso.com
[More by @ptaoussanis]: https://www.taoensso.com
[Break Version]: https://github.com/ptaoussanis/encore/blob/master/BREAK-VERSIONING.md

<!--- Standard links (repo specific) -->
[CHANGELOG]: https://github.com/ptaoussanis/tukey/releases
[API]: http://ptaoussanis.github.io/tukey/
[GitHub issues page]: https://github.com/ptaoussanis/tukey/issues
[GitHub contributors page]: https://github.com/ptaoussanis/tukey/graphs/contributors
[EPL v1.0]: https://raw.githubusercontent.com/ptaoussanis/tukey/master/LICENSE
[Hero]: https://raw.githubusercontent.com/ptaoussanis/tukey/master/hero.png "Title"

<!--- Unique links -->
