(ns taoensso.tukey
  "Mini stats toolkit for Clojure/Script.
  EXPERIMENTAL, everything < v1.0 still very likely to break without
  notice!

  Design note:
    There's a huge amount of nuanced behaviour that one might like to
    control with a numerics/stats library, especially re: performance
    and efficiency.

    Rather than try to cater to a wide range of use cases (which would
    significantly bloat both the API and implementation), Tukey's focus
    is on simplicity, ease-of-use, pedagogy, and Clj/s cross-platform
    compatibility.

    Performance is a secondary objective.
    Customizability a tertiary one.

    Tukey will generally err on the side of common presumptions, and
    will generally focus only on the most common needs.

    For very fine control or performance optimization, specialized
    libraries often exist. Otherwise the relevant Tukey code can always
    serve as an example to be extracted and customized.

    One noteable example of this philosophy: Tukey's API and internals
    tend to use only standard fixed-precision doubles. Exceptions to
    this will be clearly noted."

  {:author "Peter Taoussanis (@ptaoussanis)"}
  (:require
   [taoensso.encore :as enc :refer [have have? have!]]
   [taoensso.tukey.impl :as impl]
   [taoensso.tukey.sstats :as sstats]))

(enc/assert-min-encore-version [3 45 0])

;;;;

(do
  (enc/defalias sstats/summary-stats)
  (enc/defalias sstats/summary-stats?)
  (enc/defalias sstats/summary-stats-merge)
  (enc/defalias sstats/summary-stats-buffered)
  (enc/defalias sstats/summary-stats-buffered?))
