<a href="https://www.taoensso.com/clojure" title="More stuff by @ptaoussanis at www.taoensso.com"><img src="https://www.taoensso.com/open-source.png" alt="Taoensso open source" width="340"/></a>  
[**Documentation**](#documentation) | [Latest releases](#latest-releases) | [Get support][GitHub issues]

# Tempel

### Data security framework for Clojure

**Tempel** is a lightweight encryption framework that wraps the JVM's native crypto facilities to provide a **high-level Clojure API** that is: idiomatic, simple, and **easy-to-use** even for non-experts.

It incorporates **best practices and reasonable defaults**, and includes **detailed beginner-oriented documentation** to greatly simplify many of the most common data security needs.

## Latest release/s

- Coming [~Nov 2023](https://www.taoensso.com/clojure/roadmap)

[![Main tests][Main tests SVG]][Main tests URL]
[![Graal tests][Graal tests SVG]][Graal tests URL]

<!-- TODO See [here][GitHub releases] for earlier releases. -->

## Why Tempel?

- **Easy-to-use, high-level API** focused on common encryption tasks
- Support for **symmetric** and **asymmetric** encryption
- **Reasonable defaults** including choice of algorithms and work factors
- **Future-proof data formats** with support for updated algorithms and work factors over time
- Sensible **key management API** for use in real-world applications
- Automatic **[scrypt](https://en.wikipedia.org/wiki/Scrypt) and [pbkdf2](https://en.wikipedia.org/wiki/PBKDF2) support** for password-based key stretching
- Extensive, beginner-oriented [documentation](#documentation) (work-in-progress)

## Documentation

- [Full documentation][GitHub wiki] (**getting started** and more)
- Auto-generated API reference: [Codox][Codox docs], [clj-doc][clj-doc docs]

## Funding

You can [help support][sponsor] continued work on this project, thank you!! 🙏

## License

Copyright &copy; 2023 [Peter Taoussanis][].  
Licensed under [EPL 1.0](LICENSE.txt) (same as Clojure).

<!-- Common -->

[GitHub releases]: ../../releases
[GitHub issues]:   ../../issues
[GitHub wiki]:     ../../wiki

[Peter Taoussanis]: https://www.taoensso.com
[sponsor]:          https://www.taoensso.com/sponsor

<!-- Project -->

[Codox docs]:   https://taoensso.github.io/tempel/
[clj-doc docs]: https://cljdoc.org/d/com.taoensso/tempel/

[Clojars SVG]: https://img.shields.io/clojars/v/com.taoensso/tempel.svg
[Clojars URL]: https://clojars.org/com.taoensso/tempel

[Main tests SVG]:  https://github.com/taoensso/tempel/actions/workflows/main-tests.yml/badge.svg
[Main tests URL]:  https://github.com/taoensso/tempel/actions/workflows/main-tests.yml
[Graal tests SVG]: https://github.com/taoensso/tempel/actions/workflows/graal-tests.yml/badge.svg
[Graal tests URL]: https://github.com/taoensso/tempel/actions/workflows/graal-tests.yml
