(ns taoensso.telemere.tools-logging
  "Private ns, implementation detail.
  Interop support: `tools.logging` -> Telemere."
  (:require
   [taoensso.encore        :as enc :refer [have have?]]
   [taoensso.telemere.impl :as impl]
   [clojure.tools.logging]))

;;;; TODO
;; - First impln, Ref. <https://github.com/clojure/tools.logging/blob/master/src/main/clojure/clojure/tools/logging/impl.clj>
;; - Priority: [SLF4j Apache-Commons-Logging Log4j2 Log4j Java-Util-Logging]

(deftype TelemereLogger [logger-ns]
  clojure.tools.logging.impl/Logger
  (enabled? [_ level])
  (write!   [_ level throwable message]
    ;; TODO Use {:always? true} to avoid duplicate filtering
    ))

(deftype TelemereLoggerFactory []
  clojure.tools.logging.impl/LoggerFactory
  (name       [_          ] "taoensso.telemere")
  (get-logger [_ logger-ns] (TelemereLogger. (str logger-ns))))

(defn ^:public tools-logging->telemere!
  "TODO, `clojure.tools.logging` -> Telemere."
  [{:keys []}]
  (alter-var-root #'clojure.tools.logging/*logger-factory*
    (fn [_] (TelemereLoggerFactory.))))
