(defproject com.taoensso/telemere-shell "1.0.0-beta24"
  :author "Peter Taoussanis <https://www.taoensso.com>"
  :description "Minimal Telemere shell API for library authors, etc."
  :url "https://www.taoensso.com/telemere"

  :license
  {:name "Eclipse Public License - v 1.0"
   :url  "https://www.eclipse.org/legal/epl-v10.html"}

  :scm {:name "git" :url "https://github.com/taoensso/telemere"}

  :dependencies []
  :profiles
  {:provided
   {:dependencies
    [[org.clojure/clojurescript "1.11.132"]
     [org.clojure/clojure       "1.12.0"]
     [com.taoensso/telemere     "1.0.0-beta24"]]}

   :dev
   {:plugins
    [[lein-pprint    "1.3.2"]
     [lein-ancient   "0.7.0"]
     [lein-cljsbuild "1.1.8"]]}}

  :cljsbuild
  {:test-commands {"node" ["node" "target/test.js"]}
   :builds
   [{:id :main
     :source-paths ["src"]
     :compiler
     {:output-to "target/main.js"
      :optimizations :advanced}}

    {:id :test
     :source-paths ["src" "test"]
     :compiler
     {:output-to "target/test.js"
      :target :nodejs
      :optimizations :simple}}]}

  :aliases
  {"build-once" ["do" ["clean"] ["cljsbuild" "once"]]
   "deploy-lib" ["do" ["build-once"] ["deploy" "clojars"] ["install"]]})
