(ns taoensso.telemere.api
  "TODO"
  #?(:clj  (:require [clojure.java.io :as jio])
     :cljs (:require-macros [taoensso.telemere.api :refer [compile-if]])))

;;;; TODO
;; - Project description, docstrings, etc.
;; - `log!`, etc.

#?(:clj
   (defmacro ^:private compile-if [test then else]
     (if (try (eval test) (catch Throwable _ false)) then else)))

(def telemere-present?
  "Is `taoensso.telemere` present (not necessarily loaded)?"
  (compile-if (jio/resource "taoensso/telemere.cljc") true false))

#?(:clj
   (defmacro require-telemere-if-present
     "Experimental, subject to change without notice!
     Requires Telemere if it's present, otherwise noops.
     For Cljs: needs ClojureScript >= v1.9.293, and must be placed at top of file.
     Used in cooperation with `signal!`."
     [] (when telemere-present? `(require 'taoensso.telemere))))

(comment (require-telemere-if-present))

#?(:clj
   (defmacro signal!
     "Experimental, subject to change without notice!
     Expands to `taoensso.telemere/signal!` call if Telemere is present,
     otherwise expands to arbitrary `fallback` form.

     MUST be used with `require-telemere-if-present`:

       (ns my-ns (:require [taoensso.telemere.api :as t]))
       (t/require-telemere-if-present) ; At top of file, just below `ns` form

       (t/signal!
         {<signal-opts>,
          :fallback ; `tools.logging` or `println` call, etc.
          (println \"Prints iff Telemere not present\")})

     For more info, see:
       - Telemere `signal!`, Ref. <https://www.taoensso.com/telemere/signal!>
       - Telemere API,       Ref. <https://www.taoensso.com/telemere/api>
       - Telemere Wiki docs, Ref. <https://www.taoensso.com/telemere/wiki>"

     {:arglists #_(taoensso.telemere.impl/signal-arglists :signal!) ; + fallback
      '([{:as opts
          :keys
          [#_defaults #_elide? #_allow? #_expansion-id, ; Undocumented
           fallback, ; Unique to `facade`
           elidable? location #_location* inst uid middleware,
           sample-rate kind ns id level when rate-limit,
           ctx parent root trace?, do let data msg error run & kvs]}])}

     [opts]
     (if (map? opts)
       (if-not telemere-present?
         (get opts :fallback)
         (do
           (require 'taoensso.telemere) ; For macro expansion
           (with-meta ; Keep callsite
             `(taoensso.telemere/signal! ~(dissoc opts :fallback))
             (meta &form))))
       (throw
         (ex-info "`signal!` expects map opts"
           {:given {:value opts, :type (type opts)}})))))

(comment
  (macroexpand
    '(signal!
       {:level :warn :let [x :x] :msg ["Hello" "world" x] :data {:a :A :x x}
        :fallback (println ["fallback" x])})))
