(ns taoensso.sente.interfaces
  "Experimental - subject to change!
  Public interfaces / extension points."
                                                      
         (:require [cljs.reader              :as edn]
                   [taoensso.encore :as enc :refer (debugf)]
                   ))

;;;; Network channels

     
                                 
                                                                            
                               
                                                                       
                                                                     
                                          

                                                    
                                              

     
                                        
                                                                               
                                             
                                                                
                                                                                
                                                                         
                                          

                                                                 
                                                                              
                              
                                                                           
                                                                 
                                                                            
                                                                                     

;;;; Packers

(defprotocol IPacker
  "Extension pt. for client<->server comms data un/packers:
  arbitrary Clojure data <-> serialized strings."
  (pack   [_ x])
  (unpack [_ x]))

(deftype EdnPacker []
  IPacker
  (pack   [_ x] (pr-str x))
  (unpack [_ s] (edn/read-string s)))

(def     edn-packer "Default Edn packer." (->EdnPacker))
(defn coerce-packer [x]
                                                   
         (debugf "Compare: %s" [x (= x :edn)])
  (if (= x :edn) edn-packer
    (do (assert (satisfies? IPacker x)) x)))

;;;;;;;;;;;; This file autogenerated from src/taoensso/sente/interfaces.cljx
