(ns taoensso.sente.server-adapters.jetty9
  "Sente adapter for ring-jetty9-adapter,
  (https://github.com/sunng87/ring-jetty9-adapter)."

  {:author "Thomas Crowley (@wavejumper)"}
  (:require [clojure.string :as str]
            [ring.adapter.jetty9.websocket :as jetty9.websocket]
            [ring.adapter.jetty9 :as jetty]
            [taoensso.sente.interfaces :as i]))

(defn- ajax-cbs [sch]
  {:write-failed  (fn [_throwable] (jetty9.websocket/close! sch))
   :write-success (fn [          ] (jetty9.websocket/close! sch))})

(extend-type org.eclipse.jetty.websocket.api.WebSocketAdapter
  i/IServerChan
  (sch-open?  [sch] (jetty9.websocket/connected? sch))
  (sch-close! [sch] (jetty9.websocket/close!     sch))
  (sch-send!  [sch websocket? msg]
    (if websocket?
      (jetty9.websocket/send! sch msg)
      (jetty9.websocket/send! sch msg (ajax-cbs sch)))))

(defn- server-ch-resp
  [websocket? {:keys [on-open on-close on-msg on-error]}]
  (jetty/ws-upgrade-response
   {:on-connect (fn [sch]          (on-open  sch websocket?))
    :on-text    (fn [sch msg]      (on-msg   sch websocket? msg))
    :on-error   (fn [sch error]    (on-error sch websocket? error))
    :on-close   (fn [sch status _] (on-close sch websocket? status))}))

(deftype JettyServerChanAdapter []
  i/IServerChanAdapter
  (ring-req->server-ch-resp [_ req callbacks-map]
    (server-ch-resp (jetty/ws-upgrade-request? req) callbacks-map)))

(defn get-sch-adapter [] (JettyServerChanAdapter.))
