(ns taoensso.sente.packers.transit
  "Alpha - subject to change!
  Optional Transit-format[1] IPacker implementation for use with Sente.
  [1] https://github.com/cognitect/transit-format."
  {:author "Peter Taoussanis, @ckarlsen84"}

       
           
                                      
                                                                
                                         
                                          
                                                                   

       
                                                                

        
  (:require
   [clojure.string    :as str]
   [taoensso.encore   :as enc :refer-macros (have have! have?)]
   [cognitect.transit :as transit]
   [taoensso.sente.interfaces :as interfaces :refer (pack unpack)]))

     
                                
                                                                             
                                                                  
                                                                     

     
                                  
                                                           
                                                                   
                     
                                         
                                               
                       

     
                                   
                                                            
                                                                    
                     
                                         
                                               
                       

     
                                      
                         
                  
                                             
                                            
                                                                   
                                                  
               
                                  
                                                
                         
                        

(def ^:private get-transit-writer-fn
  "Returns thread-safe (fn [x-to-write])"
        
  (enc/memoize_
    (fn [fmt opts]
      (let [writer (transit/writer fmt opts)]
        (fn [x] (transit/write writer x)))))

       
                
                                                                                     
                                                 )

(def ^:private get-transit-reader-fn
  "Returns thread-safe (fn [str-to-read])"
        
  (enc/memoize_
    (fn [fmt opts]
      (let [reader (transit/reader fmt opts)]
        (fn [s] (transit/read reader s)))))

       
                
                                           
                                          
             
                                                      
                                                                   
                                                    
                                   )

(deftype TransitPacker [transit-fmt writer-opts reader-opts]
  taoensso.sente.interfaces/IPacker
  (pack   [_ x] ((get-transit-writer-fn transit-fmt writer-opts) x))
  (unpack [_ s] ((get-transit-reader-fn transit-fmt reader-opts) s)))

(defn get-transit-packer "Returns a new TransitPacker"
  ([           ] (get-transit-packer :json       {} {}))
  ([transit-fmt] (get-transit-packer transit-fmt {} {}))
  ([transit-fmt writer-opts reader-opts]
   ;; No transit-cljs support for msgpack atm
   (have? [:el #{:json #_:msgpack}] transit-fmt)
   (have? map? writer-opts reader-opts)
   (TransitPacker. transit-fmt writer-opts reader-opts)))

(comment
  (def tp (get-transit-packer))
  (enc/qb 10000
    (unpack tp (pack tp [:chsk/ws-ping "foo"]))
    (enc/read-edn (enc/pr-edn [:chsk/ws-ping "foo"]))))

;;;;;;;;;;;; This file autogenerated from src/taoensso/sente/packers/transit.cljx
