(ns taoensso.sente.interfaces
  "Experimental (pre-alpha): subject to change.
  Public interfaces / extension points."
         (:require [clojure.tools.reader.edn :as edn])
                                                      )

;;;; Servers

      (defprotocol IAsyncHTTPServer "TODO: Extension pt. for HTTP servers.")

;;;; Packers

(defprotocol IPacker
  "Extension pt. for client<->server comms data un/packers:
  encoded strings <-> arbitrary Clojure data."
  (pack   [_ x])
  (unpack [_ x]))

(deftype EdnPacker []
  IPacker
  (pack   [_ x] (pr-str x))
  (unpack [_ s] (edn/read-string s)))

(def     edn-packer "Default Edn packer." (->EdnPacker))
(defn coerce-packer [x] (if (= x :edn) edn-packer
                          (do (assert (satisfies? IPacker x)) x)))

;;;;;;;;;;;; This file autogenerated from src/taoensso/sente/interfaces.cljx
