(ns taoensso.sente.interfaces
  "Experimental (pre-alpha): subject to change.
  Public interfaces / extension points."
  #+clj  (:require [clojure.tools.reader.edn :as edn])
  #+cljs (:require [cljs.reader              :as edn]))

;;;; Servers

#+clj
(defprotocol IAsyncHTTPServer
  "TODO: Extension pt. for HTTP servers.")

;;;; Packers

(defprotocol IPacker
  "Extension pt. for client<->server comms data un/packers:
  encoded strings <-> arbitrary Clojure data."
  (pack   [_ x])
  (unpack [_ x]))

(deftype EdnPacker []
  IPacker
  (pack   [_ x] (pr-str x))
  (unpack [_ s] (edn/read-string s)))

(def     edn-packer "Default Edn packer." (->EdnPacker))
(defn coerce-packer [x] (if (= x :edn) edn-packer
                          (do (assert (satisfies? IPacker x)) x)))

(comment ; Seems over-engineered
  (defn pack   [packer x & [?opts]] (pack*   packer x (or ?opts {})))
  (defn unpack [packer x & [?opts]] (unpack* packer x (or ?opts {})))
  (defn merge-opts "Merges opts maps for buffered evs, etc."
    [packer opts-coll] (merge-opts* packer opts-coll)))
